/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.fetcher;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import studio.raptor.cmdb.Config;
import studio.raptor.cmdb.ConfigFile;
import studio.raptor.cmdb.ConfigService;
import studio.raptor.cmdb.core.enums.ConfigFileFormat;
import studio.raptor.ddal.common.exception.GenericException;
import studio.raptor.ddal.config.fetcher.ConfigFetcher;
import studio.raptor.ddal.config.fetcher.LocalConfigFetcher;

public abstract class RemoteConfigFetcher
extends ConfigFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalConfigFetcher.class);

    @Override
    public String getFileString(String filePath) throws GenericException {
        Preconditions.checkNotNull((Object)filePath, (Object)"filePath can not be null");
        LOGGER.info("Get file string from remote system, file namespace: {}", (Object)filePath);
        ConfigFile configFile = ConfigService.getConfigFile((String)filePath, (ConfigFileFormat)ConfigFileFormat.XML);
        return configFile.getContent();
    }

    @Override
    public String fetchingMode() {
        return "R";
    }

    @Override
    public Map<String, String> getProperties(String filePath) throws GenericException {
        Preconditions.checkNotNull((Object)filePath, (Object)"filePath can not be null");
        LOGGER.info("Get properties from remote system, file namespace: {}", (Object)filePath);
        return RemoteConfigFetcher.config2Map(ConfigService.getConfig((String)filePath));
    }

    private static Map<String, String> config2Map(Config config) {
        Set keys = config.getPropertyNames();
        HashMap<String, String> routeMapping = new HashMap<String, String>(keys.size());
        for (String key : keys) {
            String value = config.getProperty(key, null);
            routeMapping.put(key, value);
        }
        return routeMapping;
    }
}

