/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import studio.raptor.ddal.common.exception.GenericException;
import studio.raptor.ddal.config.exception.ConfigErrCodes;
import studio.raptor.ddal.config.io.FileLocatorUtils;
import studio.raptor.ddal.config.io.FileSystem;

public class DefaultFileSystem
extends FileSystem {
    private static Logger logger = LoggerFactory.getLogger(DefaultFileSystem.class);

    @Override
    public InputStream getInputStream(URL url) throws GenericException {
        File file = FileLocatorUtils.fileFromURL(url);
        if (file != null && file.isDirectory()) {
            throw new GenericException(ConfigErrCodes.CONFIG_107);
        }
        try {
            return url.openStream();
        }
        catch (Exception e) {
            throw new GenericException(ConfigErrCodes.CONFIG_108, (Throwable)e);
        }
    }

    @Override
    public OutputStream getOutputStream(URL url) throws GenericException {
        throw new RuntimeException("Unsupported operation getOutputStream");
    }

    @Override
    public OutputStream getOutputStream(File file) throws GenericException {
        throw new RuntimeException("Unsupported operation getOutputStream");
    }

    @Override
    public String getPath(File file, URL url, String basePath, String fileName) {
        String path = null;
        if (file != null) {
            path = file.getAbsolutePath();
        }
        if (path == null) {
            if (url != null) {
                path = url.getPath();
            } else {
                try {
                    path = this.getURL(basePath, fileName).getPath();
                }
                catch (Exception e) {
                    logger.debug(String.format("Could not determine URL for basePath = %s, fileName = %s: %s", basePath, fileName, e));
                }
            }
        }
        return path;
    }

    @Override
    public String getBasePath(String path) {
        try {
            URL url = this.getURL(null, path);
            return FileLocatorUtils.getBasePath(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getFileName(String path) {
        try {
            URL url = this.getURL(null, path);
            return FileLocatorUtils.getFileName(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public URL getURL(String basePath, String file) throws MalformedURLException {
        File f = new File(file);
        if (f.isAbsolute()) {
            return FileLocatorUtils.toURL(f);
        }
        try {
            if (basePath == null) {
                return new URL(file);
            }
            URL base = new URL(basePath);
            return new URL(base, file);
        }
        catch (MalformedURLException uex) {
            return FileLocatorUtils.toURL(FileLocatorUtils.constructFile(basePath, file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL locateFromURL(String basePath, String fileName) {
        try {
            if (basePath == null) {
                return new URL(fileName);
            }
            URL baseURL = new URL(basePath);
            URL url = new URL(baseURL, fileName);
            try (InputStream in = null;){
                in = url.openStream();
            }
            return url;
        }
        catch (IOException e) {
            logger.debug("Could not locate file " + fileName + " at " + basePath + ": " + e.getMessage());
            return null;
        }
    }
}

