/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.io;

import java.io.File;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import studio.raptor.ddal.config.io.FileLocator;
import studio.raptor.ddal.config.io.FileLocatorUtils;

public class FileHandler {
    private final AtomicReference<FileLocator> fileLocator;

    public FileHandler(FileLocator locator) {
        this.fileLocator = new AtomicReference<FileLocator>(locator);
    }

    private static File createFile(FileLocator loc) {
        if (loc.getFileName() == null && loc.getSourceURL() == null) {
            return null;
        }
        if (loc.getSourceURL() != null) {
            return FileLocatorUtils.fileFromURL(loc.getSourceURL());
        }
        return FileLocatorUtils.getFile(loc.getBasePath(), loc.getFileName());
    }

    public URL getURL() {
        FileLocator locator = this.getFileLocator();
        return locator.getSourceURL() != null ? locator.getSourceURL() : FileLocatorUtils.locate(locator);
    }

    public File getFile() {
        return FileHandler.createFile(this.getFileLocator());
    }

    public FileLocator getFileLocator() {
        return this.fileLocator.get();
    }
}

