/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.io;

import java.net.URL;
import studio.raptor.ddal.common.builder.EqualsBuilder;
import studio.raptor.ddal.common.builder.HashCodeBuilder;
import studio.raptor.ddal.config.io.FileLocationStrategy;
import studio.raptor.ddal.config.io.FileSystem;

public final class FileLocator {
    private final String fileName;
    private final String basePath;
    private final URL sourceURL;
    private final String encoding;
    private final FileSystem fileSystem;
    private final FileLocationStrategy locationStrategy;

    public FileLocator(FileLocatorBuilder builder) {
        this.fileName = builder.fileName;
        this.basePath = builder.basePath;
        this.sourceURL = builder.sourceURL;
        this.encoding = builder.encoding;
        this.fileSystem = builder.fileSystem;
        this.locationStrategy = builder.locationStrategy;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public URL getSourceURL() {
        return this.sourceURL;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public FileLocationStrategy getLocationStrategy() {
        return this.locationStrategy;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getFileName()).append((Object)this.getBasePath()).append((Object)this.sourceURLAsString()).append((Object)this.getEncoding()).append((Object)this.getFileSystem()).append((Object)this.getLocationStrategy()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileLocator)) {
            return false;
        }
        FileLocator c = (FileLocator)obj;
        return new EqualsBuilder().append((Object)this.getFileName(), (Object)c.getFileName()).append((Object)this.getBasePath(), (Object)c.getBasePath()).append((Object)this.sourceURLAsString(), (Object)c.sourceURLAsString()).append((Object)this.getEncoding(), (Object)c.getEncoding()).append((Object)this.getFileSystem(), (Object)c.getFileSystem()).append((Object)this.getLocationStrategy(), (Object)c.getLocationStrategy()).isEquals();
    }

    public String toString() {
        return "FileLocator{fileName='" + this.fileName + '\'' + ", basePath='" + this.basePath + '\'' + ", sourceURL=" + this.sourceURL + ", encoding='" + this.encoding + '\'' + ", fileSystem=" + this.fileSystem + ", locationStrategy=" + this.locationStrategy + '}';
    }

    private String sourceURLAsString() {
        return this.sourceURL != null ? this.sourceURL.toExternalForm() : "";
    }

    public static final class FileLocatorBuilder {
        private String fileName;
        private String basePath;
        private URL sourceURL;
        private String encoding;
        private FileSystem fileSystem;
        private FileLocationStrategy locationStrategy;

        public FileLocatorBuilder(FileLocator src) {
            if (src != null) {
                this.initBuilder(src);
            }
        }

        public FileLocatorBuilder encoding(String enc) {
            this.encoding = enc;
            return this;
        }

        public FileLocatorBuilder fileSystem(FileSystem fs) {
            this.fileSystem = fs;
            return this;
        }

        public FileLocatorBuilder basePath(String path) {
            this.basePath = path;
            return this;
        }

        public FileLocatorBuilder fileName(String name) {
            this.fileName = name;
            return this;
        }

        public FileLocatorBuilder sourceURL(URL url) {
            this.sourceURL = url;
            return this;
        }

        public FileLocatorBuilder locationStrategy(FileLocationStrategy strategy) {
            this.locationStrategy = strategy;
            return this;
        }

        public FileLocator create() {
            return new FileLocator(this);
        }

        private void initBuilder(FileLocator src) {
            this.basePath = src.getBasePath();
            this.fileName = src.getFileName();
            this.sourceURL = src.getSourceURL();
            this.encoding = src.getEncoding();
            this.fileSystem = src.getFileSystem();
            this.locationStrategy = src.getLocationStrategy();
        }
    }
}

