/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.model.shard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import studio.raptor.ddal.config.model.rule.ShardRule;

public class Table {
    private String name;
    private List<String> databaseShards;
    private ShardRule databaseRule;
    private List<String> actualTables;
    private ShardRule tableRule;
    private boolean hasActualTable = false;
    private String[] shardColumns = new String[0];
    private boolean isMulti = false;
    private boolean isGlobal = false;
    private Table parentTable;
    private boolean isSubTable = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getDatabaseShards() {
        return this.databaseShards;
    }

    public void setDatabaseShards(List<String> databaseShards) {
        this.databaseShards = databaseShards;
    }

    public ShardRule getDatabaseRule() {
        return this.databaseRule;
    }

    public void setDatabaseRule(ShardRule databaseRule) {
        this.databaseRule = databaseRule;
    }

    public List<String> getActualTables() {
        return this.actualTables;
    }

    public void setActualTables(List<String> actualTables) {
        this.actualTables = actualTables;
        this.hasActualTable = true;
    }

    public ShardRule getTableRule() {
        return this.tableRule;
    }

    public void setTableRule(ShardRule tableRule) {
        this.tableRule = tableRule;
    }

    public String[] getShardColumns() {
        return this.shardColumns;
    }

    public void addShardColumns(String[] shardColumns) {
        ArrayList<String> temp = new ArrayList<String>(this.shardColumns.length + shardColumns.length);
        temp.addAll(Arrays.asList(this.shardColumns));
        for (String column : shardColumns) {
            if (temp.contains(column)) continue;
            temp.add(column);
        }
        this.shardColumns = temp.toArray(new String[temp.size()]);
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public void setMulti(boolean multi) {
        this.isMulti = multi;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    public Table getParentTable() {
        return this.parentTable;
    }

    public void setParentTable(Table parentTable) {
        this.parentTable = parentTable;
    }

    public boolean isSubTable() {
        return this.isSubTable;
    }

    public void setSubTable(boolean subTable) {
        this.isSubTable = subTable;
    }

    public boolean hasActualTable() {
        return this.hasActualTable;
    }

    public void setActualTable(boolean hasActualTable) {
        this.hasActualTable = hasActualTable;
    }

    public String toString() {
        return "Table{name='" + this.name + '\'' + ", databaseShards=" + this.databaseShards + ", databaseRule=" + this.databaseRule + ", actualTables=" + this.actualTables + ", tableRule=" + this.tableRule + ", shardColumns=" + Arrays.toString(this.shardColumns) + ", isMulti=" + this.isMulti + ", isGlobal=" + this.isGlobal + ", parentTable=" + this.parentTable + ", isSubTable=" + this.isSubTable + '}';
    }
}

