/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.model.shard;

import java.util.ArrayList;
import studio.raptor.ddal.common.exception.GenericException;
import studio.raptor.ddal.config.exception.ConfigErrCodes;
import studio.raptor.ddal.config.model.shard.Shards;
import studio.raptor.ddal.config.model.shard.Table;
import studio.raptor.ddal.config.model.shard.Tables;

public class VirtualDb {
    private String name;
    private boolean rmOwner;
    private int sqlMaxLimit;
    private String shardGroup;
    private Shards shards;
    private Tables tables;
    private Seqs seqs;

    public VirtualDb() {
    }

    public Table getTable(String tableName) {
        Table table = this.tables.get(tableName);
        if (null == table) {
            throw new GenericException(ConfigErrCodes.CONFIG_109, tableName);
        }
        return table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRmOwner() {
        return this.rmOwner;
    }

    public void setRmOwner(boolean rmOwner) {
        this.rmOwner = rmOwner;
    }

    public int getSqlMaxLimit() {
        return this.sqlMaxLimit;
    }

    public void setSqlMaxLimit(int sqlMaxLimit) {
        this.sqlMaxLimit = sqlMaxLimit;
    }

    public VirtualDb(String name, boolean rmOwner, int sqlMaxLimit, Shards shards, Tables tables, Seqs seqs) {
        this.name = name;
        this.rmOwner = rmOwner;
        this.sqlMaxLimit = sqlMaxLimit;
        this.shards = shards;
        this.tables = tables;
        this.seqs = seqs;
    }

    public String getShardGroup() {
        return this.shardGroup;
    }

    public void setShardGroup(String shardGroup) {
        this.shardGroup = shardGroup;
    }

    public Shards getShards() {
        return this.shards;
    }

    public void setShards(Shards shards) {
        this.shards = shards;
    }

    public Tables getTables() {
        return this.tables;
    }

    public void setTables(Tables tables) {
        this.tables = tables;
    }

    public Seqs getSeqs() {
        return this.seqs;
    }

    public void setSeqs(Seqs seqs) {
        this.seqs = seqs;
    }

    public String toString() {
        return "VirtualDb [name=" + this.name + ", rmOwner=" + this.rmOwner + ", sqlMaxLimit=" + this.sqlMaxLimit + ", tables=" + this.tables + ", seqs=" + this.seqs + "]";
    }

    public static class Seqs
    extends ArrayList<Seq> {
        private static final long serialVersionUID = -5368444663469003836L;
    }

    public static class Seq {
        private String name;
        private String type;
        private String incr;
        private String start;
        private String cache;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getIncr() {
            return this.incr;
        }

        public void setIncr(String incr) {
            this.incr = incr;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getCache() {
            return this.cache;
        }

        public void setCache(String cache) {
            this.cache = cache;
        }

        public String toString() {
            return "Seq [name=" + this.name + ", type=" + this.type + ", incr=" + this.incr + ", start=" + this.start + ", cache=" + this.cache + "]";
        }
    }
}

