/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.parser;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import studio.raptor.ddal.common.exception.GenericException;
import studio.raptor.ddal.config.config.ServerConfig;
import studio.raptor.ddal.config.exception.ConfigErrCodes;
import studio.raptor.ddal.config.model.server.Grant;
import studio.raptor.ddal.config.model.server.Grants;
import studio.raptor.ddal.config.model.server.Params;
import studio.raptor.ddal.config.model.server.User;
import studio.raptor.ddal.config.model.server.Users;

public class ServerConfigParser {
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    public static void parse(ServerConfig serverConfig, String xml) throws GenericException {
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            Document document = builder.parse(is);
            Element root = document.getDocumentElement();
            ServerConfigParser.createParams(serverConfig, root);
            ServerConfigParser.createUsers(serverConfig, root);
            ServerConfigParser.createGrants(serverConfig, root);
        }
        catch (Exception e) {
            throw new GenericException(ConfigErrCodes.CONFIG_103, (Throwable)e, xml);
        }
    }

    private static void createGrants(ServerConfig serverConfig, Element root) throws XPathExpressionException {
        NodeList grantsDom = (NodeList)XPATH.evaluate("grants/grant", root, XPathConstants.NODESET);
        Grants grants = new Grants();
        for (int i = 0; i < grantsDom.getLength(); ++i) {
            Node grantDom = grantsDom.item(i);
            Grant grant = new Grant();
            grant.setUser(XPATH.evaluate("@user", grantDom));
            grant.setVdbName(XPATH.evaluate("@vdbname", grantDom));
            grant.setRules(ServerConfigParser.createRules(grantDom));
            grants.add(grant);
        }
        serverConfig.setGrants(grants);
    }

    private static Map<String, Grant.Rule> createRules(Node grantDom) throws XPathExpressionException {
        NodeList rulesDom = (NodeList)XPATH.evaluate("rule", grantDom, XPathConstants.NODESET);
        HashMap<String, Grant.Rule> rules = new HashMap<String, Grant.Rule>(rulesDom.getLength());
        for (int i = 0; i < rulesDom.getLength(); ++i) {
            Node ruleDom = rulesDom.item(i);
            Grant.Rule rule = new Grant.Rule();
            rule.setType(XPATH.evaluate("type", ruleDom));
            rule.setObj(XPATH.evaluate("object", ruleDom));
            rule.setPrivilege(XPATH.evaluate("privilege", ruleDom));
            rules.put(rule.getType(), rule);
        }
        return rules;
    }

    private static void createUsers(ServerConfig serverConfig, Element root) throws XPathExpressionException {
        NodeList usersDom = (NodeList)XPATH.evaluate("users/user", root, XPathConstants.NODESET);
        Users users = new Users();
        for (int i = 0; i < usersDom.getLength(); ++i) {
            Node userDom = usersDom.item(i);
            User user = new User();
            user.setName(XPATH.evaluate("@name", userDom));
            user.setPwd(XPATH.evaluate("@pwd", userDom));
            User.AccessPolicy acceptAp = ServerConfigParser.createAccessPolicy(userDom);
            user.setAccessPolicy(acceptAp);
            users.add(user);
        }
        serverConfig.setUsers(users);
    }

    private static User.AccessPolicy createAccessPolicy(Node userDom) throws XPathExpressionException {
        Node accessPolicyDom = (Node)XPATH.evaluate("accessPolicy", userDom, XPathConstants.NODE);
        if (null != accessPolicyDom) {
            NodeList ipsDom = (NodeList)XPATH.evaluate("ip", accessPolicyDom, XPathConstants.NODESET);
            String[] ips = new String[ipsDom.getLength()];
            for (int i = 0; i < ipsDom.getLength(); ++i) {
                Node ipDom = ipsDom.item(i);
                ips[i] = ipDom.getTextContent();
            }
            User.AccessPolicy ap = new User.AccessPolicy(XPATH.evaluate("@type", accessPolicyDom), ips);
            return ap;
        }
        return null;
    }

    private static void createParams(ServerConfig serverConfig, Element root) throws XPathExpressionException {
        NodeList paramsDom = (NodeList)XPATH.evaluate("params/param", root, XPathConstants.NODESET);
        Params params = new Params();
        for (int i = 0; i < paramsDom.getLength(); ++i) {
            Node paramDom = paramsDom.item(i);
            params.put(XPATH.evaluate("@name", paramDom), paramDom.getTextContent());
        }
        serverConfig.setParams(params);
    }
}

