/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.reloading;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import studio.raptor.ddal.config.reloading.ReloadingController;

public class PeriodicReloadingTrigger {
    private final ScheduledExecutorService executorService;
    private final ReloadingController controller;
    private final Object controllerParam;
    private final long fixedDelay;
    private final TimeUnit timeUnit;
    private ScheduledFuture<?> triggerTask;

    public PeriodicReloadingTrigger(ReloadingController ctrl, Object ctrlParam, long fixedDelay, TimeUnit unit, ScheduledExecutorService exec) {
        if (ctrl == null) {
            throw new IllegalArgumentException("ReloadingController must not be null!");
        }
        this.controller = ctrl;
        this.controllerParam = ctrlParam;
        this.fixedDelay = fixedDelay;
        this.timeUnit = unit;
        this.executorService = exec != null ? exec : PeriodicReloadingTrigger.createDefaultExecutorService();
    }

    public PeriodicReloadingTrigger(ReloadingController ctrl, Object ctrlParam, long triggerPeriod, TimeUnit unit) {
        this(ctrl, ctrlParam, triggerPeriod, unit, null);
    }

    public synchronized void start() {
        if (!this.isRunning()) {
            this.triggerTask = this.getExecutorService().scheduleWithFixedDelay(this.createTriggerTaskCommand(), this.fixedDelay, this.fixedDelay, this.timeUnit);
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.triggerTask.cancel(false);
            this.triggerTask = null;
        }
    }

    public synchronized boolean isRunning() {
        return this.triggerTask != null;
    }

    public void shutdown(boolean shutdownExecutor) {
        this.stop();
        if (shutdownExecutor) {
            this.getExecutorService().shutdown();
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    private Runnable createTriggerTaskCommand() {
        return new Runnable(){

            @Override
            public void run() {
                PeriodicReloadingTrigger.this.controller.checkForReloading(PeriodicReloadingTrigger.this.controllerParam);
            }
        };
    }

    private static ScheduledExecutorService createDefaultExecutorService() {
        return Executors.newScheduledThreadPool(1, new ReloadingNamingThreadFactory("ReloadingTrigger-%s"));
    }

    private static class ReloadingNamingThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadCounter;
        private final String namingPattern;

        private ReloadingNamingThreadFactory(String namingPattern) {
            this.namingPattern = namingPattern;
            this.threadCounter = new AtomicLong(0L);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            if (this.namingPattern != null) {
                Long count = this.threadCounter.incrementAndGet();
                thread.setName(String.format(this.namingPattern, count));
            }
            return thread;
        }
    }
}

