/*
 * Decompiled with CFR 0.152.
 */
package studio.raptor.ddal.config.reloading;

import studio.raptor.ddal.common.event.NativeEventBus;
import studio.raptor.ddal.config.event.LocalShardConfigChangeEvent;
import studio.raptor.ddal.config.reloading.ReloadingDetector;

public class ReloadingController {
    private final ReloadingDetector detector;
    private boolean reloadingState;

    public ReloadingController(ReloadingDetector detector) {
        if (null == detector) {
            throw new IllegalArgumentException("ReloadingDetector must not be null!");
        }
        this.detector = detector;
    }

    public ReloadingDetector getDetector() {
        return this.detector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForReloading(Object data) {
        boolean sendEvent = false;
        ReloadingController reloadingController = this;
        synchronized (reloadingController) {
            if (this.isInReloadingState()) {
                return true;
            }
            if (this.getDetector().isReloadingRequired()) {
                sendEvent = true;
                this.reloadingState = true;
            }
        }
        if (sendEvent) {
            NativeEventBus.get().post((Object)new LocalShardConfigChangeEvent(this, null));
            return true;
        }
        return false;
    }

    public synchronized boolean isInReloadingState() {
        return this.reloadingState;
    }

    public synchronized void resetReloadingState() {
        if (this.isInReloadingState()) {
            this.getDetector().reloadingPerformed();
            this.reloadingState = false;
        }
    }
}

