/*
 * Decompiled with CFR 0.152.
 */
package systems.helius.commons.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import systems.helius.commons.annotations.Internal;

public class BiDirectionalMap<K, T>
implements Map<K, T> {
    protected Map<K, T> keyToValue;
    protected Map<T, K> valueToKey;

    public BiDirectionalMap() {
        this.keyToValue = new HashMap<K, T>();
        this.valueToKey = new HashMap<T, K>();
    }

    @Internal
    public BiDirectionalMap(Map<K, T> keyMap, Map<T, K> valueMap) {
        if (!keyMap.isEmpty()) {
            throw new IllegalArgumentException("keyMap must be empty");
        }
        if (!valueMap.isEmpty()) {
            throw new IllegalArgumentException("valueMap must be empty");
        }
        this.keyToValue = keyMap;
        this.valueToKey = valueMap;
    }

    @Override
    public int size() {
        return this.keyToValue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValue.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValue.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueToKey.containsKey(value);
    }

    @Override
    public T get(Object key) {
        return this.keyToValue.get(key);
    }

    @Override
    public T put(K key, T value) {
        T original = this.keyToValue.put(key, value);
        this.valueToKey.put(value, key);
        return original;
    }

    @Override
    public T remove(Object key) {
        T original = this.keyToValue.remove(key);
        if (original != null) {
            this.valueToKey.remove(original);
        }
        return original;
    }

    @Override
    public void putAll(Map<? extends K, ? extends T> m) {
        for (Map.Entry<K, T> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.keyToValue.clear();
        this.valueToKey.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.keyToValue.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.valueToKey.keySet();
    }

    @Override
    public Set<Map.Entry<K, T>> entrySet() {
        return this.keyToValue.entrySet();
    }
}

