/*
 * Decompiled with CFR 0.152.
 */
package systems.helius.commons.reflection;

import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import systems.helius.commons.reflection.ClassInspector;
import systems.helius.commons.reflection.IntrospectionSettings;
import systems.helius.commons.reflection.SyntheticPrimitiveFields;
import systems.helius.commons.reflection.TracedAccessException;

public class BeanIntrospector {
    protected IntrospectionSettings defaults;
    protected Map<Class<?>, MethodHandles.Lookup> privilegedLookups = new ConcurrentHashMap();

    public BeanIntrospector() {
        this.defaults = new IntrospectionSettings();
    }

    public BeanIntrospector(IntrospectionSettings defaults) {
        this.defaults = defaults;
    }

    public <T> Set<T> seek(Class<T> targetType, Object root, MethodHandles.Lookup context) throws IllegalAccessException {
        Set found = Collections.newSetFromMap(new IdentityHashMap());
        Set<Object> visited = Collections.newSetFromMap(new IdentityHashMap());
        try {
            this.depthFirstSearch(targetType, root, null, context, context, this.defaults, found, visited, 0);
        }
        catch (TracedAccessException e) {
            e.setRoot(root);
            if (e.isException()) {
                throw e.toIllegalAccessException();
            }
            throw e.toIllegalAccessError();
        }
        return found;
    }

    protected <T> void depthFirstSearch(Class<T> targetType, Object current, @Nullable Field holdingField, MethodHandles.Lookup rootContext, MethodHandles.Lookup parent, IntrospectionSettings settings, Set<T> found, Set<Object> visited, int depth) throws TracedAccessException {
        if (current == null || depth >= settings.getMaxDepth() || visited.contains(current)) {
            return;
        }
        visited.add(current);
        ++depth;
        if (ClassInspector.evaluateTypingMatch(targetType, current, holdingField != null ? holdingField.getType() : null)) {
            found.add(current);
            if (!settings.isEnterTargetType()) {
                return;
            }
        }
        if (current.getClass().isPrimitive() || ClassInspector.isPrimitiveWrapper(current.getClass())) {
            return;
        }
        if (current instanceof Iterable && !settings.isDetailledIterableCheck() || current instanceof Map && !settings.isDetailledMapCheck() || current.getClass().isArray()) {
            this.iterativeScenario(targetType, rootContext, settings, found, visited, depth, current, parent, holdingField);
        } else {
            MethodHandles.Lookup lookup = this.getPrivilegedLookup(current.getClass(), rootContext, parent, false);
            this.singularObjectScenario(targetType, current, rootContext, settings, found, visited, depth, lookup, holdingField);
        }
    }

    protected <T> void singularObjectScenario(Class<T> targetType, Object current, MethodHandles.Lookup rootContext, IntrospectionSettings settings, Set<T> found, Set<Object> visited, int depth, MethodHandles.Lookup currentPrivilegedLookup, Field holdingField) throws TracedAccessException {
        LinkedHashMap<Class<?>, Field[]> fields = ClassInspector.getAllFieldsHierarchical(current.getClass());
        if (fields.isEmpty()) {
            return;
        }
        for (Map.Entry<Class<?>, Field[]> entry : fields.entrySet()) {
            if (currentPrivilegedLookup.lookupClass() != entry.getKey()) {
                try {
                    currentPrivilegedLookup = this.getPrivilegedLookup(entry.getKey(), currentPrivilegedLookup, rootContext, true);
                }
                catch (TracedAccessException e) {
                    e.addStep(holdingField);
                }
            }
            for (Field field : entry.getValue()) {
                Object value;
                if (Modifier.isStatic(field.getModifiers())) continue;
                try {
                    value = currentPrivilegedLookup.unreflectVarHandle(field).get(current);
                }
                catch (IllegalAccessException e) {
                    if (settings.isIgnoreIllegalAccessError()) continue;
                    throw new TracedAccessException("Couldn't read the value of the field: " + field + ". This should be impossible. Please file an issue at https://github.com/SBeausoleil/helius-commons/issues describing how this happened.", e);
                }
                if (value == null) continue;
                try {
                    this.depthFirstSearch(targetType, value, field, rootContext, currentPrivilegedLookup, settings, found, visited, depth + 1);
                }
                catch (TracedAccessException e) {
                    e.addStep(field);
                }
            }
        }
    }

    protected <T> void iterativeScenario(Class<T> targetType, MethodHandles.Lookup rootContext, IntrospectionSettings settings, Set<T> found, Set<Object> visited, int depth, Object value, MethodHandles.Lookup lookup, Field holdingField) throws TracedAccessException {
        Iterator<Object> it;
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                int LENGTH = Array.getLength(value);
                ArrayList<Object> list = new ArrayList<Object>(LENGTH);
                for (int i = 0; i < LENGTH; ++i) {
                    list.add(Array.get(value, i));
                }
                it = list.iterator();
                holdingField = SyntheticPrimitiveFields.getSyntheticPrimitiveField(value.getClass().getComponentType());
            } else {
                it = Arrays.asList((Object[])value).iterator();
            }
        } else if (value instanceof Iterable) {
            Iterable i = (Iterable)value;
            it = i.iterator();
        } else {
            it = ((Map)value).entrySet().iterator();
        }
        while (it.hasNext()) {
            this.depthFirstSearch(targetType, it.next(), holdingField, rootContext, lookup, settings, found, visited, depth + 1);
        }
    }

    protected MethodHandles.Lookup getPrivilegedLookup(Class<?> target, MethodHandles.Lookup rootContext, MethodHandles.Lookup parent, boolean forSuperclass) throws TracedAccessException {
        MethodHandles.Lookup acquiredAccess = this.privilegedLookups.get(target);
        if (acquiredAccess != null) {
            return acquiredAccess;
        }
        try {
            acquiredAccess = MethodHandles.privateLookupIn(target, parent);
        }
        catch (IllegalAccessException | SecurityException parentException) {
            try {
                acquiredAccess = MethodHandles.privateLookupIn(target, rootContext);
            }
            catch (IllegalAccessException | SecurityException rootContextException) {
                try {
                    acquiredAccess = MethodHandles.privateLookupIn(target, MethodHandles.lookup());
                }
                catch (IllegalAccessException | SecurityException libraryLookupException) {
                    throw new TracedAccessException("Couldn't get privileged lookup access into: " + target.getCanonicalName() + (forSuperclass ? "\n Accessing superclass of: " + parent.lookupClass() : ".\n Parent class: " + parentException.getMessage()) + ",\n root context: " + rootContextException.getMessage() + ",\n library context: " + libraryLookupException.getMessage());
                }
            }
        }
        this.privilegedLookups.put(target, acquiredAccess);
        return acquiredAccess;
    }
}

