/*
 * Decompiled with CFR 0.152.
 */
package systems.helius.commons.reflection;

import jakarta.annotation.Nullable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.WeakHashMap;
import systems.helius.commons.annotations.Unstable;
import systems.helius.commons.collections.BiDirectionalMap;

public final class ClassInspector {
    private static final WeakHashMap<Class<?>, LinkedHashMap<Class<?>, Field[]>> hierarchyCache = new WeakHashMap();
    private static final WeakHashMap<Class<?>, List<Field>> flatCache = new WeakHashMap();
    private static final BiDirectionalMap<Class<?>, Class<?>> PRIMITIVE_WRAPPERS = new BiDirectionalMap(new LinkedHashMap(), new LinkedHashMap());

    @Unstable
    ClassInspector() {
    }

    public static LinkedHashMap<Class<?>, Field[]> getAllFieldsHierarchical(Class<?> clazz) {
        LinkedHashMap<Class<Object>, Object> fields = hierarchyCache.get(clazz);
        if (fields == null) {
            fields = new LinkedHashMap();
            fields.put(clazz, clazz.getDeclaredFields());
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class) && !superClass.equals(Enum.class)) {
                fields.putAll(ClassInspector.getAllFieldsHierarchical(superClass));
            }
            hierarchyCache.put(clazz, fields);
        }
        return fields;
    }

    public static List<Field> getAllFieldsFlat(Class<?> clazz) {
        List<Field> result = flatCache.get(clazz);
        if (result == null) {
            LinkedHashMap<Class<?>, Field[]> fields = ClassInspector.getAllFieldsHierarchical(clazz);
            int reserve = fields.values().stream().mapToInt(field -> ((Field[])field).length).sum();
            Field[] buffer = new Field[reserve];
            int index = 0;
            for (Field[] values : fields.values()) {
                System.arraycopy(values, 0, buffer, index, values.length);
                index += values.length;
            }
            result = Arrays.asList(buffer);
            flatCache.put(clazz, result);
        }
        return result;
    }

    public static boolean evaluateTypingMatch(Class<?> targetType, Object value, @Nullable Class<?> originalType) {
        if (originalType != null) {
            if (originalType == Void.class) {
                return true;
            }
            if (originalType.isPrimitive()) {
                return targetType == PRIMITIVE_WRAPPERS.get(value.getClass());
            }
        }
        return targetType.isAssignableFrom(value.getClass());
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return PRIMITIVE_WRAPPERS.containsKey(clazz);
    }

    static {
        PRIMITIVE_WRAPPERS.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPERS.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPERS.put(Short.class, Short.TYPE);
        PRIMITIVE_WRAPPERS.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPERS.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPERS.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPERS.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPERS.put(Character.class, Character.TYPE);
    }
}

