/*
 * Decompiled with CFR 0.152.
 */
package systems.helius.commons.reflection;

import jakarta.annotation.Nullable;
import java.lang.reflect.Field;
import java.util.Stack;
import systems.helius.commons.annotations.Internal;

@Internal
public class TracedAccessException
extends Exception {
    private static final long serialVersionUID = 1L;
    @Nullable
    private Object root;
    private Stack<Field> trace = new Stack();
    private boolean assertionError;

    public TracedAccessException(String message) {
        super(message);
    }

    public TracedAccessException(String message, Throwable cause) {
        super(message, cause);
    }

    public void addStep(@Nullable Field step) {
        if (step != null) {
            this.trace.push(step);
        }
    }

    private String buildMessage() {
        StringBuilder sb = new StringBuilder(this.getMessage());
        sb.append("Path leading to issue: ");
        if (this.root != null) {
            sb.append("[root]: ");
            sb.append(this.root.getClass().getCanonicalName());
            sb.append(": ");
            sb.append(this.root);
        }
        for (Field step : this.trace) {
            sb.append(step.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean isAssertionError() {
        return this.assertionError;
    }

    public boolean isException() {
        return !this.assertionError;
    }

    public void setAssertionError(boolean assertionError) {
        this.assertionError = assertionError;
    }

    @Nullable
    public Object getRoot() {
        return this.root;
    }

    public void setRoot(@Nullable Object root) {
        this.root = root;
    }

    public IllegalAccessException toIllegalAccessException() {
        IllegalAccessException exception = new IllegalAccessException(this.buildMessage());
        exception.setStackTrace(this.getStackTrace());
        return exception;
    }

    public IllegalAccessError toIllegalAccessError() {
        IllegalAccessError error = new IllegalAccessError(this.buildMessage());
        error.setStackTrace(this.getStackTrace());
        return error;
    }
}

