/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.gen.SrcClass;
import manifold.api.host.IModule;
import manifold.api.type.JavaTypeManifold;
import manifold.js.JavascriptCodeGen;
import manifold.js.JavascriptModel;

public class JavascriptTypeManifold
extends JavaTypeManifold<JavascriptModel> {
    public static final String JS = "js";
    public static final String JST = "jst";
    private static final Set<String> FILE_EXTENSIONS = new HashSet<String>(Arrays.asList("js", "jst"));

    public void init(IModule module) {
        this.init(module, (fqn, files) -> new JavascriptModel(this.getModule().getHost(), (String)fqn, (Set<IFile>)files));
    }

    public boolean handlesFileExtension(String fileExtension) {
        return FILE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        return false;
    }

    protected String contribute(JavaFileManager.Location location, String topLevelFqn, String existing, JavascriptModel model, DiagnosticListener<JavaFileObject> errorHandler) {
        SrcClass srcClass = new JavascriptCodeGen((IFile)model.getFiles().iterator().next(), topLevelFqn).make(errorHandler);
        return srcClass.render(new StringBuilder(), 0).toString();
    }
}

