/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.ext.api.ComparableUsing;
import manifold.science.api.AbstractProductUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.Area;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.VolumeUnit;
import manifold.science.util.Rational;

public final class AreaUnit
extends AbstractProductUnit<LengthUnit, LengthUnit, Area, AreaUnit> {
    private static final UnitCache<AreaUnit> CACHE = new UnitCache();
    public static final AreaUnit BASE = AreaUnit.get(LengthUnit.Meter, LengthUnit.Meter);

    public static AreaUnit get(LengthUnit squareUnit) {
        return AreaUnit.get(squareUnit, squareUnit, null, null, null);
    }

    public static AreaUnit get(LengthUnit widthUnit, LengthUnit lengthUnit) {
        return AreaUnit.get(widthUnit, lengthUnit, null, null, null);
    }

    public static AreaUnit get(LengthUnit widthUnit, LengthUnit lengthUnit, Rational factor, String name, String symbol) {
        AreaUnit unit = new AreaUnit(widthUnit, lengthUnit, factor, name, symbol);
        return (AreaUnit)CACHE.get(unit);
    }

    private AreaUnit(LengthUnit widthUnit, LengthUnit lengthUnit, Rational factor, String name, String symbol) {
        super(widthUnit, lengthUnit == null || lengthUnit != null && null != null && lengthUnit.compareToUsing(null, ComparableUsing.Operator.EQ) ? widthUnit : lengthUnit, factor, name, symbol);
    }

    @Override
    public Area makeDimension(Number amount) {
        return new Area(Rational.get(amount), this);
    }

    @Override
    public String getFullName() {
        LengthUnit lengthUnit = this.getLengthUnit();
        return (lengthUnit == null ? true : (lengthUnit == null || null == null ? false : lengthUnit.compareToUsing(null, ComparableUsing.Operator.EQ))) ? this.getLengthUnit() + "\u00b2" : this.getWidthUnit().getFullName() + "\u00d7" + this.getLengthUnit().getFullName();
    }

    @Override
    public String getFullSymbol() {
        LengthUnit lengthUnit = this.getLengthUnit();
        return (lengthUnit == null ? true : (lengthUnit == null || null == null ? false : lengthUnit.compareToUsing(null, ComparableUsing.Operator.EQ))) ? this.getLengthUnit() + "\u00b2" : this.getWidthUnit().getFullSymbol() + "\u00d7" + this.getLengthUnit().getFullSymbol();
    }

    @Override
    public String getSymbol() {
        if (this.isSquare()) {
            return this.getWidthUnit().getSymbol() + "\u00b2";
        }
        return super.getSymbol();
    }

    public LengthUnit getWidthUnit() {
        return (LengthUnit)this.getLeftUnit();
    }

    public LengthUnit getLengthUnit() {
        return (LengthUnit)this.getRightUnit();
    }

    public boolean isSquare() {
        LengthUnit lengthUnit;
        LengthUnit lengthUnit2 = this.getWidthUnit();
        return lengthUnit2 == (lengthUnit = this.getLengthUnit()) ? true : (lengthUnit2 == null || lengthUnit == null ? false : lengthUnit2.compareToUsing(lengthUnit, ComparableUsing.Operator.EQ));
    }

    public VolumeUnit times(LengthUnit lu) {
        return VolumeUnit.get(lu, this);
    }
}

