/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.ChargeUnit;
import manifold.science.measures.ConductanceUnit;
import manifold.science.measures.Current;
import manifold.science.measures.PotentialUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class CurrentUnit
extends AbstractQuotientUnit<ChargeUnit, TimeUnit, Current, CurrentUnit> {
    private static final UnitCache<CurrentUnit> CACHE = new UnitCache();
    public static final CurrentUnit A;
    public static final CurrentUnit BASE;

    public static CurrentUnit get(ChargeUnit chargeUnit, TimeUnit timeUnit) {
        return CurrentUnit.get(chargeUnit, timeUnit, null, null, null);
    }

    public static CurrentUnit get(ChargeUnit chargeUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        CurrentUnit unit = new CurrentUnit(chargeUnit, timeUnit, factor, name, symbol);
        return (CurrentUnit)CACHE.get(unit);
    }

    private CurrentUnit(ChargeUnit chargeUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        super(chargeUnit, timeUnit, factor, name, symbol);
    }

    @Override
    public Current makeDimension(Number amount) {
        return new Current(Rational.get(amount), this);
    }

    public ChargeUnit getChargeUnit() {
        return (ChargeUnit)this.getLeftUnit();
    }

    public TimeUnit getTimeUnit() {
        return (TimeUnit)this.getRightUnit();
    }

    public ConductanceUnit div(PotentialUnit p) {
        return ConductanceUnit.get(this, p);
    }

    public PotentialUnit div(ConductanceUnit cu) {
        return cu.getPotentialUnit();
    }

    static {
        BASE = A = CurrentUnit.get(ChargeUnit.Coulomb, TimeUnit.Second, CoercionConstants.r.postfixBind(1), "Amperes", "A");
    }
}

