/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.InductanceUnit;
import manifold.science.measures.Resistance;
import manifold.science.measures.ResistanceUnit;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.util.Rational;

public final class Inductance
extends AbstractMeasure<InductanceUnit, Inductance> {
    public Inductance(Rational value, InductanceUnit unit, InductanceUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Inductance(Rational value, InductanceUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public InductanceUnit getBaseUnit() {
        return InductanceUnit.BASE;
    }

    @Override
    public Inductance make(Rational value, InductanceUnit unit, InductanceUnit displayUnit) {
        return new Inductance(value, unit, displayUnit);
    }

    @Override
    public Inductance make(Rational value, InductanceUnit unit) {
        return new Inductance(value, unit);
    }

    public Resistance div(Time time) {
        return new Resistance(this.toBaseNumber().div(time.toBaseNumber()), ResistanceUnit.BASE, ((InductanceUnit)this.getDisplayUnit()).getResistanceUnit());
    }

    public Time div(Resistance resistance) {
        return new Time(this.toBaseNumber().div(resistance.toBaseNumber()), TimeUnit.BASE, ((InductanceUnit)this.getDisplayUnit()).getTimeUnit());
    }
}

