/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Current;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.PotentialUnit;
import manifold.science.measures.Power;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.Resistance;
import manifold.science.measures.ResistanceUnit;
import manifold.science.util.Rational;

public final class Potential
extends AbstractMeasure<PotentialUnit, Potential> {
    public Potential(Rational value, PotentialUnit unit, PotentialUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Potential(Rational value, PotentialUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public PotentialUnit getBaseUnit() {
        return PotentialUnit.BASE;
    }

    @Override
    public Potential make(Rational value, PotentialUnit unit, PotentialUnit displayUnit) {
        return new Potential(value, unit, displayUnit);
    }

    @Override
    public Potential make(Rational value, PotentialUnit unit) {
        return new Potential(value, unit);
    }

    public Power times(Current current) {
        return new Power(this.toBaseNumber().times(current.toBaseNumber()), PowerUnit.BASE, ((PotentialUnit)this.getDisplayUnit()).getPowerUnit());
    }

    public Resistance div(Current i) {
        return new Resistance(this.toBaseNumber().div(i.toBaseNumber()), ResistanceUnit.BASE, ResistanceUnit.get((PotentialUnit)this.getDisplayUnit(), (CurrentUnit)i.getDisplayUnit()));
    }

    public Current div(Resistance r) {
        return new Current(this.toBaseNumber().div(r.toBaseNumber()), CurrentUnit.BASE, ((ResistanceUnit)r.getDisplayUnit()).getCurrentUnit());
    }
}

