/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.unicode.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import systems.uom.unicode.CLDR;
import tec.uom.lib.common.function.IntPrioritySupplier;

class CLDRSystemService
implements SystemOfUnitsService,
IntPrioritySupplier {
    private static final int PRIO = 20;
    final Map<String, SystemOfUnits> souMap = new HashMap<String, SystemOfUnits>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public CLDRSystemService() {
        this.souMap.put(CLDR.class.getSimpleName(), (SystemOfUnits)CLDR.getInstance());
        this.aliases.put("Unicode", CLDR.class.getSimpleName());
    }

    public Collection<SystemOfUnits> getAvailableSystemsOfUnits() {
        return this.souMap.values();
    }

    public SystemOfUnits getSystemOfUnits() {
        return this.getSystemOfUnits(CLDR.class.getSimpleName());
    }

    public SystemOfUnits getSystemOfUnits(String name) {
        String alias = this.aliases.get(name);
        if (alias != null && alias.length() > 0) {
            return this.souMap.get(alias);
        }
        return this.souMap.get(name);
    }

    public int getPriority() {
        return 20;
    }
}

