/*
 * Decompiled with CFR 0.152.
 */
package team.idealstate.hyper.command.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.idealstate.hyper.command.api.Command;
import team.idealstate.hyper.command.api.CommandContext;
import team.idealstate.hyper.command.api.action.ActionInterceptor;
import team.idealstate.hyper.command.api.action.CommandAction;
import team.idealstate.hyper.command.api.argument.ArgumentAcceptor;
import team.idealstate.hyper.command.api.complete.CommandCompleter;
import team.idealstate.hyper.command.api.example.ExampleProvider;
import team.idealstate.hyper.command.api.execute.CommandExecutor;
import team.idealstate.hyper.command.impl.complete.CompleterUtils;
import team.idealstate.hyper.commons.base.AssertUtils;
import team.idealstate.hyper.commons.base.StringUtils;

public class CommandImpl
implements Command {
    private static final Logger logger = LogManager.getLogger(CommandImpl.class);
    private final String description;
    private final List<Command> subCommands = new LinkedList<Command>();
    private Command parent = null;
    private boolean parentHasBeenSet = false;
    private ExampleProvider exampleProvider;
    private ActionInterceptor actionInterceptor;
    private ArgumentAcceptor argumentAcceptor;
    private CommandCompleter commandCompleter;
    private CommandExecutor commandExecutor;

    public CommandImpl(@NotNull String description) {
        this(description, true);
    }

    public CommandImpl(@NotNull String description, boolean useDefaultCompleter) {
        AssertUtils.notBlank((CharSequence)description, (String)"\u65e0\u6548\u7684\u63cf\u8ff0");
        this.description = description;
        if (useDefaultCompleter) {
            this.commandCompleter = CompleterUtils.defaultCompleter();
        }
    }

    protected static boolean intercept(@NotNull Command command, @NotNull CommandContext context, @NotNull CommandAction action, String[] args) {
        AssertUtils.notNull((Object)command, (String)"\u65e0\u6548\u7684\u547d\u4ee4");
        AssertUtils.notNull((Object)context, (String)"\u65e0\u6548\u7684\u547d\u4ee4\u4e0a\u4e0b\u6587");
        AssertUtils.notNull((Object)action, (String)"\u65e0\u6548\u7684\u547d\u4ee4\u52a8\u4f5c");
        args = Command.promise((String[])args);
        if (args.length > command.getDepth()) {
            ActionInterceptor actionInterceptor = command.getActionInterceptor();
            return actionInterceptor != null && actionInterceptor.intercept(context, action);
        }
        return false;
    }

    @Nullable
    public Command getParent() {
        return this.parent;
    }

    public void setParent(Command parent) {
        if (this.parentHasBeenSet) {
            throw new IllegalStateException("parent \u7684\u503c\u4ec5\u5141\u8bb8\u914d\u7f6e\u4e00\u6b21");
        }
        this.parentHasBeenSet = true;
        this.parent = parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getDepth() {
        int depth = 0;
        for (Command command = this.parent; command != null && !command.isRoot(); command = command.getParent()) {
            ++depth;
        }
        return depth;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public Command subCommand(@NotNull Command subCommand) {
        AssertUtils.notNull((Object)subCommand, (String)"\u65e0\u6548\u7684\u5b50\u547d\u4ee4");
        subCommand.setParent((Command)this);
        this.subCommands.add(subCommand);
        return this;
    }

    @NotNull
    public Command subCommands(@NotNull List<Command> subCommands) {
        AssertUtils.notNull(subCommands, (String)"\u65e0\u6548\u7684\u5b50\u547d\u4ee4\u5217\u8868");
        subCommands.forEach(subCommand -> {
            AssertUtils.notNull((Object)subCommand, (String)"\u65e0\u6548\u7684\u5b50\u547d\u4ee4");
            subCommand.setParent((Command)this);
            this.subCommands.add((Command)subCommand);
        });
        return this;
    }

    @Nullable
    public ExampleProvider getExampleProvider() {
        return this.exampleProvider;
    }

    @NotNull
    public Command exampleProvider(ExampleProvider exampleProvider) {
        this.exampleProvider = exampleProvider;
        return this;
    }

    @Nullable
    public ActionInterceptor getActionInterceptor() {
        return this.actionInterceptor;
    }

    @NotNull
    public Command actionInterceptor(ActionInterceptor actionInterceptor) {
        this.actionInterceptor = actionInterceptor;
        return this;
    }

    @Nullable
    public ArgumentAcceptor getArgumentAcceptor() {
        return this.argumentAcceptor;
    }

    @NotNull
    public Command argumentAcceptor(ArgumentAcceptor argumentAcceptor) {
        this.argumentAcceptor = argumentAcceptor;
        return this;
    }

    @Nullable
    public CommandCompleter getCommandCompleter() {
        return this.commandCompleter;
    }

    @NotNull
    public Command commandCompleter(CommandCompleter commandCompleter) {
        this.commandCompleter = commandCompleter;
        return this;
    }

    @Nullable
    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @NotNull
    public Command commandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public boolean acceptArgument(@NotNull CommandContext context, String[] args) {
        AssertUtils.notNull((Object)context, (String)"\u65e0\u6548\u7684\u547d\u4ee4\u4e0a\u4e0b\u6587");
        args = Command.promise((String[])args);
        int depth = this.getDepth();
        if (args.length > depth && !StringUtils.isBlank((CharSequence)args[depth])) {
            boolean result;
            context.setArguments(args);
            context.setDepth(depth);
            boolean bl = result = this.argumentAcceptor != null && this.argumentAcceptor.acceptArgument(context);
            if (result) {
                logger.debug("[Command]({}) \u53c2\u6570\u547d\u4e2d\uff1a{}\uff0c\u53c2\u6570\u957f\u5ea6\uff1a{}\uff0c\u547d\u4ee4\u6df1\u5ea6\uff1a{}", (Object)this.getDescription(), (Object)args[depth], (Object)args.length, (Object)depth);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Command accept(@NotNull CommandContext context, String[] args) {
        AssertUtils.notNull((Object)context, (String)"\u65e0\u6548\u7684\u547d\u4ee4\u4e0a\u4e0b\u6587");
        args = Command.promise((String[])args);
        if (args.length > this.getDepth()) {
            for (Command subCommand : this.subCommands) {
                if (!subCommand.acceptArgument(context, args)) continue;
                return subCommand;
            }
        }
        return null;
    }

    @Nullable
    public List<String> complete(@NotNull CommandContext context, String[] args) {
        AssertUtils.notNull((Object)context, (String)"\u65e0\u6548\u7684\u547d\u4ee4\u4e0a\u4e0b\u6587");
        args = Command.promise((String[])args);
        int depth = this.getDepth();
        if (!this.isRoot()) {
            ++depth;
        }
        List result = null;
        if (args.length - 1 == depth) {
            LinkedList examples = null;
            context.setArguments(args);
            context.setDepth(depth);
            logger.debug("[Command]({}) \u8865\u5168\u53c2\u6570", (Object)this.getDescription());
            for (Command subCommand : this.subCommands) {
                CommandCompleter completer;
                ExampleProvider exampleProvider = subCommand.getExampleProvider();
                if (exampleProvider == null || CommandImpl.intercept(subCommand, context, CommandAction.COMPLETE, args)) continue;
                List subExamples = exampleProvider.provideExample(context);
                AssertUtils.notNull((Object)subExamples, (String)"\u65e0\u6548\u7684\u793a\u4f8b\u5217\u8868");
                if (subExamples.isEmpty()) continue;
                if (examples == null) {
                    examples = new LinkedList();
                }
                if ((completer = subCommand.getCommandCompleter()) == null || !StringUtils.isBlank((CharSequence)args[depth])) {
                    examples.addAll(subExamples);
                    continue;
                }
                examples.addAll(completer.complete(context, subExamples));
            }
            if (examples != null) {
                result = CompleterUtils.defaultCompleter().complete(context, examples);
            }
        }
        return result;
    }

    @Nullable
    public Boolean execute(@NotNull CommandContext context, String[] args) {
        CommandExecutor executor;
        AssertUtils.notNull((Object)context, (String)"\u65e0\u6548\u7684\u547d\u4ee4\u4e0a\u4e0b\u6587");
        args = Command.promise((String[])args);
        int depth = this.getDepth();
        if (args.length - 1 == depth && (executor = this.getCommandExecutor()) != null) {
            context.setArguments(args);
            context.setDepth(depth);
            if (!CommandImpl.intercept(this, context, CommandAction.EXECUTE, args)) {
                logger.debug("[Command]({}) \u6267\u884c\u547d\u4ee4", (Object)this.getDescription());
                return executor.execute(context);
            }
        }
        return null;
    }
}

