/*
 * Decompiled with CFR 0.152.
 */
package team.idealstate.hyper.command.impl.argument;

import java.util.Collection;
import java.util.Collections;
import team.idealstate.hyper.command.api.argument.ArgumentAcceptor;
import team.idealstate.hyper.commons.base.StringUtils;

public abstract class AcceptorUtils {
    private static final ArgumentAcceptor IS_INTEGRAL = context -> StringUtils.isIntegral((CharSequence)context.getArgument());
    private static final ArgumentAcceptor IS_NUMERIC = context -> StringUtils.isNumeric((CharSequence)context.getArgument());

    public static ArgumentAcceptor isIntegral() {
        return IS_INTEGRAL;
    }

    public static ArgumentAcceptor isNumeric() {
        return IS_NUMERIC;
    }

    public static ArgumentAcceptor isEquals(String string) {
        return context -> context.getArgument().equals(string);
    }

    public static ArgumentAcceptor notEquals(String string) {
        return context -> !context.getArgument().equals(string);
    }

    public static ArgumentAcceptor isEqualsIgnoreCase(String string) {
        return context -> context.getArgument().equalsIgnoreCase(string);
    }

    public static ArgumentAcceptor notEqualsIgnoreCase(String string) {
        return context -> !context.getArgument().equalsIgnoreCase(string);
    }

    public static ArgumentAcceptor isContains(Collection<String> strings) {
        Collection<String> recollectStrings = AcceptorUtils.promise(strings);
        return context -> recollectStrings.contains(context.getArgument());
    }

    public static ArgumentAcceptor notContains(Collection<String> strings) {
        Collection<String> recollectStrings = AcceptorUtils.promise(strings);
        return context -> !recollectStrings.contains(context.getArgument());
    }

    private static Collection<String> promise(Collection<String> strings) {
        return strings == null ? Collections.emptySet() : strings;
    }
}

