/*
 * Decompiled with CFR 0.152.
 */
package tech.antibytes.kmock.verification;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.antibytes.kmock.KMockContract;
import tech.antibytes.kmock.util.StringFormatterKt;
import tech.antibytes.kmock.verification.ArgumentMatcherKt;
import tech.antibytes.kmock.verification.Assertions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J=\u0010\t\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u000b\"\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J=\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u000b\"\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ=\u0010\u0011\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u000b\"\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0012\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0014\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\u0015\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0016J)\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u0018*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u00180\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Ltech/antibytes/kmock/verification/Assertions;", "Ltech/antibytes/kmock/KMockContract$Assertions;", "()V", "hasBeenCalledAtIndex", "", "proxy", "Ltech/antibytes/kmock/KMockContract$FunProxy;", "callIndex", "", "hasBeenCalledWithAtIndex", "arguments", "", "", "(Ltech/antibytes/kmock/KMockContract$FunProxy;I[Ljava/lang/Object;)V", "hasBeenCalledWithVoidAtIndex", "hasBeenCalledWithoutAtIndex", "illegal", "hasBeenStrictlyCalledWithAtIndex", "wasGottenAtIndex", "Ltech/antibytes/kmock/KMockContract$PropertyProxy;", "wasSetAtIndex", "wasSetToAtIndex", "value", "guardActualRetrieval", "T", "Ltech/antibytes/kmock/KMockContract$Proxy;", "(Ltech/antibytes/kmock/KMockContract$Proxy;I)Ljava/lang/Object;", "kmock"})
public final class Assertions
implements KMockContract.Assertions {
    @NotNull
    public static final Assertions INSTANCE = new Assertions();

    private Assertions() {
    }

    private final <T> T guardActualRetrieval(KMockContract.Proxy<?, T> $this$guardActualRetrieval, int callIndex) {
        T t;
        try {
            t = $this$guardActualRetrieval.getArgumentsForCall(callIndex);
        }
        catch (Throwable _) {
            Object[] objectArray = new Object[]{callIndex + 1, $this$guardActualRetrieval.getId()};
            throw new AssertionError((Object)StringFormatterKt.format("Expected %0th call of %1 was not made.", objectArray));
        }
        return t;
    }

    @Override
    public void hasBeenCalledAtIndex(@NotNull KMockContract.FunProxy<?, ?> proxy, int callIndex) {
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        this.guardActualRetrieval((KMockContract.Proxy)proxy, callIndex);
    }

    @Override
    public void hasBeenCalledWithVoidAtIndex(@NotNull KMockContract.FunProxy<?, ?> proxy, int callIndex) {
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        boolean actual = ArgumentMatcherKt.hasBeenCalledWithVoid((Object[])this.guardActualRetrieval((KMockContract.Proxy)proxy, callIndex));
        if (!actual) {
            Object[] objectArray = new Object[]{proxy.getId()};
            throw new AssertionError((Object)StringFormatterKt.format("Expected %0 to be void, but the invocation contains Arguments.", objectArray));
        }
    }

    @Override
    public void hasBeenCalledWithAtIndex(@NotNull KMockContract.FunProxy<?, ?> proxy, int callIndex, Object ... arguments) {
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Object[] actual = (Object[])this.guardActualRetrieval((KMockContract.Proxy)proxy, callIndex);
        boolean valid2 = ArgumentMatcherKt.hasBeenCalledWith(actual, Arrays.copyOf(arguments, arguments.length), (Function2<Object, ? super Integer, Unit>)((Function2)new Function2<Object, Integer, Unit>(arguments, actual){
            final /* synthetic */ Object[] $arguments;
            final /* synthetic */ Object[] $actual;
            {
                this.$arguments = $arguments;
                this.$actual = $actual;
                super(2);
            }

            public final void invoke(@Nullable Object object, int idx) {
                Object[] objectArray = new Object[]{this.$arguments[idx], this.$actual[idx]};
                throw new AssertionError((Object)StringFormatterKt.format("Expected <%0> got actual <%1>.", objectArray));
            }
        }));
        if (!valid2) {
            Object[] objectArray = new Object[]{ArraysKt.first((Object[])arguments)};
            throw new AssertionError((Object)StringFormatterKt.format("The given matcher %0 has not been found.", objectArray));
        }
    }

    @Override
    public void hasBeenStrictlyCalledWithAtIndex(@NotNull KMockContract.FunProxy<?, ?> proxy, int callIndex, Object ... arguments) {
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Object[] actual = (Object[])this.guardActualRetrieval((KMockContract.Proxy)proxy, callIndex);
        boolean valid2 = ArgumentMatcherKt.hasBeenStrictlyCalledWith(actual, Arrays.copyOf(arguments, arguments.length), (Function2<Object, ? super Integer, Unit>)((Function2)new Function2<Object, Integer, Unit>(arguments){
            final /* synthetic */ Object[] $arguments;
            {
                this.$arguments = $arguments;
                super(2);
            }

            public final void invoke(@Nullable Object actualArgument, int idx) {
                Object[] objectArray = new Object[]{this.$arguments[idx], actualArgument};
                throw new AssertionError((Object)StringFormatterKt.format("Expected <%0> got actual <%1>.", objectArray));
            }
        }));
        if (!valid2) {
            Object[] objectArray = new Object[]{arguments.length, actual.length};
            throw new AssertionError((Object)StringFormatterKt.format("Expected <%0> arguments got actual <%1>.", objectArray));
        }
    }

    @Override
    public void hasBeenCalledWithoutAtIndex(@NotNull KMockContract.FunProxy<?, ?> proxy, int callIndex, Object ... illegal) {
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)illegal, (String)"illegal");
        Object[] actual = (Object[])this.guardActualRetrieval((KMockContract.Proxy)proxy, callIndex);
        boolean valid2 = ArgumentMatcherKt.hasBeenCalledWithout(actual, Arrays.copyOf(illegal, illegal.length), (Function2<Object, ? super Integer, Unit>)((Function2)hasBeenCalledWithoutAtIndex.valid.1.INSTANCE));
        if (!valid2) {
            throw new AssertionError((Object)"Expected a non void function invocation.");
        }
    }

    @Override
    public void wasGottenAtIndex(@NotNull KMockContract.PropertyProxy<?> proxy, int callIndex) {
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        KMockContract.GetOrSet actual = (KMockContract.GetOrSet)this.guardActualRetrieval((KMockContract.Proxy)proxy, callIndex);
        if (!ArgumentMatcherKt.wasGotten(actual)) {
            throw new AssertionError((Object)"Expected a getter and got a setter.");
        }
    }

    @Override
    public void wasSetAtIndex(@NotNull KMockContract.PropertyProxy<?> proxy, int callIndex) {
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        KMockContract.GetOrSet actual = (KMockContract.GetOrSet)this.guardActualRetrieval((KMockContract.Proxy)proxy, callIndex);
        if (!ArgumentMatcherKt.wasSet(actual)) {
            throw new AssertionError((Object)"Expected a setter and got a getter.");
        }
    }

    @Override
    public void wasSetToAtIndex(@NotNull KMockContract.PropertyProxy<?> proxy, int callIndex, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        KMockContract.GetOrSet actual = (KMockContract.GetOrSet)this.guardActualRetrieval((KMockContract.Proxy)proxy, callIndex);
        boolean valid2 = ArgumentMatcherKt.wasSetTo(actual, value);
        if (!valid2) {
            if (actual instanceof KMockContract.GetOrSet.Get) {
                throw new AssertionError((Object)"Expected a setter and got a getter.");
            }
            Object[] objectArray = new Object[]{value, actual.getValue()};
            throw new AssertionError((Object)StringFormatterKt.format("Expected <%0> got actual <%1>.", objectArray));
        }
    }
}

