/*
 * Decompiled with CFR 0.152.
 */
package tech.coner.crispyfish.filetype.staging;

import java.io.File;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.coner.crispyfish.filetype.ecf.EventControlFile;
import tech.coner.crispyfish.filetype.staging.StagingFileAssistant$WhenMappings;
import tech.coner.crispyfish.filetype.staging.StagingFilenameFilter;
import tech.coner.crispyfish.filetype.staging.StagingFilenames;
import tech.coner.crispyfish.filetype.staging.StagingLineException;
import tech.coner.crispyfish.model.EventDay;
import tech.coner.crispyfish.model.PenaltyType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Ltech/coner/crispyfish/filetype/staging/StagingFileAssistant;", "", "()V", "buildStagingFilenameFilter", "Ltech/coner/crispyfish/filetype/staging/StagingFilenameFilter;", "eventControlFile", "Ltech/coner/crispyfish/filetype/ecf/EventControlFile;", "eventDay", "Ltech/coner/crispyfish/model/EventDay;", "convertStagingRunPenaltyStringToConeCount", "", "penalty", "", "convertStagingRunPenaltyStringToPenaltyType", "Ltech/coner/crispyfish/model/PenaltyType;", "convertStagingTimeStringToDuration", "Ljava/time/Duration;", "stagingTime", "getOriginalFileBaseName", "crispyfish-library"})
public final class StagingFileAssistant {
    @NotNull
    public final StagingFilenameFilter buildStagingFilenameFilter(@NotNull EventControlFile eventControlFile, @NotNull EventDay eventDay) {
        Pattern pattern;
        Intrinsics.checkNotNullParameter((Object)eventControlFile, (String)"eventControlFile");
        Intrinsics.checkNotNullParameter((Object)((Object)eventDay), (String)"eventDay");
        switch (StagingFileAssistant$WhenMappings.$EnumSwitchMapping$0[eventDay.ordinal()]) {
            case 1: {
                Pattern pattern2 = StagingFilenames.INSTANCE.getORIGINAL_FILE_DAY_1();
                pattern = pattern2;
                Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"StagingFilenames.ORIGINAL_FILE_DAY_1");
                break;
            }
            case 2: {
                Pattern pattern3 = StagingFilenames.INSTANCE.getORIGINAL_FILE_DAY_2();
                pattern = pattern3;
                Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"StagingFilenames.ORIGINAL_FILE_DAY_2");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pattern originalFilePattern = pattern;
        String originalFileBaseName = this.getOriginalFileBaseName(eventControlFile);
        return new StagingFilenameFilter(originalFileBaseName, originalFilePattern);
    }

    @NotNull
    public final String getOriginalFileBaseName(@NotNull EventControlFile eventControlFile) {
        Intrinsics.checkNotNullParameter((Object)eventControlFile, (String)"eventControlFile");
        return FilesKt.getNameWithoutExtension((File)eventControlFile.getFile());
    }

    @NotNull
    public final Duration convertStagingTimeStringToDuration(@Nullable String stagingTime) throws StagingLineException {
        try {
            Duration duration = Duration.parse("PT" + stagingTime + 'S');
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.parse(\"PT${stagingTime}S\")");
            return duration;
        }
        catch (DateTimeParseException e) {
            throw (Throwable)new StagingLineException("Staging time " + stagingTime + " cannot be parsed to Duration", e);
        }
    }

    @NotNull
    public final PenaltyType convertStagingRunPenaltyStringToPenaltyType(@Nullable String penalty) throws StagingLineException {
        String string = penalty;
        if (string != null) {
            CharSequence charSequence = string;
            boolean bl = false;
            if (charSequence.length() > 0) {
                charSequence = penalty;
                bl = false;
                String string2 = ((String)charSequence).toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
                switch (string2) {
                    case "DNF": {
                        return PenaltyType.DID_NOT_FINISH;
                    }
                    case "DSQ": {
                        return PenaltyType.DISQUALIFIED;
                    }
                    case "RRN": {
                        return PenaltyType.RERUN;
                    }
                }
                int cones = this.convertStagingRunPenaltyStringToConeCount(penalty);
                if (cones > 0) {
                    return PenaltyType.CONE;
                }
            }
        }
        return PenaltyType.CLEAN;
    }

    public final int convertStagingRunPenaltyStringToConeCount(@NotNull String penalty) throws StagingLineException {
        Intrinsics.checkNotNullParameter((Object)penalty, (String)"penalty");
        try {
            return Integer.parseUnsignedInt(penalty);
        }
        catch (NumberFormatException e) {
            throw (Throwable)new StagingLineException("Unable to convert staging penalty cones " + penalty + " to cone count", e);
        }
    }
}

