/*
 * decentro-in-kyc
 * KYC & Onboarding
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: admin@decentro.tech
 *
 * Do not edit the class manually.
 */


package tech.decentro.in.kyc.client.api;

import tech.decentro.in.kyc.client.ApiCallback;
import tech.decentro.in.kyc.client.ApiClient;
import tech.decentro.in.kyc.client.ApiException;
import tech.decentro.in.kyc.client.ApiResponse;
import tech.decentro.in.kyc.client.Configuration;
import tech.decentro.in.kyc.client.Pair;
import tech.decentro.in.kyc.client.ProgressRequestBody;
import tech.decentro.in.kyc.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import tech.decentro.in.kyc.client.model.CheckImageQualityResponse;
import tech.decentro.in.kyc.client.model.CheckPhotocopyResponse;
import tech.decentro.in.kyc.client.model.CheckVideoLivenessResponse;
import tech.decentro.in.kyc.client.model.ClassifyDocumentResponse;
import tech.decentro.in.kyc.client.model.ExtractTextResponse;
import java.io.File;
import tech.decentro.in.kyc.client.model.MaskAadhaarUidResponse;
import tech.decentro.in.kyc.client.model.MatchFaceResponse;
import tech.decentro.in.kyc.client.model.ValidateRequest;
import tech.decentro.in.kyc.client.model.ValidateResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class KycApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public KycApi() throws IllegalArgumentException {
        this(Configuration.getDefaultApiClient());
    }

    public KycApi(ApiClient apiClient) throws IllegalArgumentException {
        if (apiClient.getClientId() == null) {
            throw new IllegalArgumentException("\"client_id\" is required but no API key was provided. Please set \"client_id\" with ApiClient#setClientId(String).");
        }
        if (apiClient.getClientSecret() == null) {
            throw new IllegalArgumentException("\"client_secret\" is required but no API key was provided. Please set \"client_secret\" with ApiClient#setClientSecret(String).");
        }
        if (apiClient.getModuleSecret() == null) {
            throw new IllegalArgumentException("\"module_secret\" is required but no API key was provided. Please set \"module_secret\" with ApiClient#setModuleSecret(String).");
        }
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call checkImageQualityCall(String referenceId, Boolean consent, String consentPurpose, File image, String qualityParameter, String imageUrl, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/kyc/forensics/image_quality";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (referenceId != null) {
            localVarFormParams.put("reference_id", referenceId);
        }

        if (consent != null) {
            localVarFormParams.put("consent", consent);
        }

        if (consentPurpose != null) {
            localVarFormParams.put("consent_purpose", consentPurpose);
        }

        if (image != null) {
            localVarFormParams.put("image", image);
        }

        if (qualityParameter != null) {
            localVarFormParams.put("quality_parameter", qualityParameter);
        }

        if (imageUrl != null) {
            localVarFormParams.put("image_url", imageUrl);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "client_id", "client_secret", "module_secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call checkImageQualityValidateBeforeCall(String referenceId, Boolean consent, String consentPurpose, File image, String qualityParameter, String imageUrl, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'referenceId' is set
        if (referenceId == null) {
            throw new ApiException("Missing the required parameter 'referenceId' when calling checkImageQuality(Async)");
        }

        // verify the required parameter 'consent' is set
        if (consent == null) {
            throw new ApiException("Missing the required parameter 'consent' when calling checkImageQuality(Async)");
        }

        // verify the required parameter 'consentPurpose' is set
        if (consentPurpose == null) {
            throw new ApiException("Missing the required parameter 'consentPurpose' when calling checkImageQuality(Async)");
        }

        return checkImageQualityCall(referenceId, consent, consentPurpose, image, qualityParameter, imageUrl, _callback);

    }


    private ApiResponse<CheckImageQualityResponse> checkImageQualityWithHttpInfo(String referenceId, Boolean consent, String consentPurpose, File image, String qualityParameter, String imageUrl) throws ApiException {
        okhttp3.Call localVarCall = checkImageQualityValidateBeforeCall(referenceId, consent, consentPurpose, image, qualityParameter, imageUrl, null);
        Type localVarReturnType = new TypeToken<CheckImageQualityResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call checkImageQualityAsync(String referenceId, Boolean consent, String consentPurpose, File image, String qualityParameter, String imageUrl, final ApiCallback<CheckImageQualityResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = checkImageQualityValidateBeforeCall(referenceId, consent, consentPurpose, image, qualityParameter, imageUrl, _callback);
        Type localVarReturnType = new TypeToken<CheckImageQualityResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class CheckImageQualityRequestBuilder {
        private final String referenceId;
        private final Boolean consent;
        private final String consentPurpose;
        private File image;
        private String qualityParameter;
        private String imageUrl;

        private CheckImageQualityRequestBuilder(String referenceId, Boolean consent, String consentPurpose) {
            this.referenceId = referenceId;
            this.consent = consent;
            this.consentPurpose = consentPurpose;
        }

        /**
         * Set image
         * @param image  (optional)
         * @return CheckImageQualityRequestBuilder
         */
        public CheckImageQualityRequestBuilder image(File image) {
            this.image = image;
            return this;
        }
        
        /**
         * Set qualityParameter
         * @param qualityParameter  (optional)
         * @return CheckImageQualityRequestBuilder
         */
        public CheckImageQualityRequestBuilder qualityParameter(String qualityParameter) {
            this.qualityParameter = qualityParameter;
            return this;
        }
        
        /**
         * Set imageUrl
         * @param imageUrl  (optional)
         * @return CheckImageQualityRequestBuilder
         */
        public CheckImageQualityRequestBuilder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }
        
        /**
         * Build call for checkImageQuality
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return checkImageQualityCall(referenceId, consent, consentPurpose, image, qualityParameter, imageUrl, _callback);
        }


        /**
         * Execute checkImageQuality request
         * @return CheckImageQualityResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public CheckImageQualityResponse execute() throws ApiException {
            ApiResponse<CheckImageQualityResponse> localVarResp = checkImageQualityWithHttpInfo(referenceId, consent, consentPurpose, image, qualityParameter, imageUrl);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute checkImageQuality request with HTTP info returned
         * @return ApiResponse&lt;CheckImageQualityResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public ApiResponse<CheckImageQualityResponse> executeWithHttpInfo() throws ApiException {
            return checkImageQualityWithHttpInfo(referenceId, consent, consentPurpose, image, qualityParameter, imageUrl);
        }

        /**
         * Execute checkImageQuality request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<CheckImageQualityResponse> _callback) throws ApiException {
            return checkImageQualityAsync(referenceId, consent, consentPurpose, image, qualityParameter, imageUrl, _callback);
        }
    }

    /**
     * Image Quality Check
     * 
     * @param referenceId  (required)
     * @param consent  (required)
     * @param consentPurpose  (required)
     * @return CheckImageQualityRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
     </table>
     */
    public CheckImageQualityRequestBuilder checkImageQuality(String referenceId, Boolean consent, String consentPurpose) throws IllegalArgumentException {
        if (referenceId == null) throw new IllegalArgumentException("\"referenceId\" is required but got null");
            if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }

        if (consent == null) throw new IllegalArgumentException("\"consent\" is required but got null");
        if (consentPurpose == null) throw new IllegalArgumentException("\"consentPurpose\" is required but got null");
            if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }

        return new CheckImageQualityRequestBuilder(referenceId, consent, consentPurpose);
    }
    private okhttp3.Call checkPhotocopyCall(String referenceId, Boolean consent, String consentPurpose, File image, String imageUrl, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/kyc/forensics/photocopy_check";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (referenceId != null) {
            localVarFormParams.put("reference_id", referenceId);
        }

        if (consent != null) {
            localVarFormParams.put("consent", consent);
        }

        if (consentPurpose != null) {
            localVarFormParams.put("consent_purpose", consentPurpose);
        }

        if (image != null) {
            localVarFormParams.put("image", image);
        }

        if (imageUrl != null) {
            localVarFormParams.put("image_url", imageUrl);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "client_id", "client_secret", "module_secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call checkPhotocopyValidateBeforeCall(String referenceId, Boolean consent, String consentPurpose, File image, String imageUrl, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'referenceId' is set
        if (referenceId == null) {
            throw new ApiException("Missing the required parameter 'referenceId' when calling checkPhotocopy(Async)");
        }

        // verify the required parameter 'consent' is set
        if (consent == null) {
            throw new ApiException("Missing the required parameter 'consent' when calling checkPhotocopy(Async)");
        }

        // verify the required parameter 'consentPurpose' is set
        if (consentPurpose == null) {
            throw new ApiException("Missing the required parameter 'consentPurpose' when calling checkPhotocopy(Async)");
        }

        return checkPhotocopyCall(referenceId, consent, consentPurpose, image, imageUrl, _callback);

    }


    private ApiResponse<CheckPhotocopyResponse> checkPhotocopyWithHttpInfo(String referenceId, Boolean consent, String consentPurpose, File image, String imageUrl) throws ApiException {
        okhttp3.Call localVarCall = checkPhotocopyValidateBeforeCall(referenceId, consent, consentPurpose, image, imageUrl, null);
        Type localVarReturnType = new TypeToken<CheckPhotocopyResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call checkPhotocopyAsync(String referenceId, Boolean consent, String consentPurpose, File image, String imageUrl, final ApiCallback<CheckPhotocopyResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = checkPhotocopyValidateBeforeCall(referenceId, consent, consentPurpose, image, imageUrl, _callback);
        Type localVarReturnType = new TypeToken<CheckPhotocopyResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class CheckPhotocopyRequestBuilder {
        private final String referenceId;
        private final Boolean consent;
        private final String consentPurpose;
        private File image;
        private String imageUrl;

        private CheckPhotocopyRequestBuilder(String referenceId, Boolean consent, String consentPurpose) {
            this.referenceId = referenceId;
            this.consent = consent;
            this.consentPurpose = consentPurpose;
        }

        /**
         * Set image
         * @param image  (optional)
         * @return CheckPhotocopyRequestBuilder
         */
        public CheckPhotocopyRequestBuilder image(File image) {
            this.image = image;
            return this;
        }
        
        /**
         * Set imageUrl
         * @param imageUrl  (optional)
         * @return CheckPhotocopyRequestBuilder
         */
        public CheckPhotocopyRequestBuilder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }
        
        /**
         * Build call for checkPhotocopy
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return checkPhotocopyCall(referenceId, consent, consentPurpose, image, imageUrl, _callback);
        }


        /**
         * Execute checkPhotocopy request
         * @return CheckPhotocopyResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public CheckPhotocopyResponse execute() throws ApiException {
            ApiResponse<CheckPhotocopyResponse> localVarResp = checkPhotocopyWithHttpInfo(referenceId, consent, consentPurpose, image, imageUrl);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute checkPhotocopy request with HTTP info returned
         * @return ApiResponse&lt;CheckPhotocopyResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public ApiResponse<CheckPhotocopyResponse> executeWithHttpInfo() throws ApiException {
            return checkPhotocopyWithHttpInfo(referenceId, consent, consentPurpose, image, imageUrl);
        }

        /**
         * Execute checkPhotocopy request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<CheckPhotocopyResponse> _callback) throws ApiException {
            return checkPhotocopyAsync(referenceId, consent, consentPurpose, image, imageUrl, _callback);
        }
    }

    /**
     * Photocopy Check
     * 
     * @param referenceId  (required)
     * @param consent  (required)
     * @param consentPurpose  (required)
     * @return CheckPhotocopyRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
     </table>
     */
    public CheckPhotocopyRequestBuilder checkPhotocopy(String referenceId, Boolean consent, String consentPurpose) throws IllegalArgumentException {
        if (referenceId == null) throw new IllegalArgumentException("\"referenceId\" is required but got null");
            if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }

        if (consent == null) throw new IllegalArgumentException("\"consent\" is required but got null");
        if (consentPurpose == null) throw new IllegalArgumentException("\"consentPurpose\" is required but got null");
            if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }

        return new CheckPhotocopyRequestBuilder(referenceId, consent, consentPurpose);
    }
    private okhttp3.Call checkVideoLivenessCall(String referenceId, String consent, String consentPurpose, File video, String videoUrl, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/kyc/forensics/video_liveness";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (referenceId != null) {
            localVarFormParams.put("reference_id", referenceId);
        }

        if (consent != null) {
            localVarFormParams.put("consent", consent);
        }

        if (consentPurpose != null) {
            localVarFormParams.put("consent_purpose", consentPurpose);
        }

        if (video != null) {
            localVarFormParams.put("video", video);
        }

        if (videoUrl != null) {
            localVarFormParams.put("video_url", videoUrl);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "client_id", "client_secret", "module_secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call checkVideoLivenessValidateBeforeCall(String referenceId, String consent, String consentPurpose, File video, String videoUrl, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'referenceId' is set
        if (referenceId == null) {
            throw new ApiException("Missing the required parameter 'referenceId' when calling checkVideoLiveness(Async)");
        }

        // verify the required parameter 'consent' is set
        if (consent == null) {
            throw new ApiException("Missing the required parameter 'consent' when calling checkVideoLiveness(Async)");
        }

        // verify the required parameter 'consentPurpose' is set
        if (consentPurpose == null) {
            throw new ApiException("Missing the required parameter 'consentPurpose' when calling checkVideoLiveness(Async)");
        }

        return checkVideoLivenessCall(referenceId, consent, consentPurpose, video, videoUrl, _callback);

    }


    private ApiResponse<CheckVideoLivenessResponse> checkVideoLivenessWithHttpInfo(String referenceId, String consent, String consentPurpose, File video, String videoUrl) throws ApiException {
        okhttp3.Call localVarCall = checkVideoLivenessValidateBeforeCall(referenceId, consent, consentPurpose, video, videoUrl, null);
        Type localVarReturnType = new TypeToken<CheckVideoLivenessResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call checkVideoLivenessAsync(String referenceId, String consent, String consentPurpose, File video, String videoUrl, final ApiCallback<CheckVideoLivenessResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = checkVideoLivenessValidateBeforeCall(referenceId, consent, consentPurpose, video, videoUrl, _callback);
        Type localVarReturnType = new TypeToken<CheckVideoLivenessResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class CheckVideoLivenessRequestBuilder {
        private final String referenceId;
        private final String consent;
        private final String consentPurpose;
        private File video;
        private String videoUrl;

        private CheckVideoLivenessRequestBuilder(String referenceId, String consent, String consentPurpose) {
            this.referenceId = referenceId;
            this.consent = consent;
            this.consentPurpose = consentPurpose;
        }

        /**
         * Set video
         * @param video  (optional)
         * @return CheckVideoLivenessRequestBuilder
         */
        public CheckVideoLivenessRequestBuilder video(File video) {
            this.video = video;
            return this;
        }
        
        /**
         * Set videoUrl
         * @param videoUrl  (optional)
         * @return CheckVideoLivenessRequestBuilder
         */
        public CheckVideoLivenessRequestBuilder videoUrl(String videoUrl) {
            this.videoUrl = videoUrl;
            return this;
        }
        
        /**
         * Build call for checkVideoLiveness
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return checkVideoLivenessCall(referenceId, consent, consentPurpose, video, videoUrl, _callback);
        }


        /**
         * Execute checkVideoLiveness request
         * @return CheckVideoLivenessResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
         </table>
         */
        public CheckVideoLivenessResponse execute() throws ApiException {
            ApiResponse<CheckVideoLivenessResponse> localVarResp = checkVideoLivenessWithHttpInfo(referenceId, consent, consentPurpose, video, videoUrl);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute checkVideoLiveness request with HTTP info returned
         * @return ApiResponse&lt;CheckVideoLivenessResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<CheckVideoLivenessResponse> executeWithHttpInfo() throws ApiException {
            return checkVideoLivenessWithHttpInfo(referenceId, consent, consentPurpose, video, videoUrl);
        }

        /**
         * Execute checkVideoLiveness request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<CheckVideoLivenessResponse> _callback) throws ApiException {
            return checkVideoLivenessAsync(referenceId, consent, consentPurpose, video, videoUrl, _callback);
        }
    }

    /**
     * Liveness Check
     * 
     * @param referenceId  (required)
     * @param consent  (required)
     * @param consentPurpose  (required)
     * @return CheckVideoLivenessRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public CheckVideoLivenessRequestBuilder checkVideoLiveness(String referenceId, String consent, String consentPurpose) throws IllegalArgumentException {
        if (referenceId == null) throw new IllegalArgumentException("\"referenceId\" is required but got null");
            if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }

        if (consent == null) throw new IllegalArgumentException("\"consent\" is required but got null");
            if (consent.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consent. Length must be greater than or equal to 1.");
    }

        if (consentPurpose == null) throw new IllegalArgumentException("\"consentPurpose\" is required but got null");
            if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }

        return new CheckVideoLivenessRequestBuilder(referenceId, consent, consentPurpose);
    }
    private okhttp3.Call classifyDocumentCall(String referenceId, String documentType, Boolean consent, String consentPurpose, File document, String documentUrl, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/kyc/document_classification";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (referenceId != null) {
            localVarFormParams.put("reference_id", referenceId);
        }

        if (documentType != null) {
            localVarFormParams.put("document_type", documentType);
        }

        if (consent != null) {
            localVarFormParams.put("consent", consent);
        }

        if (consentPurpose != null) {
            localVarFormParams.put("consent_purpose", consentPurpose);
        }

        if (document != null) {
            localVarFormParams.put("document", document);
        }

        if (documentUrl != null) {
            localVarFormParams.put("document_url", documentUrl);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "client_id", "client_secret", "module_secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call classifyDocumentValidateBeforeCall(String referenceId, String documentType, Boolean consent, String consentPurpose, File document, String documentUrl, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'referenceId' is set
        if (referenceId == null) {
            throw new ApiException("Missing the required parameter 'referenceId' when calling classifyDocument(Async)");
        }

        // verify the required parameter 'documentType' is set
        if (documentType == null) {
            throw new ApiException("Missing the required parameter 'documentType' when calling classifyDocument(Async)");
        }

        // verify the required parameter 'consent' is set
        if (consent == null) {
            throw new ApiException("Missing the required parameter 'consent' when calling classifyDocument(Async)");
        }

        // verify the required parameter 'consentPurpose' is set
        if (consentPurpose == null) {
            throw new ApiException("Missing the required parameter 'consentPurpose' when calling classifyDocument(Async)");
        }

        return classifyDocumentCall(referenceId, documentType, consent, consentPurpose, document, documentUrl, _callback);

    }


    private ApiResponse<ClassifyDocumentResponse> classifyDocumentWithHttpInfo(String referenceId, String documentType, Boolean consent, String consentPurpose, File document, String documentUrl) throws ApiException {
        okhttp3.Call localVarCall = classifyDocumentValidateBeforeCall(referenceId, documentType, consent, consentPurpose, document, documentUrl, null);
        Type localVarReturnType = new TypeToken<ClassifyDocumentResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call classifyDocumentAsync(String referenceId, String documentType, Boolean consent, String consentPurpose, File document, String documentUrl, final ApiCallback<ClassifyDocumentResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = classifyDocumentValidateBeforeCall(referenceId, documentType, consent, consentPurpose, document, documentUrl, _callback);
        Type localVarReturnType = new TypeToken<ClassifyDocumentResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class ClassifyDocumentRequestBuilder {
        private final String referenceId;
        private final String documentType;
        private final Boolean consent;
        private final String consentPurpose;
        private File document;
        private String documentUrl;

        private ClassifyDocumentRequestBuilder(String referenceId, String documentType, Boolean consent, String consentPurpose) {
            this.referenceId = referenceId;
            this.documentType = documentType;
            this.consent = consent;
            this.consentPurpose = consentPurpose;
        }

        /**
         * Set document
         * @param document  (optional)
         * @return ClassifyDocumentRequestBuilder
         */
        public ClassifyDocumentRequestBuilder document(File document) {
            this.document = document;
            return this;
        }
        
        /**
         * Set documentUrl
         * @param documentUrl  (optional)
         * @return ClassifyDocumentRequestBuilder
         */
        public ClassifyDocumentRequestBuilder documentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
            return this;
        }
        
        /**
         * Build call for classifyDocument
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return classifyDocumentCall(referenceId, documentType, consent, consentPurpose, document, documentUrl, _callback);
        }


        /**
         * Execute classifyDocument request
         * @return ClassifyDocumentResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public ClassifyDocumentResponse execute() throws ApiException {
            ApiResponse<ClassifyDocumentResponse> localVarResp = classifyDocumentWithHttpInfo(referenceId, documentType, consent, consentPurpose, document, documentUrl);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute classifyDocument request with HTTP info returned
         * @return ApiResponse&lt;ClassifyDocumentResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public ApiResponse<ClassifyDocumentResponse> executeWithHttpInfo() throws ApiException {
            return classifyDocumentWithHttpInfo(referenceId, documentType, consent, consentPurpose, document, documentUrl);
        }

        /**
         * Execute classifyDocument request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ClassifyDocumentResponse> _callback) throws ApiException {
            return classifyDocumentAsync(referenceId, documentType, consent, consentPurpose, document, documentUrl, _callback);
        }
    }

    /**
     * ID Classification
     * 
     * @param referenceId  (required)
     * @param documentType  (required)
     * @param consent  (required)
     * @param consentPurpose  (required)
     * @return ClassifyDocumentRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
     </table>
     */
    public ClassifyDocumentRequestBuilder classifyDocument(String referenceId, String documentType, Boolean consent, String consentPurpose) throws IllegalArgumentException {
        if (referenceId == null) throw new IllegalArgumentException("\"referenceId\" is required but got null");
            if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }

        if (documentType == null) throw new IllegalArgumentException("\"documentType\" is required but got null");
            if (documentType.length() < 1) {
      throw new IllegalArgumentException("Invalid value for documentType. Length must be greater than or equal to 1.");
    }

        if (consent == null) throw new IllegalArgumentException("\"consent\" is required but got null");
        if (consentPurpose == null) throw new IllegalArgumentException("\"consentPurpose\" is required but got null");
            if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }

        return new ClassifyDocumentRequestBuilder(referenceId, documentType, consent, consentPurpose);
    }
    private okhttp3.Call extractTextCall(String referenceId, String documentType, String consent, String consentPurpose, Integer kycValidate, File document, String documentUrl, File documentBack, String documentBackUrl, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/kyc/scan_extract/ocr";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (referenceId != null) {
            localVarFormParams.put("reference_id", referenceId);
        }

        if (documentType != null) {
            localVarFormParams.put("document_type", documentType);
        }

        if (consent != null) {
            localVarFormParams.put("consent", consent);
        }

        if (consentPurpose != null) {
            localVarFormParams.put("consent_purpose", consentPurpose);
        }

        if (kycValidate != null) {
            localVarFormParams.put("kyc_validate", kycValidate);
        }

        if (document != null) {
            localVarFormParams.put("document", document);
        }

        if (documentUrl != null) {
            localVarFormParams.put("document_url", documentUrl);
        }

        if (documentBack != null) {
            localVarFormParams.put("document_back", documentBack);
        }

        if (documentBackUrl != null) {
            localVarFormParams.put("document_back_url", documentBackUrl);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "client_id", "client_secret", "module_secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call extractTextValidateBeforeCall(String referenceId, String documentType, String consent, String consentPurpose, Integer kycValidate, File document, String documentUrl, File documentBack, String documentBackUrl, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'referenceId' is set
        if (referenceId == null) {
            throw new ApiException("Missing the required parameter 'referenceId' when calling extractText(Async)");
        }

        // verify the required parameter 'documentType' is set
        if (documentType == null) {
            throw new ApiException("Missing the required parameter 'documentType' when calling extractText(Async)");
        }

        // verify the required parameter 'consent' is set
        if (consent == null) {
            throw new ApiException("Missing the required parameter 'consent' when calling extractText(Async)");
        }

        // verify the required parameter 'consentPurpose' is set
        if (consentPurpose == null) {
            throw new ApiException("Missing the required parameter 'consentPurpose' when calling extractText(Async)");
        }

        // verify the required parameter 'kycValidate' is set
        if (kycValidate == null) {
            throw new ApiException("Missing the required parameter 'kycValidate' when calling extractText(Async)");
        }

        return extractTextCall(referenceId, documentType, consent, consentPurpose, kycValidate, document, documentUrl, documentBack, documentBackUrl, _callback);

    }


    private ApiResponse<ExtractTextResponse> extractTextWithHttpInfo(String referenceId, String documentType, String consent, String consentPurpose, Integer kycValidate, File document, String documentUrl, File documentBack, String documentBackUrl) throws ApiException {
        okhttp3.Call localVarCall = extractTextValidateBeforeCall(referenceId, documentType, consent, consentPurpose, kycValidate, document, documentUrl, documentBack, documentBackUrl, null);
        Type localVarReturnType = new TypeToken<ExtractTextResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call extractTextAsync(String referenceId, String documentType, String consent, String consentPurpose, Integer kycValidate, File document, String documentUrl, File documentBack, String documentBackUrl, final ApiCallback<ExtractTextResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = extractTextValidateBeforeCall(referenceId, documentType, consent, consentPurpose, kycValidate, document, documentUrl, documentBack, documentBackUrl, _callback);
        Type localVarReturnType = new TypeToken<ExtractTextResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class ExtractTextRequestBuilder {
        private final String referenceId;
        private final String documentType;
        private final String consent;
        private final String consentPurpose;
        private final Integer kycValidate;
        private File document;
        private String documentUrl;
        private File documentBack;
        private String documentBackUrl;

        private ExtractTextRequestBuilder(String referenceId, String documentType, String consent, String consentPurpose, Integer kycValidate) {
            this.referenceId = referenceId;
            this.documentType = documentType;
            this.consent = consent;
            this.consentPurpose = consentPurpose;
            this.kycValidate = kycValidate;
        }

        /**
         * Set document
         * @param document  (optional)
         * @return ExtractTextRequestBuilder
         */
        public ExtractTextRequestBuilder document(File document) {
            this.document = document;
            return this;
        }
        
        /**
         * Set documentUrl
         * @param documentUrl  (optional)
         * @return ExtractTextRequestBuilder
         */
        public ExtractTextRequestBuilder documentUrl(String documentUrl) {
            this.documentUrl = documentUrl;
            return this;
        }
        
        /**
         * Set documentBack
         * @param documentBack  (optional)
         * @return ExtractTextRequestBuilder
         */
        public ExtractTextRequestBuilder documentBack(File documentBack) {
            this.documentBack = documentBack;
            return this;
        }
        
        /**
         * Set documentBackUrl
         * @param documentBackUrl  (optional)
         * @return ExtractTextRequestBuilder
         */
        public ExtractTextRequestBuilder documentBackUrl(String documentBackUrl) {
            this.documentBackUrl = documentBackUrl;
            return this;
        }
        
        /**
         * Build call for extractText
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return extractTextCall(referenceId, documentType, consent, consentPurpose, kycValidate, document, documentUrl, documentBack, documentBackUrl, _callback);
        }


        /**
         * Execute extractText request
         * @return ExtractTextResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public ExtractTextResponse execute() throws ApiException {
            ApiResponse<ExtractTextResponse> localVarResp = extractTextWithHttpInfo(referenceId, documentType, consent, consentPurpose, kycValidate, document, documentUrl, documentBack, documentBackUrl);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute extractText request with HTTP info returned
         * @return ApiResponse&lt;ExtractTextResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public ApiResponse<ExtractTextResponse> executeWithHttpInfo() throws ApiException {
            return extractTextWithHttpInfo(referenceId, documentType, consent, consentPurpose, kycValidate, document, documentUrl, documentBack, documentBackUrl);
        }

        /**
         * Execute extractText request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ExtractTextResponse> _callback) throws ApiException {
            return extractTextAsync(referenceId, documentType, consent, consentPurpose, kycValidate, document, documentUrl, documentBack, documentBackUrl, _callback);
        }
    }

    /**
     * Scan &amp; Extract
     * 
     * @param referenceId  (required)
     * @param documentType  (required)
     * @param consent  (required)
     * @param consentPurpose  (required)
     * @param kycValidate  (required)
     * @return ExtractTextRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
     </table>
     */
    public ExtractTextRequestBuilder extractText(String referenceId, String documentType, String consent, String consentPurpose, Integer kycValidate) throws IllegalArgumentException {
        if (referenceId == null) throw new IllegalArgumentException("\"referenceId\" is required but got null");
            if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }

        if (documentType == null) throw new IllegalArgumentException("\"documentType\" is required but got null");
            if (documentType.length() < 1) {
      throw new IllegalArgumentException("Invalid value for documentType. Length must be greater than or equal to 1.");
    }

        if (consent == null) throw new IllegalArgumentException("\"consent\" is required but got null");
            if (consent.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consent. Length must be greater than or equal to 1.");
    }

        if (consentPurpose == null) throw new IllegalArgumentException("\"consentPurpose\" is required but got null");
            if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }

        if (kycValidate == null) throw new IllegalArgumentException("\"kycValidate\" is required but got null");
        return new ExtractTextRequestBuilder(referenceId, documentType, consent, consentPurpose, kycValidate);
    }
    private okhttp3.Call maskAadhaarUidCall(String referenceId, Boolean consent, String consentPurpose, File image, String imageUrl, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/kyc/identities/mask_aadhaar_uid";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (referenceId != null) {
            localVarFormParams.put("reference_id", referenceId);
        }

        if (consent != null) {
            localVarFormParams.put("consent", consent);
        }

        if (consentPurpose != null) {
            localVarFormParams.put("consent_purpose", consentPurpose);
        }

        if (image != null) {
            localVarFormParams.put("image", image);
        }

        if (imageUrl != null) {
            localVarFormParams.put("image_url", imageUrl);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "client_id", "client_secret", "module_secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call maskAadhaarUidValidateBeforeCall(String referenceId, Boolean consent, String consentPurpose, File image, String imageUrl, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'referenceId' is set
        if (referenceId == null) {
            throw new ApiException("Missing the required parameter 'referenceId' when calling maskAadhaarUid(Async)");
        }

        // verify the required parameter 'consent' is set
        if (consent == null) {
            throw new ApiException("Missing the required parameter 'consent' when calling maskAadhaarUid(Async)");
        }

        // verify the required parameter 'consentPurpose' is set
        if (consentPurpose == null) {
            throw new ApiException("Missing the required parameter 'consentPurpose' when calling maskAadhaarUid(Async)");
        }

        return maskAadhaarUidCall(referenceId, consent, consentPurpose, image, imageUrl, _callback);

    }


    private ApiResponse<MaskAadhaarUidResponse> maskAadhaarUidWithHttpInfo(String referenceId, Boolean consent, String consentPurpose, File image, String imageUrl) throws ApiException {
        okhttp3.Call localVarCall = maskAadhaarUidValidateBeforeCall(referenceId, consent, consentPurpose, image, imageUrl, null);
        Type localVarReturnType = new TypeToken<MaskAadhaarUidResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call maskAadhaarUidAsync(String referenceId, Boolean consent, String consentPurpose, File image, String imageUrl, final ApiCallback<MaskAadhaarUidResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = maskAadhaarUidValidateBeforeCall(referenceId, consent, consentPurpose, image, imageUrl, _callback);
        Type localVarReturnType = new TypeToken<MaskAadhaarUidResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class MaskAadhaarUidRequestBuilder {
        private final String referenceId;
        private final Boolean consent;
        private final String consentPurpose;
        private File image;
        private String imageUrl;

        private MaskAadhaarUidRequestBuilder(String referenceId, Boolean consent, String consentPurpose) {
            this.referenceId = referenceId;
            this.consent = consent;
            this.consentPurpose = consentPurpose;
        }

        /**
         * Set image
         * @param image  (optional)
         * @return MaskAadhaarUidRequestBuilder
         */
        public MaskAadhaarUidRequestBuilder image(File image) {
            this.image = image;
            return this;
        }
        
        /**
         * Set imageUrl
         * @param imageUrl  (optional)
         * @return MaskAadhaarUidRequestBuilder
         */
        public MaskAadhaarUidRequestBuilder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }
        
        /**
         * Build call for maskAadhaarUid
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return maskAadhaarUidCall(referenceId, consent, consentPurpose, image, imageUrl, _callback);
        }


        /**
         * Execute maskAadhaarUid request
         * @return MaskAadhaarUidResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
         </table>
         */
        public MaskAadhaarUidResponse execute() throws ApiException {
            ApiResponse<MaskAadhaarUidResponse> localVarResp = maskAadhaarUidWithHttpInfo(referenceId, consent, consentPurpose, image, imageUrl);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute maskAadhaarUid request with HTTP info returned
         * @return ApiResponse&lt;MaskAadhaarUidResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<MaskAadhaarUidResponse> executeWithHttpInfo() throws ApiException {
            return maskAadhaarUidWithHttpInfo(referenceId, consent, consentPurpose, image, imageUrl);
        }

        /**
         * Execute maskAadhaarUid request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<MaskAadhaarUidResponse> _callback) throws ApiException {
            return maskAadhaarUidAsync(referenceId, consent, consentPurpose, image, imageUrl, _callback);
        }
    }

    /**
     * Aadhaar Masking
     * 
     * @param referenceId  (required)
     * @param consent  (required)
     * @param consentPurpose  (required)
     * @return MaskAadhaarUidRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
     </table>
     */
    public MaskAadhaarUidRequestBuilder maskAadhaarUid(String referenceId, Boolean consent, String consentPurpose) throws IllegalArgumentException {
        if (referenceId == null) throw new IllegalArgumentException("\"referenceId\" is required but got null");
            if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }

        if (consent == null) throw new IllegalArgumentException("\"consent\" is required but got null");
        if (consentPurpose == null) throw new IllegalArgumentException("\"consentPurpose\" is required but got null");
            if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }

        return new MaskAadhaarUidRequestBuilder(referenceId, consent, consentPurpose);
    }
    private okhttp3.Call matchFaceCall(String referenceId, String consent, String consentPurpose, File image1, File image2, Integer threshold, String image1Url, String image2Url, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v2/kyc/forensics/face_match";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (referenceId != null) {
            localVarFormParams.put("reference_id", referenceId);
        }

        if (consent != null) {
            localVarFormParams.put("consent", consent);
        }

        if (consentPurpose != null) {
            localVarFormParams.put("consent_purpose", consentPurpose);
        }

        if (image1 != null) {
            localVarFormParams.put("image1", image1);
        }

        if (image2 != null) {
            localVarFormParams.put("image2", image2);
        }

        if (threshold != null) {
            localVarFormParams.put("threshold", threshold);
        }

        if (image1Url != null) {
            localVarFormParams.put("image1_url", image1Url);
        }

        if (image2Url != null) {
            localVarFormParams.put("image2_url", image2Url);
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "client_id", "client_secret", "module_secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call matchFaceValidateBeforeCall(String referenceId, String consent, String consentPurpose, File image1, File image2, Integer threshold, String image1Url, String image2Url, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'referenceId' is set
        if (referenceId == null) {
            throw new ApiException("Missing the required parameter 'referenceId' when calling matchFace(Async)");
        }

        // verify the required parameter 'consent' is set
        if (consent == null) {
            throw new ApiException("Missing the required parameter 'consent' when calling matchFace(Async)");
        }

        // verify the required parameter 'consentPurpose' is set
        if (consentPurpose == null) {
            throw new ApiException("Missing the required parameter 'consentPurpose' when calling matchFace(Async)");
        }

        return matchFaceCall(referenceId, consent, consentPurpose, image1, image2, threshold, image1Url, image2Url, _callback);

    }


    private ApiResponse<MatchFaceResponse> matchFaceWithHttpInfo(String referenceId, String consent, String consentPurpose, File image1, File image2, Integer threshold, String image1Url, String image2Url) throws ApiException {
        okhttp3.Call localVarCall = matchFaceValidateBeforeCall(referenceId, consent, consentPurpose, image1, image2, threshold, image1Url, image2Url, null);
        Type localVarReturnType = new TypeToken<MatchFaceResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call matchFaceAsync(String referenceId, String consent, String consentPurpose, File image1, File image2, Integer threshold, String image1Url, String image2Url, final ApiCallback<MatchFaceResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = matchFaceValidateBeforeCall(referenceId, consent, consentPurpose, image1, image2, threshold, image1Url, image2Url, _callback);
        Type localVarReturnType = new TypeToken<MatchFaceResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class MatchFaceRequestBuilder {
        private final String referenceId;
        private final String consent;
        private final String consentPurpose;
        private File image1;
        private File image2;
        private Integer threshold;
        private String image1Url;
        private String image2Url;

        private MatchFaceRequestBuilder(String referenceId, String consent, String consentPurpose) {
            this.referenceId = referenceId;
            this.consent = consent;
            this.consentPurpose = consentPurpose;
        }

        /**
         * Set image1
         * @param image1  (optional)
         * @return MatchFaceRequestBuilder
         */
        public MatchFaceRequestBuilder image1(File image1) {
            this.image1 = image1;
            return this;
        }
        
        /**
         * Set image2
         * @param image2  (optional)
         * @return MatchFaceRequestBuilder
         */
        public MatchFaceRequestBuilder image2(File image2) {
            this.image2 = image2;
            return this;
        }
        
        /**
         * Set threshold
         * @param threshold  (optional)
         * @return MatchFaceRequestBuilder
         */
        public MatchFaceRequestBuilder threshold(Integer threshold) {
            this.threshold = threshold;
            return this;
        }
        
        /**
         * Set image1Url
         * @param image1Url  (optional)
         * @return MatchFaceRequestBuilder
         */
        public MatchFaceRequestBuilder image1Url(String image1Url) {
            this.image1Url = image1Url;
            return this;
        }
        
        /**
         * Set image2Url
         * @param image2Url  (optional)
         * @return MatchFaceRequestBuilder
         */
        public MatchFaceRequestBuilder image2Url(String image2Url) {
            this.image2Url = image2Url;
            return this;
        }
        
        /**
         * Build call for matchFace
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return matchFaceCall(referenceId, consent, consentPurpose, image1, image2, threshold, image1Url, image2Url, _callback);
        }


        /**
         * Execute matchFace request
         * @return MatchFaceResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public MatchFaceResponse execute() throws ApiException {
            ApiResponse<MatchFaceResponse> localVarResp = matchFaceWithHttpInfo(referenceId, consent, consentPurpose, image1, image2, threshold, image1Url, image2Url);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute matchFace request with HTTP info returned
         * @return ApiResponse&lt;MatchFaceResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public ApiResponse<MatchFaceResponse> executeWithHttpInfo() throws ApiException {
            return matchFaceWithHttpInfo(referenceId, consent, consentPurpose, image1, image2, threshold, image1Url, image2Url);
        }

        /**
         * Execute matchFace request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<MatchFaceResponse> _callback) throws ApiException {
            return matchFaceAsync(referenceId, consent, consentPurpose, image1, image2, threshold, image1Url, image2Url, _callback);
        }
    }

    /**
     * Face Match
     * 
     * @param referenceId  (required)
     * @param consent  (required)
     * @param consentPurpose  (required)
     * @return MatchFaceRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  </td></tr>
     </table>
     */
    public MatchFaceRequestBuilder matchFace(String referenceId, String consent, String consentPurpose) throws IllegalArgumentException {
        if (referenceId == null) throw new IllegalArgumentException("\"referenceId\" is required but got null");
            if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }

        if (consent == null) throw new IllegalArgumentException("\"consent\" is required but got null");
            if (consent.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consent. Length must be greater than or equal to 1.");
    }

        if (consentPurpose == null) throw new IllegalArgumentException("\"consentPurpose\" is required but got null");
            if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }

        return new MatchFaceRequestBuilder(referenceId, consent, consentPurpose);
    }
    private okhttp3.Call validateCall(ValidateRequest validateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = validateRequest;

        // create path and map variables
        String localVarPath = "/kyc/public_registry/validate";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "client_id", "client_secret", "module_secret" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call validateValidateBeforeCall(ValidateRequest validateRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'validateRequest' is set
        if (validateRequest == null) {
            throw new ApiException("Missing the required parameter 'validateRequest' when calling validate(Async)");
        }

        return validateCall(validateRequest, _callback);

    }


    private ApiResponse<ValidateResponse> validateWithHttpInfo(ValidateRequest validateRequest) throws ApiException {
        okhttp3.Call localVarCall = validateValidateBeforeCall(validateRequest, null);
        Type localVarReturnType = new TypeToken<ValidateResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call validateAsync(ValidateRequest validateRequest, final ApiCallback<ValidateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = validateValidateBeforeCall(validateRequest, _callback);
        Type localVarReturnType = new TypeToken<ValidateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class ValidateRequestBuilder {
        private final String referenceId;
        private final String documentType;
        private final String idNumber;
        private final String consent;
        private final String consentPurpose;
        private String dob;
        private String name;

        private ValidateRequestBuilder(String referenceId, String documentType, String idNumber, String consent, String consentPurpose) {
            this.referenceId = referenceId;
            this.documentType = documentType;
            this.idNumber = idNumber;
            this.consent = consent;
            this.consentPurpose = consentPurpose;
        }

        /**
         * Set dob
         * @param dob  (optional)
         * @return ValidateRequestBuilder
         */
        public ValidateRequestBuilder dob(String dob) {
            this.dob = dob;
            return this;
        }
        
        /**
         * Set name
         * @param name  (optional)
         * @return ValidateRequestBuilder
         */
        public ValidateRequestBuilder name(String name) {
            this.name = name;
            return this;
        }
        
        /**
         * Build call for validate
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * Server -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  * X-RateLimit-Limit-Second -  <br>  * X-RateLimit-Limit-Minute -  <br>  * X-RateLimit-Limit-Hour -  <br>  * RateLimit-Remaining -  <br>  * X-RateLimit-Remaining-Hour -  <br>  * RateLimit-Reset -  <br>  * X-RateLimit-Remaining-Minute -  <br>  * X-RateLimit-Remaining-Second -  <br>  * RateLimit-Limit -  <br>  * Kong-Request-ID -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            ValidateRequest validateRequest = buildBodyParams();
            return validateCall(validateRequest, _callback);
        }

        private ValidateRequest buildBodyParams() {
            ValidateRequest validateRequest = new ValidateRequest();
            validateRequest.referenceId(this.referenceId);
            validateRequest.documentType(this.documentType);
            validateRequest.idNumber(this.idNumber);
            validateRequest.dob(this.dob);
            validateRequest.consent(this.consent);
            validateRequest.consentPurpose(this.consentPurpose);
            validateRequest.name(this.name);
            return validateRequest;
        }

        /**
         * Execute validate request
         * @return ValidateResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * Server -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  * X-RateLimit-Limit-Second -  <br>  * X-RateLimit-Limit-Minute -  <br>  * X-RateLimit-Limit-Hour -  <br>  * RateLimit-Remaining -  <br>  * X-RateLimit-Remaining-Hour -  <br>  * RateLimit-Reset -  <br>  * X-RateLimit-Remaining-Minute -  <br>  * X-RateLimit-Remaining-Second -  <br>  * RateLimit-Limit -  <br>  * Kong-Request-ID -  <br>  </td></tr>
         </table>
         */
        public ValidateResponse execute() throws ApiException {
            ValidateRequest validateRequest = buildBodyParams();
            ApiResponse<ValidateResponse> localVarResp = validateWithHttpInfo(validateRequest);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute validate request with HTTP info returned
         * @return ApiResponse&lt;ValidateResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * Server -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  * X-RateLimit-Limit-Second -  <br>  * X-RateLimit-Limit-Minute -  <br>  * X-RateLimit-Limit-Hour -  <br>  * RateLimit-Remaining -  <br>  * X-RateLimit-Remaining-Hour -  <br>  * RateLimit-Reset -  <br>  * X-RateLimit-Remaining-Minute -  <br>  * X-RateLimit-Remaining-Second -  <br>  * RateLimit-Limit -  <br>  * Kong-Request-ID -  <br>  </td></tr>
         </table>
         */
        public ApiResponse<ValidateResponse> executeWithHttpInfo() throws ApiException {
            ValidateRequest validateRequest = buildBodyParams();
            return validateWithHttpInfo(validateRequest);
        }

        /**
         * Execute validate request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * Server -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  * X-RateLimit-Limit-Second -  <br>  * X-RateLimit-Limit-Minute -  <br>  * X-RateLimit-Limit-Hour -  <br>  * RateLimit-Remaining -  <br>  * X-RateLimit-Remaining-Hour -  <br>  * RateLimit-Reset -  <br>  * X-RateLimit-Remaining-Minute -  <br>  * X-RateLimit-Remaining-Second -  <br>  * RateLimit-Limit -  <br>  * Kong-Request-ID -  <br>  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ValidateResponse> _callback) throws ApiException {
            ValidateRequest validateRequest = buildBodyParams();
            return validateAsync(validateRequest, _callback);
        }
    }

    /**
     * Validate
     * 
     * @param validateRequest  (required)
     * @return ValidateRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  * Content-Length -  <br>  * Connection -  <br>  * Date -  <br>  * Server -  <br>  * X-DECENTRO-URN -  <br>  * Expect-CT -  <br>  * X-Permitted-Cross-Domain-Policies -  <br>  * X-Frame-Options -  <br>  * X-XSS-Protection -  <br>  * X-Content-Type-Options -  <br>  * Content-Security-Policy -  <br>  * X-Content-Security-Policy -  <br>  * Strict-Transport-Security -  <br>  * Referrer-Policy -  <br>  * vary -  <br>  * X-RateLimit-Limit-Second -  <br>  * X-RateLimit-Limit-Minute -  <br>  * X-RateLimit-Limit-Hour -  <br>  * RateLimit-Remaining -  <br>  * X-RateLimit-Remaining-Hour -  <br>  * RateLimit-Reset -  <br>  * X-RateLimit-Remaining-Minute -  <br>  * X-RateLimit-Remaining-Second -  <br>  * RateLimit-Limit -  <br>  * Kong-Request-ID -  <br>  </td></tr>
     </table>
     */
    public ValidateRequestBuilder validate(String referenceId, String documentType, String idNumber, String consent, String consentPurpose) throws IllegalArgumentException {
        if (referenceId == null) throw new IllegalArgumentException("\"referenceId\" is required but got null");
            if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }

        if (documentType == null) throw new IllegalArgumentException("\"documentType\" is required but got null");
            if (documentType.length() < 1) {
      throw new IllegalArgumentException("Invalid value for documentType. Length must be greater than or equal to 1.");
    }

        if (idNumber == null) throw new IllegalArgumentException("\"idNumber\" is required but got null");
            if (idNumber.length() < 1) {
      throw new IllegalArgumentException("Invalid value for idNumber. Length must be greater than or equal to 1.");
    }

        if (consent == null) throw new IllegalArgumentException("\"consent\" is required but got null");
            if (consent.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consent. Length must be greater than or equal to 1.");
    }

        if (consentPurpose == null) throw new IllegalArgumentException("\"consentPurpose\" is required but got null");
            if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }

        return new ValidateRequestBuilder(referenceId, documentType, idNumber, consent, consentPurpose);
    }
}
