/*
 * decentro-in-kyc
 * KYC & Onboarding
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: admin@decentro.tech
 *
 * Do not edit the class manually.
 */


package tech.decentro.in.kyc.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import tech.decentro.in.kyc.client.JSON;

/**
 * MatchFaceRequest
 */
@javax.annotation.Generated(value = "tech.decentro.in.kyc")
public class MatchFaceRequest {
  public static final String SERIALIZED_NAME_REFERENCE_ID = "reference_id";
  @SerializedName(SERIALIZED_NAME_REFERENCE_ID)
  private String referenceId;

  public static final String SERIALIZED_NAME_CONSENT = "consent";
  @SerializedName(SERIALIZED_NAME_CONSENT)
  private String consent;

  public static final String SERIALIZED_NAME_CONSENT_PURPOSE = "consent_purpose";
  @SerializedName(SERIALIZED_NAME_CONSENT_PURPOSE)
  private String consentPurpose;

  public static final String SERIALIZED_NAME_IMAGE1 = "image1";
  @SerializedName(SERIALIZED_NAME_IMAGE1)
  private File image1;

  public static final String SERIALIZED_NAME_IMAGE2 = "image2";
  @SerializedName(SERIALIZED_NAME_IMAGE2)
  private File image2;

  public static final String SERIALIZED_NAME_THRESHOLD = "threshold";
  @SerializedName(SERIALIZED_NAME_THRESHOLD)
  private Integer threshold;

  public static final String SERIALIZED_NAME_IMAGE1_URL = "image1_url";
  @SerializedName(SERIALIZED_NAME_IMAGE1_URL)
  private String image1Url;

  public static final String SERIALIZED_NAME_IMAGE2_URL = "image2_url";
  @SerializedName(SERIALIZED_NAME_IMAGE2_URL)
  private String image2Url;

  public MatchFaceRequest() {
  }

  public MatchFaceRequest referenceId(String referenceId) {
    // x-konfig-strip
    referenceId = StringUtils.strip(referenceId);

    
    
    if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }
    
    this.referenceId = referenceId;
    return this;
  }

   /**
   * 
   * @return referenceId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "ABCDEF12345", required = true, value = "")

  public String getReferenceId() {
    return referenceId;
  }


  public void setReferenceId(String referenceId) {
    // x-konfig-strip
    referenceId = StringUtils.strip(referenceId);

    
    
    if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }
    this.referenceId = referenceId;
  }


  public MatchFaceRequest consent(String consent) {
    // x-konfig-strip
    consent = StringUtils.strip(consent);

    
    
    if (consent.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consent. Length must be greater than or equal to 1.");
    }
    
    this.consent = consent;
    return this;
  }

   /**
   * 
   * @return consent
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "Y", required = true, value = "")

  public String getConsent() {
    return consent;
  }


  public void setConsent(String consent) {
    // x-konfig-strip
    consent = StringUtils.strip(consent);

    
    
    if (consent.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consent. Length must be greater than or equal to 1.");
    }
    this.consent = consent;
  }


  public MatchFaceRequest consentPurpose(String consentPurpose) {
    // x-konfig-strip
    consentPurpose = StringUtils.strip(consentPurpose);

    
    
    if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }
    
    this.consentPurpose = consentPurpose;
    return this;
  }

   /**
   * 
   * @return consentPurpose
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "For Testing Purpose Only", required = true, value = "")

  public String getConsentPurpose() {
    return consentPurpose;
  }


  public void setConsentPurpose(String consentPurpose) {
    // x-konfig-strip
    consentPurpose = StringUtils.strip(consentPurpose);

    
    
    if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }
    this.consentPurpose = consentPurpose;
  }


  public MatchFaceRequest image1(File image1) {

    
    
    
    
    this.image1 = image1;
    return this;
  }

   /**
   * Get image1
   * @return image1
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public File getImage1() {
    return image1;
  }


  public void setImage1(File image1) {

    
    
    
    this.image1 = image1;
  }


  public MatchFaceRequest image2(File image2) {

    
    
    
    
    this.image2 = image2;
    return this;
  }

   /**
   * Get image2
   * @return image2
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public File getImage2() {
    return image2;
  }


  public void setImage2(File image2) {

    
    
    
    this.image2 = image2;
  }


  public MatchFaceRequest threshold(Integer threshold) {

    
    
    
    
    this.threshold = threshold;
    return this;
  }

   /**
   * Get threshold
   * @return threshold
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "70", value = "")

  public Integer getThreshold() {
    return threshold;
  }


  public void setThreshold(Integer threshold) {

    
    
    
    this.threshold = threshold;
  }


  public MatchFaceRequest image1Url(String image1Url) {

    
    
    
    
    this.image1Url = image1Url;
    return this;
  }

   /**
   * Get image1Url
   * @return image1Url
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://pbs.twimg.com/media/FRW-XT2acAEBYQX?format=jpg&name=small", value = "")

  public String getImage1Url() {
    return image1Url;
  }


  public void setImage1Url(String image1Url) {

    
    
    
    this.image1Url = image1Url;
  }


  public MatchFaceRequest image2Url(String image2Url) {

    
    
    
    
    this.image2Url = image2Url;
    return this;
  }

   /**
   * Get image2Url
   * @return image2Url
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://pbs.twimg.com/media/FJKOfloaQAADOE9?format=jpg&name=large", value = "")

  public String getImage2Url() {
    return image2Url;
  }


  public void setImage2Url(String image2Url) {

    
    
    
    this.image2Url = image2Url;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   *
   * @param key name of the property
   * @param value value of the property
   * @return the MatchFaceRequest instance itself
   */
  public MatchFaceRequest putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return a map of objects
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key name of the property
   * @return an object
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MatchFaceRequest matchFaceRequest = (MatchFaceRequest) o;
    return Objects.equals(this.referenceId, matchFaceRequest.referenceId) &&
        Objects.equals(this.consent, matchFaceRequest.consent) &&
        Objects.equals(this.consentPurpose, matchFaceRequest.consentPurpose) &&
        Objects.equals(this.image1, matchFaceRequest.image1) &&
        Objects.equals(this.image2, matchFaceRequest.image2) &&
        Objects.equals(this.threshold, matchFaceRequest.threshold) &&
        Objects.equals(this.image1Url, matchFaceRequest.image1Url) &&
        Objects.equals(this.image2Url, matchFaceRequest.image2Url)&&
        Objects.equals(this.additionalProperties, matchFaceRequest.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(referenceId, consent, consentPurpose, image1, image2, threshold, image1Url, image2Url, additionalProperties);
  }

  @Override
  public String toString() {
    return toJson();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("reference_id");
    openapiFields.add("consent");
    openapiFields.add("consent_purpose");
    openapiFields.add("image1");
    openapiFields.add("image2");
    openapiFields.add("threshold");
    openapiFields.add("image1_url");
    openapiFields.add("image2_url");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("reference_id");
    openapiRequiredFields.add("consent");
    openapiRequiredFields.add("consent_purpose");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to MatchFaceRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!MatchFaceRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in MatchFaceRequest is not found in the empty JSON string", MatchFaceRequest.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : MatchFaceRequest.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("reference_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reference_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference_id").toString()));
      }
      if (!jsonObj.get("consent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `consent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("consent").toString()));
      }
      if (!jsonObj.get("consent_purpose").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `consent_purpose` to be a primitive type in the JSON string but got `%s`", jsonObj.get("consent_purpose").toString()));
      }
      if ((jsonObj.get("image1_url") != null && !jsonObj.get("image1_url").isJsonNull()) && !jsonObj.get("image1_url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image1_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image1_url").toString()));
      }
      if ((jsonObj.get("image2_url") != null && !jsonObj.get("image2_url").isJsonNull()) && !jsonObj.get("image2_url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image2_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image2_url").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!MatchFaceRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'MatchFaceRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<MatchFaceRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(MatchFaceRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<MatchFaceRequest>() {
           @Override
           public void write(JsonWriter out, MatchFaceRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public MatchFaceRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             MatchFaceRequest instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else if (entry.getValue().isJsonArray()) {
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), List.class));
                 } else { // JSON object
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of MatchFaceRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of MatchFaceRequest
  * @throws IOException if the JSON string is invalid with respect to MatchFaceRequest
  */
  public static MatchFaceRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, MatchFaceRequest.class);
  }

 /**
  * Convert an instance of MatchFaceRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

