/*
 * decentro-in-kyc
 * KYC & Onboarding
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: admin@decentro.tech
 *
 * Do not edit the class manually.
 */


package tech.decentro.in.kyc.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import tech.decentro.in.kyc.client.JSON;

/**
 * ValidateRequest
 */
@javax.annotation.Generated(value = "tech.decentro.in.kyc")
public class ValidateRequest {
  public static final String SERIALIZED_NAME_REFERENCE_ID = "reference_id";
  @SerializedName(SERIALIZED_NAME_REFERENCE_ID)
  private String referenceId;

  public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
  @SerializedName(SERIALIZED_NAME_DOCUMENT_TYPE)
  private String documentType;

  public static final String SERIALIZED_NAME_ID_NUMBER = "id_number";
  @SerializedName(SERIALIZED_NAME_ID_NUMBER)
  private String idNumber;

  public static final String SERIALIZED_NAME_DOB = "dob";
  @SerializedName(SERIALIZED_NAME_DOB)
  private String dob;

  public static final String SERIALIZED_NAME_CONSENT = "consent";
  @SerializedName(SERIALIZED_NAME_CONSENT)
  private String consent;

  public static final String SERIALIZED_NAME_CONSENT_PURPOSE = "consent_purpose";
  @SerializedName(SERIALIZED_NAME_CONSENT_PURPOSE)
  private String consentPurpose;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public ValidateRequest() {
  }

  public ValidateRequest referenceId(String referenceId) {
    // x-konfig-strip
    referenceId = StringUtils.strip(referenceId);

    
    
    if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }
    
    this.referenceId = referenceId;
    return this;
  }

   /**
   * Get referenceId
   * @return referenceId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "ABCDEF12345", required = true, value = "")

  public String getReferenceId() {
    return referenceId;
  }


  public void setReferenceId(String referenceId) {
    // x-konfig-strip
    referenceId = StringUtils.strip(referenceId);

    
    
    if (referenceId.length() < 1) {
      throw new IllegalArgumentException("Invalid value for referenceId. Length must be greater than or equal to 1.");
    }
    this.referenceId = referenceId;
  }


  public ValidateRequest documentType(String documentType) {
    // x-konfig-strip
    documentType = StringUtils.strip(documentType);

    
    
    if (documentType.length() < 1) {
      throw new IllegalArgumentException("Invalid value for documentType. Length must be greater than or equal to 1.");
    }
    
    this.documentType = documentType;
    return this;
  }

   /**
   * Get documentType
   * @return documentType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "PAN", required = true, value = "")

  public String getDocumentType() {
    return documentType;
  }


  public void setDocumentType(String documentType) {
    // x-konfig-strip
    documentType = StringUtils.strip(documentType);

    
    
    if (documentType.length() < 1) {
      throw new IllegalArgumentException("Invalid value for documentType. Length must be greater than or equal to 1.");
    }
    this.documentType = documentType;
  }


  public ValidateRequest idNumber(String idNumber) {
    // x-konfig-strip
    idNumber = StringUtils.strip(idNumber);

    
    
    if (idNumber.length() < 1) {
      throw new IllegalArgumentException("Invalid value for idNumber. Length must be greater than or equal to 1.");
    }
    
    this.idNumber = idNumber;
    return this;
  }

   /**
   * Get idNumber
   * @return idNumber
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "BNZPM2501F", required = true, value = "")

  public String getIdNumber() {
    return idNumber;
  }


  public void setIdNumber(String idNumber) {
    // x-konfig-strip
    idNumber = StringUtils.strip(idNumber);

    
    
    if (idNumber.length() < 1) {
      throw new IllegalArgumentException("Invalid value for idNumber. Length must be greater than or equal to 1.");
    }
    this.idNumber = idNumber;
  }


  public ValidateRequest dob(String dob) {

    
    
    
    
    this.dob = dob;
    return this;
  }

   /**
   * Get dob
   * @return dob
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1997-04-21", value = "")

  public String getDob() {
    return dob;
  }


  public void setDob(String dob) {

    
    
    
    this.dob = dob;
  }


  public ValidateRequest consent(String consent) {
    // x-konfig-strip
    consent = StringUtils.strip(consent);

    
    
    if (consent.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consent. Length must be greater than or equal to 1.");
    }
    
    this.consent = consent;
    return this;
  }

   /**
   * Get consent
   * @return consent
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "Y", required = true, value = "")

  public String getConsent() {
    return consent;
  }


  public void setConsent(String consent) {
    // x-konfig-strip
    consent = StringUtils.strip(consent);

    
    
    if (consent.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consent. Length must be greater than or equal to 1.");
    }
    this.consent = consent;
  }


  public ValidateRequest consentPurpose(String consentPurpose) {
    // x-konfig-strip
    consentPurpose = StringUtils.strip(consentPurpose);

    
    
    if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }
    
    this.consentPurpose = consentPurpose;
    return this;
  }

   /**
   * Get consentPurpose
   * @return consentPurpose
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "For Testing Purpose Only", required = true, value = "")

  public String getConsentPurpose() {
    return consentPurpose;
  }


  public void setConsentPurpose(String consentPurpose) {
    // x-konfig-strip
    consentPurpose = StringUtils.strip(consentPurpose);

    
    
    if (consentPurpose.length() < 1) {
      throw new IllegalArgumentException("Invalid value for consentPurpose. Length must be greater than or equal to 1.");
    }
    this.consentPurpose = consentPurpose;
  }


  public ValidateRequest name(String name) {

    
    
    
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Radha Ramalinga", value = "")

  public String getName() {
    return name;
  }


  public void setName(String name) {

    
    
    
    this.name = name;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   *
   * @param key name of the property
   * @param value value of the property
   * @return the ValidateRequest instance itself
   */
  public ValidateRequest putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return a map of objects
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key name of the property
   * @return an object
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ValidateRequest validateRequest = (ValidateRequest) o;
    return Objects.equals(this.referenceId, validateRequest.referenceId) &&
        Objects.equals(this.documentType, validateRequest.documentType) &&
        Objects.equals(this.idNumber, validateRequest.idNumber) &&
        Objects.equals(this.dob, validateRequest.dob) &&
        Objects.equals(this.consent, validateRequest.consent) &&
        Objects.equals(this.consentPurpose, validateRequest.consentPurpose) &&
        Objects.equals(this.name, validateRequest.name)&&
        Objects.equals(this.additionalProperties, validateRequest.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(referenceId, documentType, idNumber, dob, consent, consentPurpose, name, additionalProperties);
  }

  @Override
  public String toString() {
    return toJson();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("reference_id");
    openapiFields.add("document_type");
    openapiFields.add("id_number");
    openapiFields.add("dob");
    openapiFields.add("consent");
    openapiFields.add("consent_purpose");
    openapiFields.add("name");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("reference_id");
    openapiRequiredFields.add("document_type");
    openapiRequiredFields.add("id_number");
    openapiRequiredFields.add("consent");
    openapiRequiredFields.add("consent_purpose");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ValidateRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!ValidateRequest.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ValidateRequest is not found in the empty JSON string", ValidateRequest.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : ValidateRequest.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (!jsonObj.get("reference_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reference_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference_id").toString()));
      }
      if (!jsonObj.get("document_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `document_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("document_type").toString()));
      }
      if (!jsonObj.get("id_number").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id_number` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id_number").toString()));
      }
      if ((jsonObj.get("dob") != null && !jsonObj.get("dob").isJsonNull()) && !jsonObj.get("dob").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `dob` to be a primitive type in the JSON string but got `%s`", jsonObj.get("dob").toString()));
      }
      if (!jsonObj.get("consent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `consent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("consent").toString()));
      }
      if (!jsonObj.get("consent_purpose").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `consent_purpose` to be a primitive type in the JSON string but got `%s`", jsonObj.get("consent_purpose").toString()));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ValidateRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ValidateRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ValidateRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ValidateRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<ValidateRequest>() {
           @Override
           public void write(JsonWriter out, ValidateRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public ValidateRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             ValidateRequest instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else if (entry.getValue().isJsonArray()) {
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), List.class));
                 } else { // JSON object
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ValidateRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ValidateRequest
  * @throws IOException if the JSON string is invalid with respect to ValidateRequest
  */
  public static ValidateRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ValidateRequest.class);
  }

 /**
  * Convert an instance of ValidateRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

