/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common.engine.spi.summner;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class NameGenerator {
    private static final String NAME = "predefined.name.";
    private static final NameGenerator SINGLITON = new NameGenerator();
    private long index = 0L;
    private final String[] predefinedNames;
    private final Random nameIndexSelector;
    private final Lock lock = new ReentrantLock();

    private NameGenerator() {
        this.predefinedNames = NameGenerator.predefinedNames();
        this.nameIndexSelector = new Random();
    }

    public static final String nextName() {
        return SINGLITON.next();
    }

    private String next() {
        this.lock.lock();
        try {
            String string = this.predefinedNames[this.nameIndexSelector.nextInt(this.predefinedNames.length)] + '-' + this.index++;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static String[] predefinedNames() {
        ResourceBundle bundle = ResourceBundle.getBundle("tech.generated.common.engine.spi.summner.messages");
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (true) {
            try {
                String value = bundle.getString(NAME + i);
                result.add(value);
            }
            catch (MissingResourceException e) {
                break;
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }
}

