/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common.engine.spi.summner.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import tech.generated.common.Context;
import tech.generated.common.annotation.Filler;
import tech.generated.common.annotation.ForClass;
import tech.generated.common.annotation.InstanceBuilder;
import tech.generated.common.engine.spi.summner.Configuration;
import tech.generated.common.engine.spi.summner.DefaultFiller;
import tech.generated.common.engine.spi.summner.NameGenerator;
import tech.generated.common.engine.spi.summner.ValueContext;
import tech.generated.common.engine.spi.summner.annotation.AnnotationListener;
import tech.generated.common.engine.spi.summner.annotation.ConfigurationImpl;
import tech.generated.common.engine.spi.summner.annotation.SelectorAnnotationProcessor;
import tech.generated.common.engine.spi.summner.path.ClassAssignableFromSelector;
import tech.generated.common.engine.spi.summner.path.ClassEqualsSelector;
import tech.generated.common.engine.spi.summner.path.CommonValueMatchSelector;
import tech.generated.common.engine.spi.summner.path.ConnectToParentWrapperSelector;
import tech.generated.common.path.Selector;
import tech.generated.common.util.Util;

public class AnnotationBasedConfigurationFactory {
    private static final Predicate<Method> METHOD_PREDICATE_INSTANCE_BUILDER = method -> {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return method.getAnnotation(InstanceBuilder.class) != null && Modifier.isPublic(method.getModifiers()) && (parameterTypes.length == 0 || parameterTypes.length == 1 && Context.class.isAssignableFrom(parameterTypes[0]));
    };
    private static final Predicate<Method> METHOD_PREDICATE_FILLER = method -> {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return method.getAnnotation(InstanceBuilder.class) != null || Modifier.isPublic(method.getModifiers()) && method.getAnnotation(Filler.class) != null;
    };

    public Configuration build(Object configuration) {
        final ConfigurationImpl core = new ConfigurationImpl();
        AnnotationListener listener = new AnnotationListener(){

            @Override
            public void fireInstanceBuilder(Selector<Context<?>> selector, Function<Context<?>, ?> function) {
                core.add(selector, function);
            }

            @Override
            public <T> void fireFiller(Selector<Context<?>> selector, BiFunction<Context<?>, ?, ?> function) {
                core.add(selector, function);
            }
        };
        this.instancebuilders(configuration).forEach(p -> listener.fireInstanceBuilder((Selector)p.getLeft(), (Function)p.getRight()));
        this.fillers(configuration).forEach(p -> listener.fireFiller((Selector)p.getLeft(), (BiFunction)p.getRight()));
        return core;
    }

    private Stream<Pair<Selector<Context<?>>, Function<Context<?>, ?>>> instancebuilders(Object configuration) {
        return this.methods(configuration.getClass(), METHOD_PREDICATE_INSTANCE_BUILDER).map(m -> this.instanceBuilderWithSelector(configuration, (Method)m));
    }

    private Pair<Selector<Context<?>>, Function<Context<?>, ?>> instanceBuilderWithSelector(Object configuration, Method method) {
        Function<Context<?>, ?> function = this.instanceBuilder(configuration, method);
        Selector<Context<?>> selector = this.selectors(configuration, method).findFirst().get();
        return Pair.of(selector, function);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function<Context<?>, ?> instanceBuilder(Object configuration, Method method) {
        if (method.getAnnotation(InstanceBuilder.class) == null) throw new IllegalArgumentException("Method " + method + "must have signature '? function()' or '? function(" + Context.class + ")'!");
        Class<?>[] types = method.getParameterTypes();
        if (Supplier.class.isAssignableFrom(method.getReturnType())) {
            if (types.length == 0) {
                return context -> ((Supplier)Util.invoke(configuration, method, new Object[0])).get();
            }
            if (types.length != 1) throw new IllegalArgumentException("Method " + method + "must have signature 'Function function()' or 'Function function(" + Context.class + ")'!");
            if (!Context.class.isAssignableFrom(types[0])) throw new IllegalArgumentException("Method " + method + "must have signature 'Function function()' or 'Function function(" + Context.class + ")'!");
            return context -> ((Supplier)Util.invoke(configuration, method, context)).get();
        }
        if (types.length == 0) {
            return context -> Util.invoke(configuration, method, new Object[0]);
        }
        if (types.length != 1) throw new IllegalArgumentException("Method " + method + "must have signature '? function()' or '? function(" + Context.class + ")'!");
        if (!Context.class.isAssignableFrom(types[0])) throw new IllegalArgumentException("Method " + method + "must have signature '? function()' or '? function(" + Context.class + ")'!");
        return context -> Util.invoke(configuration, method, context);
    }

    private Stream<Pair<Selector<Context<?>>, BiFunction<Context<?>, ?, ?>>> fillers(Object configuration) {
        return this.methods(configuration.getClass(), METHOD_PREDICATE_FILLER).map(m -> this.fillerWithSelector(configuration, (Method)m));
    }

    private Pair<Selector<Context<?>>, BiFunction<Context<?>, ?, ?>> fillerWithSelector(Object configuration, Method method) {
        BiFunction<Context<?>, ?, ?> function = this.filler(configuration, method);
        Selector<Context<?>> selector = this.selectors(configuration, method).findFirst().get();
        return Pair.of(selector, function);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BiFunction<Context<?>, ?, ?> filler(Object configuration, Method method) {
        if (method.getAnnotation(InstanceBuilder.class) == null) {
            Class<?>[] types = method.getParameterTypes();
            if (Function.class.isAssignableFrom(method.getReturnType())) {
                if (types.length == 0) {
                    return (context, object) -> ((Function)Util.invoke(configuration, method, new Object[0])).apply(object);
                }
                if (types.length != 1) throw new IllegalArgumentException("Method " + method + "must have signature '? function()' or '? function(" + Context.class + ")'!");
                if (!Context.class.isAssignableFrom(types[0])) throw new IllegalArgumentException("Method " + method + "must have signature '? function()' or '? function(" + Context.class + ")'!");
                return (context, object) -> ((Function)Util.invoke(configuration, method, context)).apply(object);
            }
            if (types.length <= 0) throw new IllegalArgumentException("Method " + method + " must have signature: '? function(? object, " + Context.class + " context)' or '? function(" + Context.class + " context, ? object)'!");
            if (types.length >= 3) throw new IllegalArgumentException("Method " + method + " must have signature: '? function(? object, " + Context.class + " context)' or '? function(" + Context.class + " context, ? object)'!");
            if (types.length == 1) {
                return (context, object) -> Util.invoke(configuration, method, object);
            }
            if (Context.class.isAssignableFrom(types[0])) {
                return (context, object) -> Util.invoke(configuration, method, context, object);
            }
            if (!Context.class.isAssignableFrom(types[1])) throw new IllegalArgumentException("Method " + method + " must have signature: '? function(? object, " + Context.class + " context)' or '? function(" + Context.class + " context, ? object)'!");
            return (context, object) -> Util.invoke(configuration, method, object, context);
        }
        if (!method.getAnnotation(InstanceBuilder.class).simple()) return (context, object) -> new DefaultFiller<Object>((ValueContext)context).apply(object);
        return (context, object) -> object;
    }

    private Stream<Selector<Context<?>>> selectors(Object configuration, Method method) {
        return Stream.of(Stream.of(method.getAnnotations()).filter(a -> !(a instanceof InstanceBuilder) && !(a instanceof Filler) && !(a instanceof ForClass)).map(a -> SelectorAnnotationProcessor.get(a).map(p -> p.process(this, configuration, method, (Annotation)a)).orElse(null)).filter(e -> e != null && e instanceof Selector).map(e -> (Selector)e).reduce(this.getClassSelector(configuration, method), (l, r) -> l != null ? ConnectToParentWrapperSelector.of(l, r) : r));
    }

    private Selector<Context<?>> getClassSelector(Object configuration, Method method) {
        return Optional.ofNullable(method.getAnnotation(ForClass.class)).map(a -> {
            CommonValueMatchSelector selector = a.strict() ? new ClassEqualsSelector(a.name() != null ? a.name() : NameGenerator.nextName(), null, method.getAnnotation(InstanceBuilder.class) != null ? Long.MIN_VALUE : a.metrics(), a.value()) : new ClassAssignableFromSelector(a.name() != null ? a.name() : NameGenerator.nextName(), null, method.getAnnotation(InstanceBuilder.class) != null ? Long.MIN_VALUE : a.metrics(), a.value());
            return selector;
        }).orElseGet(() -> new ClassEqualsSelector(NameGenerator.nextName(), null, method.getAnnotation(InstanceBuilder.class) != null ? Long.MIN_VALUE : 0L, this.classOf(method)));
    }

    private String getName(ForClass annotation) {
        return annotation.name() != null ? annotation.name() : NameGenerator.nextName();
    }

    private Class<?> classOf(Method method) {
        Type type;
        Class<Object> result = method.getAnnotation(InstanceBuilder.class) != null ? ((type = method.getGenericReturnType()) instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Supplier.class) ? Util.getSupplierReturnType((ParameterizedType)type) : (Class<?>)type) : (method.getAnnotation(Filler.class) != null ? ((type = method.getGenericReturnType()) instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Function.class) ? Util.getFunctionArgumentType((ParameterizedType)type) : (Class)type) : null);
        return result;
    }

    private Stream<Method> methods(Class<?> clazz, Predicate<Method> predicate) {
        Class<?> superClass = clazz.getSuperclass();
        return Stream.of(clazz.getMethods()).filter(predicate);
    }
}

