/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common.engine.spi.summner.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.LinkedList;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import tech.generated.common.Context;
import tech.generated.common.annotation.Path;
import tech.generated.common.engine.spi.summner.NameGenerator;
import tech.generated.common.engine.spi.summner.annotation.AnnotationBasedConfigurationFactory;
import tech.generated.common.engine.spi.summner.annotation.SelectorAnnotationProcessor;
import tech.generated.common.engine.spi.summner.path.MatchedNameSelector;
import tech.generated.common.engine.spi.summner.path.NameEqualsSelector;
import tech.generated.common.engine.spi.summner.path.RootMatchSelector;
import tech.generated.common.engine.spi.summner.path.SkipNameSelector;
import tech.generated.common.path.Selector;
import tech.generated.common.pc.path.parser.PathBaseListener;
import tech.generated.common.pc.path.parser.PathLexer;
import tech.generated.common.pc.path.parser.PathParser;

public class PathSelectorAnnotationProcessor
extends SelectorAnnotationProcessor {
    @Override
    public Object process(AnnotationBasedConfigurationFactory factory, Object configuration, Method method, Annotation annotation) {
        Path pathAnnotation = (Path)annotation;
        CodePointCharStream stream = CharStreams.fromString((String)pathAnnotation.value());
        PathLexer lexer = new PathLexer((CharStream)stream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        PathParser parser = new PathParser((TokenStream)tokenStream);
        ParseTreeWalker walker = new ParseTreeWalker();
        Listener listener = new Listener(pathAnnotation.name().isEmpty() ? NameGenerator.nextName() : pathAnnotation.name(), pathAnnotation.metrics());
        walker.walk((ParseTreeListener)listener, (ParseTree)parser.path());
        return listener.result;
    }

    @Override
    public long metrics() {
        return 10L;
    }

    @Override
    public Class<? extends Annotation> annotationClass() {
        return Path.class;
    }

    private static class Listener
    extends PathBaseListener {
        private final String name;
        private final long metrics;
        final Deque<Object> stack = new LinkedList<Object>();
        Selector<Context<?>> result;

        private Listener(String name, long metrics) {
            this.name = name;
            this.metrics = metrics;
        }

        private long build(long def) {
            long metrics = this.metrics == 0L ? def : (this.result == null ? this.metrics : 0L);
            return metrics;
        }

        @Override
        public void enterRoot(PathParser.RootContext ctx) {
            this.result = new RootMatchSelector(this.name, this.result, this.build(1L));
        }

        @Override
        public void enterName(PathParser.NameContext ctx) {
            this.result = new NameEqualsSelector(this.name, this.result, this.build(1L), ctx.getText());
        }

        @Override
        public void enterMatchedName(PathParser.MatchedNameContext ctx) {
            this.result = new MatchedNameSelector(this.name, this.result, this.build(1L), ctx.getText());
        }

        @Override
        public void enterSkip(PathParser.SkipContext ctx) {
            this.stack.push(0);
        }

        @Override
        public void exitSkip(PathParser.SkipContext ctx) {
            int count = (Integer)this.stack.pop();
            this.result = new SkipNameSelector(this.name, this.result, this.build(count), count);
        }

        @Override
        public void enterSkipElememt(PathParser.SkipElememtContext ctx) {
            int count = (Integer)this.stack.pop();
            this.stack.push(count += ctx.SKIP_NAME_COUNT() != null ? Integer.parseInt(ctx.SKIP_NAME_COUNT().getText()) : 1);
        }

        @Override
        public void visitErrorNode(ErrorNode node) {
            throw new RuntimeException("Unexpected string: '" + node.getText() + "'");
        }
    }
}

