/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common.engine.spi.summner.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.generated.common.engine.spi.summner.annotation.AnnotationBasedConfigurationFactory;

public abstract class SelectorAnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SelectorAnnotationProcessor.class);
    private static final Map<Class<? extends Annotation>, Optional<SelectorAnnotationProcessor>> ANNOTATION_PROCESSOR_MAP = new HashMap<Class<? extends Annotation>, Optional<SelectorAnnotationProcessor>>();

    public static Optional<SelectorAnnotationProcessor> get(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        Optional<SelectorAnnotationProcessor> annotationProcessor = ANNOTATION_PROCESSOR_MAP.get(clazz);
        if (annotationProcessor == null) {
            LOG.warn("There is no annotation processor for '" + clazz + "!");
            annotationProcessor = Optional.empty();
        }
        return annotationProcessor;
    }

    public abstract long metrics();

    public abstract Object process(AnnotationBasedConfigurationFactory var1, Object var2, Method var3, Annotation var4);

    public abstract Class<? extends Annotation> annotationClass();

    static {
        ServiceLoader<SelectorAnnotationProcessor> serviceLoader = ServiceLoader.load(SelectorAnnotationProcessor.class);
        for (SelectorAnnotationProcessor processor : serviceLoader) {
            ANNOTATION_PROCESSOR_MAP.put(processor.annotationClass(), Optional.of(processor));
            LOG.info("Annotation processor '{}' for class '{}' loaded!", (Object)processor, processor.annotationClass());
        }
    }
}

