/*
 * Decompiled with CFR 0.152.
 */
package tech.generated.common.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tech.generated.common.engine.reflect.ReflectionException;

public final class Util {
    private static final Map<Class<?>, Class<?>> BOXED_PRIMITIVE;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_BOXED;
    private static final Collection<Class<?>> SIMPLE_CLASSES;

    public static final boolean isSimple(Class<?> clazz) {
        return SIMPLE_CLASSES.contains(clazz);
    }

    public static final boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public static final boolean isBoxing(Class<?> clazz) {
        return BOXED_PRIMITIVE.containsKey(clazz);
    }

    public static Class<?> getDual(Class<?> clazz) {
        Class<?> result = BOXED_PRIMITIVE.get(clazz);
        if (result == null && (result = PRIMITIVE_BOXED.get(clazz)) == null) {
            result = clazz;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AccessibleObject, R> R apply(T accessibleObject, Function<T, R> f) {
        boolean originAccessibleState = accessibleObject.isAccessible();
        accessibleObject.setAccessible(true);
        try {
            R r = f.apply(accessibleObject);
            return r;
        }
        finally {
            accessibleObject.setAccessible(originAccessibleState);
        }
    }

    public static <T> T invoke(Object target, Method method, Object ... args) {
        return (T)Util.apply(method, m -> {
            try {
                return m.invoke(target, args);
            }
            catch (Exception e) {
                throw new ReflectionException("Can't invoke " + m, e);
            }
        });
    }

    public static <T> void setFieldValue(Field field, Object object, T value) {
        Util.apply(field, f -> {
            try {
                f.set(object, value);
                return null;
            }
            catch (Exception e) {
                throw new ReflectionException("Can't set value of " + f, e);
            }
        });
    }

    public static <T> T getFieldValue(Field field, Object object) {
        Object result = Util.isSimple(field.getType()) ? object : Util.apply(field, f -> {
            try {
                return f.get(object);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Can't get value of field " + f + " of object " + object + " !", e);
            }
        });
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            boolean originAccessibleState = constructor.isAccessible();
            try {
                constructor.setAccessible(true);
                T t = constructor.newInstance(new Object[0]);
                return t;
            }
            finally {
                constructor.setAccessible(originAccessibleState);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Can't create object of class '" + clazz + "'!", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> getSupplierReturnType(ParameterizedType type) {
        if (type == null) return null;
        if (!type.getRawType().equals(Supplier.class)) throw new IllegalArgumentException("type parameter represents " + type.getRawType() + ". Must be " + Supplier.class + "!");
        return (Class)type.getActualTypeArguments()[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> getFunctionArgumentType(ParameterizedType type) {
        if (type == null) return null;
        if (!type.getRawType().equals(Function.class)) throw new IllegalArgumentException("type parameter represents " + type.getRawType() + ". Must be " + Function.class + "!");
        return (Class)type.getActualTypeArguments()[0];
    }

    public static Class<?> getFunctionArgumentType(Function<?, ?> function) {
        return Util.getFunctionArgumentType(function.getClass());
    }

    public static Class<?> getFunctionArgumentType(Class<? extends Function> clazz) {
        Class result = clazz != null ? Stream.of(clazz.getMethods()).filter(m -> "apply".equals(m.getName()) && m.getParameterCount() == 1).map(m -> m.getParameterTypes()[0]).findFirst().get() : null;
        return result;
    }

    static {
        HashMap<Class<Double>, Class<Comparable<Boolean>>> boxed_primitive = new HashMap<Class<Double>, Class<Comparable<Boolean>>>();
        boxed_primitive.put(Boolean.class, Boolean.TYPE);
        boxed_primitive.put(Byte.class, Byte.TYPE);
        boxed_primitive.put(Short.class, Short.TYPE);
        boxed_primitive.put(Integer.class, Integer.TYPE);
        boxed_primitive.put(Long.class, Long.TYPE);
        boxed_primitive.put(Float.class, Float.TYPE);
        boxed_primitive.put(Double.class, Double.TYPE);
        BOXED_PRIMITIVE = Collections.unmodifiableMap(boxed_primitive);
        HashMap primitive_boxed = new HashMap();
        for (Map.Entry entry : boxed_primitive.entrySet()) {
            primitive_boxed.put(entry.getValue(), entry.getKey());
        }
        PRIMITIVE_BOXED = Collections.unmodifiableMap(primitive_boxed);
        HashSet simple = new HashSet();
        simple.add(String.class);
        simple.add(UUID.class);
        simple.addAll(BOXED_PRIMITIVE.keySet());
        simple.addAll(PRIMITIVE_BOXED.keySet());
        SIMPLE_CLASSES = Collections.unmodifiableCollection(simple);
    }
}

