/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.cucumber.glue;

import io.cucumber.java.After;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.harmonysoft.oss.common.time.util.DateTimeHelper;
import tech.harmonysoft.oss.test.TestAware;
import tech.harmonysoft.oss.test.binding.DynamicBindingContext;
import tech.harmonysoft.oss.test.binding.DynamicBindingKey;
import tech.harmonysoft.oss.test.content.TestContentManager;
import tech.harmonysoft.oss.test.fixture.FixtureDataHelper;
import tech.harmonysoft.oss.test.time.clock.TestClock;
import tech.harmonysoft.oss.test.time.clock.TestClockProvider;
import tech.harmonysoft.oss.test.util.TestUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0007J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0007J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0017H\u0007J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0007J\b\u0010\"\u001a\u00020\u0015H\u0007J\b\u0010#\u001a\u00020\u0015H\u0007J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0017H\u0007J \u0010&\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0017H\u0007J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0017H\u0007J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0017H\u0007J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0017H\u0007J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0007J\u0018\u00102\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u0017H\u0007J\u0010\u00104\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00118\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Ltech/harmonysoft/oss/cucumber/glue/CommonStepDefinitions;", "", "()V", "bindingContext", "Ltech/harmonysoft/oss/test/binding/DynamicBindingContext;", "clockProvider", "Ltech/harmonysoft/oss/test/time/clock/TestClockProvider;", "contentManager", "Ltech/harmonysoft/oss/test/content/TestContentManager;", "dateTimeHelper", "Ltech/harmonysoft/oss/common/time/util/DateTimeHelper;", "fixtureDataHelper", "Ltech/harmonysoft/oss/test/fixture/FixtureDataHelper;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "testCallbacks", "Ljava/util/Optional;", "", "Ltech/harmonysoft/oss/test/TestAware;", "bindDynamicValue", "", "key", "", "value", "configureTextContent", "name", "data", "excludeMetaValueFromExpansion", "metaValue", "logScenarioEnd", "scenario", "Lio/cucumber/java/Scenario;", "logScenarioStart", "notifyOnTestEnd", "notifyOnTestStart", "setDate", "date", "setDateTimeZone", "time", "zone", "setTime", "setTimeOnDayOfWeek", "rawTime", "rawDayOfWeek", "setTimeZone", "zoneId", "sleep", "timeToSleepInSeconds", "", "verifyDynamicValue", "expected", "verifyDynamicValueIsNotSet", "harmonysoft-common-cucumber"})
public final class CommonStepDefinitions {
    private final Logger logger = LoggerFactory.getLogger(CommonStepDefinitions.class);
    @Inject
    private Optional<Collection<TestAware>> testCallbacks;
    @Inject
    private TestClockProvider clockProvider;
    @Inject
    private DateTimeHelper dateTimeHelper;
    @Inject
    private TestContentManager contentManager;
    @Inject
    private FixtureDataHelper fixtureDataHelper;
    @Inject
    private DynamicBindingContext bindingContext;

    @Before
    public final void logScenarioStart(@NotNull Scenario scenario) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        this.logger.info("Starting scenario '{}'", (Object)scenario.getName());
    }

    @After
    public final void logScenarioEnd(@NotNull Scenario scenario) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        this.logger.info("Finished scenario '{}'", (Object)scenario.getName());
    }

    @Before
    public final void notifyOnTestStart() {
        Optional<Collection<TestAware>> optional = this.testCallbacks;
        if (optional == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCallbacks");
            optional = null;
        }
        optional.ifPresent(CommonStepDefinitions::notifyOnTestStart$lambda-0);
    }

    @After
    public final void notifyOnTestEnd() {
        Optional<Collection<TestAware>> optional = this.testCallbacks;
        if (optional == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCallbacks");
            optional = null;
        }
        optional.ifPresent(CommonStepDefinitions::notifyOnTestEnd$lambda-1);
    }

    @Given(value="^current time zone is set as ([^\\s]+)$")
    public final void setTimeZone(@NotNull String zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZoneId zone = ZoneId.of(zoneId);
        TestClockProvider testClockProvider = this.clockProvider;
        if (testClockProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clockProvider");
            testClockProvider = null;
        }
        testClockProvider.getData().withZone(zone);
    }

    @Given(value="^current time is set as ([^\\s]+)$")
    public final void setTime(@NotNull String time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        DateTimeHelper dateTimeHelper = this.dateTimeHelper;
        if (dateTimeHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateTimeHelper");
            dateTimeHelper = null;
        }
        LocalTime localTime = dateTimeHelper.parseTime(time);
        TestClockProvider testClockProvider = this.clockProvider;
        if (testClockProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clockProvider");
            testClockProvider = null;
        }
        TestClock clock = testClockProvider.getData();
        clock.withInstant(localTime.atDate(LocalDate.now((Clock)clock)).atZone(clock.getZone()).toInstant().toEpochMilli());
    }

    @Given(value="^current date is set as ([^\\s]+)$")
    public final void setDate(@NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        TestClockProvider testClockProvider = this.clockProvider;
        if (testClockProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clockProvider");
            testClockProvider = null;
        }
        TestClock clock = testClockProvider.getData();
        DateTimeHelper dateTimeHelper = this.dateTimeHelper;
        if (dateTimeHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateTimeHelper");
            dateTimeHelper = null;
        }
        LocalDateTime dateTime = dateTimeHelper.parseDateTime(date + " 00:00:00.000");
        clock.withInstant(dateTime.atZone(clock.getZone()).toInstant().toEpochMilli());
    }

    @Given(value="^current date/time is set as ([^\\s]+) ([^\\s]+) ([^\\s]+)$")
    public final void setDateTimeZone(@NotNull String date, @NotNull String time, @NotNull String zone) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        this.setTimeZone(zone);
        this.setDate(date);
        this.setTimeZone(time);
    }

    @Given(value="^current time is set as ([^\\s]+) on ([^\\s]+)$")
    public final void setTimeOnDayOfWeek(@NotNull String rawTime, @NotNull String rawDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)rawTime, (String)"rawTime");
        Intrinsics.checkNotNullParameter((Object)rawDayOfWeek, (String)"rawDayOfWeek");
        DateTimeHelper dateTimeHelper = this.dateTimeHelper;
        if (dateTimeHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dateTimeHelper");
            dateTimeHelper = null;
        }
        LocalTime localTime = dateTimeHelper.parseTime(rawTime);
        ZoneId zoneId = ZoneId.systemDefault();
        TestClockProvider testClockProvider = this.clockProvider;
        if (testClockProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clockProvider");
            testClockProvider = null;
        }
        TestClock clock = testClockProvider.getData();
        LocalDate today = LocalDate.now((Clock)clock);
        String string = rawDayOfWeek.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        DayOfWeek targetDayOfWeek = DayOfWeek.valueOf(string);
        int daysDiff = today.getDayOfWeek().ordinal() - targetDayOfWeek.ordinal();
        LocalDate localDate = LocalDate.now((Clock)clock).minusDays(daysDiff);
        this.logger.info("USing local date {} and local time {}", (Object)localDate, (Object)localTime);
        clock.withInstant(localTime.atDate(localDate).atZone(zoneId).toInstant().toEpochMilli());
    }

    @Given(value="^the application sleeps (\\d+) seconds$")
    public final void sleep(long timeToSleepInSeconds) {
        Thread.sleep(TimeUnit.SECONDS.toMillis(timeToSleepInSeconds));
    }

    @Given(value="^the following text content with name '([^']+)' is prepared:$")
    public final void configureTextContent(@NotNull String name, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TestContentManager testContentManager = this.contentManager;
        if (testContentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            testContentManager = null;
        }
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        testContentManager.setContent(name, byArray);
    }

    @Given(value="^meta-value <([^>]+)> is excluded from auto expansion$")
    public final void excludeMetaValueFromExpansion(@NotNull String metaValue) {
        Intrinsics.checkNotNullParameter((Object)metaValue, (String)"metaValue");
        FixtureDataHelper fixtureDataHelper = this.fixtureDataHelper;
        if (fixtureDataHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fixtureDataHelper");
            fixtureDataHelper = null;
        }
        fixtureDataHelper.excludeMetaValueFromExpansion(metaValue);
    }

    @Given(value="^dynamic key ([^\\s]+) is bound to value '([^']+)'$")
    public final void bindDynamicValue(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DynamicBindingContext dynamicBindingContext = this.bindingContext;
        if (dynamicBindingContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindingContext");
            dynamicBindingContext = null;
        }
        dynamicBindingContext.storeBinding(new DynamicBindingKey(key), (Object)value);
    }

    @Then(value="^dynamic key '([^']+)' should have value '([^']+)'$")
    public final void verifyDynamicValue(@NotNull String key, @NotNull String expected) {
        Object actual;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        DynamicBindingContext dynamicBindingContext = this.bindingContext;
        if (dynamicBindingContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindingContext");
            dynamicBindingContext = null;
        }
        if (!Intrinsics.areEqual((Object)(actual = dynamicBindingContext.getBinding(new DynamicBindingKey(key))), (Object)expected)) {
            TestUtil.INSTANCE.fail("expected dynamic key '" + key + "' to have value '" + expected + "' but it has value '" + actual + "' instead");
            throw new KotlinNothingValueException();
        }
    }

    @Then(value="^dynamic key '([^']+)' is not set'$")
    public final void verifyDynamicValueIsNotSet(@NotNull String key) {
        boolean bound;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DynamicBindingKey dynamicKey = new DynamicBindingKey(key);
        DynamicBindingContext dynamicBindingContext = this.bindingContext;
        if (dynamicBindingContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindingContext");
            dynamicBindingContext = null;
        }
        if (bound = dynamicBindingContext.hasBindingFor(dynamicKey)) {
            StringBuilder stringBuilder = new StringBuilder().append("expected that dynamic key '").append(key).append("' is not set but it has value '");
            DynamicBindingContext dynamicBindingContext2 = this.bindingContext;
            if (dynamicBindingContext2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bindingContext");
                dynamicBindingContext2 = null;
            }
            TestUtil.INSTANCE.fail(stringBuilder.append(dynamicBindingContext2.getBinding(dynamicKey)).append('\'').toString());
            throw new KotlinNothingValueException();
        }
    }

    private static final void notifyOnTestStart$lambda-0(Collection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (TestAware callback : it) {
            callback.onTestStart();
        }
    }

    private static final void notifyOnTestEnd$lambda-1(Collection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        for (TestAware callback : it) {
            callback.onTestEnd();
        }
    }
}

