/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.di;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import tech.harmonysoft.oss.common.di.CacheableObjectProvider;
import tech.harmonysoft.oss.common.di.CacheableProvider;
import tech.harmonysoft.oss.common.string.util.StringUtilKt;

@Named
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltech/harmonysoft/oss/common/di/ObjectProviderEnhancer;", "Lorg/springframework/beans/factory/config/BeanFactoryPostProcessor;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "postProcessBeanFactory", "", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableListableBeanFactory;", "harmonysoft-common-spring"})
public final class ObjectProviderEnhancer
implements BeanFactoryPostProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) {
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        if (Intrinsics.areEqual((Object)System.getProperty("harmonysoft.di.spring.cache.provider.enabled"), (Object)"false")) {
            this.logger.info("Skipped replacing dependency provides by cacheable implementation");
            return;
        }
        String[] stringArray = beanFactory.getBeanDefinitionNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"beanFactory.beanDefinitionNames");
        for (String beanName : stringArray) {
            Class<?> clazz;
            String beanClassName;
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            if (StringUtilKt.isNotNullNotBlankEffective((CharSequence)definition.getFactoryMethodName()) || definition.getBeanClassName() == null) continue;
            try {
                clazz = Class.forName(beanClassName);
            }
            catch (Throwable e) {
                this.logger.info("Skipping dependency provider enhancing for class '{}' - can't load it", (Object)beanClassName);
                continue;
            }
            Class<?> beanClass = clazz;
            Constructor<?>[] constructors = beanClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue(constructors, (String)"constructors");
            block3: for (Constructor<?> constructor : constructors) {
                Type[] parameterTypes = constructor.getGenericParameterTypes();
                int i = -1;
                Intrinsics.checkNotNullExpressionValue((Object)parameterTypes, (String)"parameterTypes");
                for (Type parameterType : parameterTypes) {
                    Class rawClass;
                    ++i;
                    if (!(parameterType instanceof ParameterizedType)) continue;
                    Object[] objectArray = ((ParameterizedType)parameterType).getRawType();
                    Class clazz2 = objectArray instanceof Class ? (Class)objectArray : null;
                    if (clazz2 == null || !Intrinsics.areEqual((Object)(rawClass = clazz2), ObjectProvider.class) && !Intrinsics.areEqual((Object)rawClass, Provider.class)) continue;
                    Object[] typeArguments = ((ParameterizedType)parameterType).getActualTypeArguments();
                    if (typeArguments.length != 1) {
                        objectArray = new Object[]{rawClass.getName(), typeArguments.length, typeArguments};
                        this.logger.warn("Expected to find a single type parameter in class {} but found {}: {}, skipping enhancing for it", objectArray);
                        continue block3;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)typeArguments, (String)"typeArguments");
                    Type typeArgument = (Type)ArraysKt.first((Object[])typeArguments);
                    if (!(typeArgument instanceof Class)) {
                        if (typeArgument instanceof ParameterizedType && (Intrinsics.areEqual((Object)((ParameterizedType)typeArgument).getRawType(), Optional.class) || Intrinsics.areEqual((Object)((ParameterizedType)typeArgument).getRawType(), Collection.class) || Intrinsics.areEqual((Object)((ParameterizedType)typeArgument).getRawType(), List.class))) {
                            this.logger.info("Skipped " + rawClass + '<' + ((ParameterizedType)typeArgument).getRawType() + "> enhancing for class {}", (Object)beanClassName);
                            continue;
                        }
                        Object[] objectArray2 = new Object[]{rawClass.getName(), i, beanClassName};
                        this.logger.warn("Failed to replace {} constructor argument #{} (zero-based) by cacheable implementation in class {} - can't deduce type parameter value", objectArray2);
                        continue;
                    }
                    CacheableProvider objectProvider = new CacheableObjectProvider((ListableBeanFactory)beanFactory, (Class)typeArgument);
                    CacheableProvider decorator2 = Intrinsics.areEqual((Object)rawClass, ObjectProvider.class) ? objectProvider : new CacheableProvider((Function0)new Function0<Object>((CacheableObjectProvider<? extends Object>)objectProvider){
                        final /* synthetic */ CacheableObjectProvider<? extends Object> $objectProvider;
                        {
                            this.$objectProvider = $objectProvider;
                            super(0);
                        }

                        public final Object invoke() {
                            return this.$objectProvider.getObject();
                        }
                    });
                    definition.getConstructorArgumentValues().addIndexedArgumentValue(i, (Object)decorator2);
                }
            }
        }
    }
}

