/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.time.schedule.impl;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.harmonysoft.oss.common.time.schedule.impl.TimeProcessingStrategy;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Ltech/harmonysoft/oss/common/time/schedule/impl/LocalDateTimeProcessingStrategy;", "Ltech/harmonysoft/oss/common/time/schedule/impl/TimeProcessingStrategy;", "Ljava/time/LocalDateTime;", "()V", "timeMsBeforeEndOfTheDay", "", "time", "timeMsFromStartOfTheDay", "Ljava/time/LocalTime;", "toDayOfWeek", "Ljava/time/DayOfWeek;", "harmonysoft-common"})
public final class LocalDateTimeProcessingStrategy
implements TimeProcessingStrategy<LocalDateTime> {
    @NotNull
    public static final LocalDateTimeProcessingStrategy INSTANCE = new LocalDateTimeProcessingStrategy();

    private LocalDateTimeProcessingStrategy() {
    }

    @Override
    @NotNull
    public DayOfWeek toDayOfWeek(@NotNull LocalDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        DayOfWeek dayOfWeek = time.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"time.dayOfWeek");
        return dayOfWeek;
    }

    @Override
    public long timeMsFromStartOfTheDay(@NotNull LocalDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        LocalTime localTime = time.toLocalTime();
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"time.toLocalTime()");
        return this.timeMsFromStartOfTheDay(localTime);
    }

    @Override
    public final long timeMsFromStartOfTheDay(@NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return Duration.between(LocalTime.MIN, time).toMillis();
    }

    @Override
    public long timeMsBeforeEndOfTheDay(@NotNull LocalDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return Duration.between(time.toLocalTime(), LocalTime.MAX).toMillis() + 1L;
    }
}

