/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.time.clock;

import java.time.Clock;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.common.time.clock.ClockProvider;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltech/harmonysoft/oss/common/time/clock/ZonedSystemClockProvider;", "Ltech/harmonysoft/oss/common/time/clock/ClockProvider;", "zoneId", "Ljava/time/ZoneId;", "(Ljava/time/ZoneId;)V", "clock", "Ljava/time/Clock;", "kotlin.jvm.PlatformType", "equals", "", "other", "", "getData", "hashCode", "", "probe", "refresh", "", "toString", "", "withZone", "zone", "harmonysoft-common"})
public final class ZonedSystemClockProvider
implements ClockProvider {
    private final Clock clock;

    public ZonedSystemClockProvider(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.clock = Clock.system(zoneId);
    }

    @NotNull
    public Clock getData() {
        Clock clock = this.clock;
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"clock");
        return clock;
    }

    @Override
    @NotNull
    public ClockProvider withZone(@NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return Intrinsics.areEqual((Object)this.clock.getZone(), (Object)zone) ? (ClockProvider)this : ClockProvider.Companion.forZone(zone);
    }

    public void refresh() {
    }

    @NotNull
    public Clock probe() {
        return this.getData();
    }

    public int hashCode() {
        return this.clock.getZone().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        return Intrinsics.areEqual((Object)this.clock.getZone(), (object = other instanceof ZonedSystemClockProvider ? (ZonedSystemClockProvider)other : null) != null && (object = ((ZonedSystemClockProvider)object).clock) != null ? ((Clock)object).getZone() : null);
    }

    @NotNull
    public String toString() {
        String string = this.clock.getZone().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clock.zone.toString()");
        return string;
    }
}

