/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.kotlin.baker.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.kotlin.baker.Context;
import tech.harmonysoft.oss.kotlin.baker.KotlinCreator;
import tech.harmonysoft.oss.kotlin.baker.impl.Result;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J<\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J4\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u0006\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u00062\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0006H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Ltech/harmonysoft/oss/kotlin/baker/impl/ParameterValueRetriever;", "", "parameter", "Lkotlin/reflect/KParameter;", "(Lkotlin/reflect/KParameter;)V", "error", "", "getError", "()Ljava/lang/String;", "name", "getParameter", "()Lkotlin/reflect/KParameter;", "retrieve", "Ltech/harmonysoft/oss/kotlin/baker/impl/Result;", "prefix", "creator", "Ltech/harmonysoft/oss/kotlin/baker/KotlinCreator;", "context", "Ltech/harmonysoft/oss/kotlin/baker/Context;", "retrieveCollection", "collectionClass", "Lkotlin/reflect/KClass;", "propertyName", "retrieveMap", "retrieveSimpleValue", "klass", "toString", "kotlin-baker"})
public final class ParameterValueRetriever {
    private final String name;
    @Nullable
    private final String error;
    @NotNull
    private final KParameter parameter;

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final Result<Object, String> retrieve(@NotNull String prefix, @NotNull KotlinCreator creator, @NotNull Context context) {
        Result<Object, String> result;
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)creator, (String)"creator");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (this.name == null) {
            throw (Throwable)new IllegalStateException("Can't retrieve a value of parameter " + this.parameter + " for path '" + prefix + "' " + "- the parameter doesn't expose its name");
        }
        KClassifier kClassifier = this.parameter.getType().getClassifier();
        if (!(kClassifier instanceof KClass)) {
            kClassifier = null;
        }
        KClass kClass = (KClass)kClassifier;
        if (kClass == null) {
            return Result.Companion.failure("type '" + this.parameter.getType() + "' for argument '" + this.name + "' for path '" + prefix + "' " + "is not a " + Reflection.getOrCreateKotlinClass(KClass.class).getQualifiedName());
        }
        KClass klass = kClass;
        String propertyName = context.getRegularPropertyName(prefix, this.name);
        if (context.isSimpleType(klass)) {
            return this.retrieveSimpleValue(propertyName, klass, context);
        }
        if (context.isCollection(klass)) {
            return this.retrieveCollection(klass, propertyName, creator, context);
        }
        if (KClasses.isSuperclassOf((KClass)Reflection.getOrCreateKotlinClass(Map.class), (KClass)klass)) {
            return this.retrieveMap(propertyName, creator, context);
        }
        try {
            result = Result.Companion.success(creator.create(propertyName, this.parameter.getType(), context));
        }
        catch (Exception e) {
            if (!this.parameter.isOptional()) {
                throw (Throwable)e;
            }
            result = null;
        }
        return result;
    }

    private final Result<Object, String> retrieveSimpleValue(String propertyName, KClass<?> klass, Context context) {
        Object rawValue = context.getPropertyValue(propertyName);
        return rawValue == null ? (this.parameter.getType().isMarkedNullable() ? Result.Companion.success(null) : (this.parameter.isOptional() ? null : Result.Companion.failure("no value for non-nullable parameter '" + propertyName + '\''))) : Result.Companion.success(context.convertIfNecessary(rawValue, klass));
    }

    private final Result<Object, String> retrieveCollection(KClass<?> collectionClass, String propertyName, KotlinCreator creator, Context context) {
        Object invalidValue = context.getPropertyValue(propertyName);
        if (invalidValue != null) {
            throw (Throwable)new IllegalArgumentException("Expected to find collection data as a parameter '" + this.parameter.getName() + "' of type " + this.parameter.getType() + ' ' + "under base property '" + propertyName + "' but found a simple value '" + invalidValue + "' instead");
        }
        List typeArguments = this.parameter.getType().getArguments();
        if (typeArguments.size() != 1) {
            throw (Throwable)new IllegalArgumentException("Failed retrieving value of a '" + this.parameter.getType() + "' property for path '" + propertyName + "' - expected " + "to find a single type argument, but found " + typeArguments.size() + ": " + typeArguments);
        }
        KType kType = ((KTypeProjection)typeArguments.get(0)).getType();
        if (kType == null) {
            return Result.Companion.failure("can't derive collection type for property '" + propertyName + "' of type " + this.parameter.getType());
        }
        KType type = kType;
        KClassifier kClassifier = type.getClassifier();
        if (!(kClassifier instanceof KClass)) {
            kClassifier = null;
        }
        KClass kClass = (KClass)kClassifier;
        if (kClass == null) {
            return Result.Companion.failure("can't derive type parameter class for property '" + propertyName + "' of type " + this.parameter.getType());
        }
        KClass typeClass = kClass;
        int i = 0;
        Collection<Object> parameters = context.createCollection(collectionClass);
        while (true) {
            String collectionElementPropertyName = context.getCollectionElementPropertyName(propertyName, i);
            ++i;
            if (context.isSimpleType(typeClass)) {
                Object rawValue;
                if (context.getPropertyValue(collectionElementPropertyName) == null) {
                    break;
                }
                parameters.add(context.convertIfNecessary(rawValue, typeClass));
                continue;
            }
            if (context.isCollection(typeClass)) {
                Result<Object, String> r = this.retrieveCollection(typeClass, collectionElementPropertyName, creator, context);
                if (r != null && r.getSuccess()) {
                    parameters.add(r);
                    continue;
                }
                Result<Object, String> result = r;
                return Result.Companion.failure("can't create a collection for property " + collectionElementPropertyName + " - " + (result != null ? result.getFailureValue() : null));
            }
            try {
                context.withTolerateEmptyCollection(false, (Function0)new Function0<Boolean>(creator, collectionElementPropertyName, type, context, parameters){
                    final /* synthetic */ KotlinCreator $creator;
                    final /* synthetic */ String $collectionElementPropertyName;
                    final /* synthetic */ KType $type;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ Collection $parameters;

                    public final boolean invoke() {
                        T element = this.$creator.create(this.$collectionElementPropertyName, this.$type, this.$context);
                        return this.$parameters.add(element);
                    }
                    {
                        this.$creator = kotlinCreator;
                        this.$collectionElementPropertyName = string;
                        this.$type = kType;
                        this.$context = context;
                        this.$parameters = collection;
                        super(0);
                    }
                });
            }
            catch (Exception e) {
                break;
            }
        }
        return parameters.isEmpty() ? (this.parameter.getType().isMarkedNullable() ? Result.Companion.success(null) : (this.parameter.isOptional() ? null : Result.Companion.failure("Can't instantiate collection property '" + this.parameter.getName() + "' for type " + this.parameter.getType() + " - no data is defined for it and the property is " + "mandatory (non-nullable and doesn't have default value). Tried to find the " + "value using key '" + context.getCollectionElementPropertyName(propertyName, 0) + '\''))) : Result.Companion.success(parameters);
    }

    private final Result<Object, String> retrieveMap(String propertyName, KotlinCreator creator, Context context) {
        Object invalidValue = context.getPropertyValue(propertyName);
        if (invalidValue != null) {
            throw (Throwable)new IllegalArgumentException("Expected to find map data as a parameter '" + this.parameter.getName() + "' of type " + this.parameter.getType() + ' ' + "under base property '" + propertyName + "' but found a simple value '" + invalidValue + "' instead");
        }
        KType kType = ((KTypeProjection)this.parameter.getType().getArguments().get(0)).getType();
        if (kType == null) {
            throw (Throwable)new IllegalArgumentException("Failed instantiating a Map property '" + propertyName + "' - no key type info is available for " + this.parameter);
        }
        KType keyType = kType;
        KClassifier kClassifier = keyType.getClassifier();
        if (!(kClassifier instanceof KClass)) {
            kClassifier = null;
        }
        KClass kClass = (KClass)kClassifier;
        if (kClass == null) {
            throw (Throwable)new IllegalArgumentException("Failed instantiating a Map property '" + propertyName + "' - can't derive key class for " + this.parameter);
        }
        KClass keyClass = kClass;
        KType kType2 = ((KTypeProjection)this.parameter.getType().getArguments().get(1)).getType();
        if (kType2 == null) {
            throw (Throwable)new IllegalArgumentException("Failed instantiating a Map property '" + propertyName + "' - no value type info is available for " + this.parameter);
        }
        KType valueType = kType2;
        KClassifier kClassifier2 = valueType.getClassifier();
        if (!(kClassifier2 instanceof KClass)) {
            kClassifier2 = null;
        }
        KClass kClass2 = (KClass)kClassifier2;
        if (kClass2 == null) {
            throw (Throwable)new IllegalArgumentException("Failed instantiating a Map property '" + propertyName + "' - can't derive value class for " + this.parameter);
        }
        KClass valueClass = kClass2;
        Map<Object, Object> map = context.createMap();
        for (String key : context.getMapKeys(propertyName, keyType)) {
            String valuePropertyName = context.getMapValuePropertyName(propertyName, key);
            if (context.isSimpleType(valueClass)) {
                Object rawValue = context.getPropertyValue(valuePropertyName);
                if (rawValue == null) continue;
                Object convertedValue = context.convertIfNecessary(rawValue, valueClass);
                map.put(context.convertIfNecessary(key, keyClass), convertedValue);
                continue;
            }
            try {
                Object value = creator.create(valuePropertyName, valueType, context);
                map.put(context.convertIfNecessary(key, keyClass), value);
            }
            catch (Exception exception) {}
        }
        return Result.Companion.success(map);
    }

    @NotNull
    public String toString() {
        return this.parameter + " value retriever";
    }

    @NotNull
    public final KParameter getParameter() {
        return this.parameter;
    }

    public ParameterValueRetriever(@NotNull KParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        this.parameter = parameter;
        this.name = this.parameter.getName();
        this.error = this.name == null ? "can't extract name for parameter #" + this.parameter.getIndex() : null;
    }
}

