/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.glfw.datatype;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.pointer;

public record GLFWallocator(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.ADDRESS.withName("allocate"), ValueLayout.ADDRESS.withName("reallocate"), ValueLayout.ADDRESS.withName("deallocate"), ValueLayout.ADDRESS.withName("user")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$allocate = MemoryLayout.PathElement.groupElement("allocate");
    public static final MemoryLayout.PathElement PATH$reallocate = MemoryLayout.PathElement.groupElement("reallocate");
    public static final MemoryLayout.PathElement PATH$deallocate = MemoryLayout.PathElement.groupElement("deallocate");
    public static final MemoryLayout.PathElement PATH$user = MemoryLayout.PathElement.groupElement("user");
    public static final AddressLayout LAYOUT$allocate = (AddressLayout)LAYOUT.select(PATH$allocate);
    public static final AddressLayout LAYOUT$reallocate = (AddressLayout)LAYOUT.select(PATH$reallocate);
    public static final AddressLayout LAYOUT$deallocate = (AddressLayout)LAYOUT.select(PATH$deallocate);
    public static final AddressLayout LAYOUT$user = (AddressLayout)LAYOUT.select(PATH$user);
    public static final long OFFSET$allocate = LAYOUT.byteOffset(PATH$allocate);
    public static final long OFFSET$reallocate = LAYOUT.byteOffset(PATH$reallocate);
    public static final long OFFSET$deallocate = LAYOUT.byteOffset(PATH$deallocate);
    public static final long OFFSET$user = LAYOUT.byteOffset(PATH$user);
    public static final long SIZE$allocate = LAYOUT$allocate.byteSize();
    public static final long SIZE$reallocate = LAYOUT$reallocate.byteSize();
    public static final long SIZE$deallocate = LAYOUT$deallocate.byteSize();
    public static final long SIZE$user = LAYOUT$user.byteSize();

    @pointer(comment="GLFWallocatefun")
    public MemorySegment allocate() {
        return this.segment.get(LAYOUT$allocate, OFFSET$allocate);
    }

    public void allocate(@pointer(comment="GLFWallocatefun") MemorySegment value) {
        this.segment.set(LAYOUT$allocate, OFFSET$allocate, value);
    }

    public void allocate(IPointer pointer2) {
        this.allocate(pointer2.segment());
    }

    @pointer(comment="GLFWreallocatefun")
    public MemorySegment reallocate() {
        return this.segment.get(LAYOUT$reallocate, OFFSET$reallocate);
    }

    public void reallocate(@pointer(comment="GLFWreallocatefun") MemorySegment value) {
        this.segment.set(LAYOUT$reallocate, OFFSET$reallocate, value);
    }

    public void reallocate(IPointer pointer2) {
        this.reallocate(pointer2.segment());
    }

    @pointer(comment="GLFWdeallocatefun")
    public MemorySegment deallocate() {
        return this.segment.get(LAYOUT$deallocate, OFFSET$deallocate);
    }

    public void deallocate(@pointer(comment="GLFWdeallocatefun") MemorySegment value) {
        this.segment.set(LAYOUT$deallocate, OFFSET$deallocate, value);
    }

    public void deallocate(IPointer pointer2) {
        this.deallocate(pointer2.segment());
    }

    @pointer(comment="void*")
    public MemorySegment user() {
        return this.segment.get(LAYOUT$user, OFFSET$user);
    }

    public void user(@pointer(comment="void*") MemorySegment value) {
        this.segment.set(LAYOUT$user, OFFSET$user, value);
    }

    public void user(IPointer pointer2) {
        this.user(pointer2.segment());
    }

    public static GLFWallocator allocate(Arena arena) {
        return new GLFWallocator(arena.allocate(LAYOUT));
    }

    public static GLFWallocator[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        GLFWallocator[] ret = new GLFWallocator[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new GLFWallocator(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static GLFWallocator clone(Arena arena, GLFWallocator src) {
        GLFWallocator ret = GLFWallocator.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static GLFWallocator[] clone(Arena arena, GLFWallocator[] src) {
        GLFWallocator[] ret = GLFWallocator.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

