/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.glfw.datatype;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.NativeLayout;
import tech.icey.panama.annotation.nullable;
import tech.icey.panama.annotation.pointer;
import tech.icey.panama.annotation.unsigned;
import tech.icey.panama.buffer.ByteBuffer;

public record GLFWimage(MemorySegment segment) implements IPointer
{
    public static final MemoryLayout LAYOUT = NativeLayout.structLayout((MemoryLayout[])new MemoryLayout[]{ValueLayout.JAVA_INT.withName("width"), ValueLayout.JAVA_INT.withName("height"), ValueLayout.ADDRESS.withTargetLayout(ValueLayout.JAVA_BYTE).withName("pixels")});
    public static final long SIZE = LAYOUT.byteSize();
    public static final MemoryLayout.PathElement PATH$width = MemoryLayout.PathElement.groupElement("width");
    public static final MemoryLayout.PathElement PATH$height = MemoryLayout.PathElement.groupElement("height");
    public static final MemoryLayout.PathElement PATH$pixels = MemoryLayout.PathElement.groupElement("pixels");
    public static final ValueLayout.OfInt LAYOUT$width = (ValueLayout.OfInt)LAYOUT.select(PATH$width);
    public static final ValueLayout.OfInt LAYOUT$height = (ValueLayout.OfInt)LAYOUT.select(PATH$height);
    public static final AddressLayout LAYOUT$pixels = (AddressLayout)LAYOUT.select(PATH$pixels);
    public static final long OFFSET$width = LAYOUT.byteOffset(PATH$width);
    public static final long OFFSET$height = LAYOUT.byteOffset(PATH$height);
    public static final long OFFSET$pixels = LAYOUT.byteOffset(PATH$pixels);
    public static final long SIZE$width = LAYOUT$width.byteSize();
    public static final long SIZE$height = LAYOUT$height.byteSize();
    public static final long SIZE$pixels = LAYOUT$pixels.byteSize();

    public int width() {
        return this.segment.get(LAYOUT$width, OFFSET$width);
    }

    public void width(int value) {
        this.segment.set(LAYOUT$width, OFFSET$width, value);
    }

    public int height() {
        return this.segment.get(LAYOUT$height, OFFSET$height);
    }

    public void height(int value) {
        this.segment.set(LAYOUT$height, OFFSET$height, value);
    }

    @pointer(comment="byte*")
    public MemorySegment pixelsRaw() {
        return this.segment.get(LAYOUT$pixels, OFFSET$pixels);
    }

    public void pixelsRaw(@pointer(comment="byte*") MemorySegment value) {
        this.segment.set(LAYOUT$pixels, OFFSET$pixels, value);
    }

    @nullable
    @unsigned
    public ByteBuffer pixels() {
        MemorySegment s = this.pixelsRaw();
        if (s.address() == 0L) {
            return null;
        }
        return new ByteBuffer(s);
    }

    public void pixels(@nullable @unsigned ByteBuffer value) {
        MemorySegment s = value == null ? MemorySegment.NULL : value.segment();
        this.pixelsRaw(s);
    }

    public static GLFWimage allocate(Arena arena) {
        return new GLFWimage(arena.allocate(LAYOUT));
    }

    public static GLFWimage[] allocate(Arena arena, int count) {
        MemorySegment segment = arena.allocate(LAYOUT, count);
        GLFWimage[] ret = new GLFWimage[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = new GLFWimage(segment.asSlice((long)i * SIZE, SIZE));
        }
        return ret;
    }

    public static GLFWimage clone(Arena arena, GLFWimage src) {
        GLFWimage ret = GLFWimage.allocate(arena);
        ret.segment.copyFrom(src.segment);
        return ret;
    }

    public static GLFWimage[] clone(Arena arena, GLFWimage[] src) {
        GLFWimage[] ret = GLFWimage.allocate(arena, src.length);
        for (int i = 0; i < src.length; ++i) {
            ret[i].segment.copyFrom(src[i].segment);
        }
        return ret;
    }
}

