/*
 * Decompiled with CFR 0.152.
 */
package tech.icey.glfw.handle;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import tech.icey.panama.IPointer;
import tech.icey.panama.annotation.unsafe;

public record GLFWcursor(MemorySegment segment) implements IPointer
{

    public record Buffer(MemorySegment segment) {
        public long size() {
            return this.segment.byteSize() / ValueLayout.ADDRESS.byteSize();
        }

        public GLFWcursor read() {
            return new GLFWcursor(this.readRaw());
        }

        public GLFWcursor read(long index) {
            return new GLFWcursor(this.readRaw(index));
        }

        public MemorySegment readRaw() {
            return this.segment.get(ValueLayout.ADDRESS, 0L);
        }

        public MemorySegment readRaw(long index) {
            return this.segment.get(ValueLayout.ADDRESS, index * ValueLayout.ADDRESS.byteSize());
        }

        public GLFWcursor[] readAll() {
            GLFWcursor[] result = new GLFWcursor[(int)this.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.read(i);
            }
            return result;
        }

        public void write(GLFWcursor value) {
            this.writeRaw(value.segment());
        }

        public void write(long index, GLFWcursor value) {
            this.writeRaw(index, value.segment());
        }

        private void writeRaw(MemorySegment value) {
            this.segment.set(ValueLayout.ADDRESS, 0L, value);
        }

        private void writeRaw(long index, MemorySegment value) {
            this.segment.set(ValueLayout.ADDRESS, index * ValueLayout.ADDRESS.byteSize(), value);
        }

        public Buffer offset(long offset) {
            return new Buffer(this.segment.asSlice(offset * ValueLayout.ADDRESS.byteSize()));
        }

        @unsafe
        public Buffer reinterpret(long newSize) {
            return new Buffer(this.segment.reinterpret(newSize * ValueLayout.ADDRESS.byteSize()));
        }

        public static Buffer allocate(Arena arena) {
            return new Buffer(arena.allocate(ValueLayout.ADDRESS));
        }

        public static Buffer allocate(Arena arena, long size) {
            return new Buffer(arena.allocate(ValueLayout.ADDRESS, size));
        }
    }
}

