/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.engine.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.NamedParameterSpec;
import java.security.spec.PSSParameterSpec;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.alert.ErrorAlert;
import net.luminis.tls.alert.HandshakeFailureAlert;
import net.luminis.tls.alert.InternalErrorAlert;
import net.luminis.tls.engine.TlsEngine;
import net.luminis.tls.engine.impl.TlsState;
import net.luminis.tls.env.AlgorithmMapping;
import net.luminis.tls.env.PlatformMapping;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.extension.UnknownExtension;

public abstract class TlsEngineImpl
implements TlsEngine {
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    protected TlsState state;
    protected AlgorithmMapping algorithmMapping = PlatformMapping.algorithmMapping();

    public abstract TlsConstants.CipherSuite getSelectedCipher();

    public static int hashLength(TlsConstants.CipherSuite cipher) {
        switch (cipher) {
            case TLS_AES_128_GCM_SHA256: {
                return 32;
            }
            case TLS_AES_256_GCM_SHA384: {
                return 48;
            }
            case TLS_CHACHA20_POLY1305_SHA256: {
                return 32;
            }
            case TLS_AES_128_CCM_SHA256: {
                return 32;
            }
            case TLS_AES_128_CCM_8_SHA256: {
                return 32;
            }
        }
        throw new RuntimeException();
    }

    public static int keyLength(TlsConstants.CipherSuite cipher) {
        switch (cipher) {
            case TLS_AES_128_GCM_SHA256: {
                return 16;
            }
            case TLS_AES_256_GCM_SHA384: {
                return 32;
            }
            case TLS_CHACHA20_POLY1305_SHA256: {
                return 32;
            }
            case TLS_AES_128_CCM_SHA256: {
                return 16;
            }
            case TLS_AES_128_CCM_8_SHA256: {
                return 16;
            }
        }
        throw new RuntimeException();
    }

    protected void generateKeys(TlsConstants.NamedGroup namedGroup) {
        try {
            KeyPairGenerator keyPairGenerator;
            if (namedGroup == TlsConstants.NamedGroup.secp256r1 || namedGroup == TlsConstants.NamedGroup.secp384r1 || namedGroup == TlsConstants.NamedGroup.secp521r1) {
                keyPairGenerator = KeyPairGenerator.getInstance("EC");
                keyPairGenerator.initialize(new ECGenParameterSpec(namedGroup.toString()));
            } else if (namedGroup == TlsConstants.NamedGroup.x25519 || namedGroup == TlsConstants.NamedGroup.x448) {
                keyPairGenerator = KeyPairGenerator.getInstance("XDH");
                NamedParameterSpec paramSpec = new NamedParameterSpec(namedGroup.toString().toUpperCase());
                keyPairGenerator.initialize(paramSpec);
            } else {
                throw new RuntimeException("unsupported group " + namedGroup);
            }
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            this.privateKey = keyPair.getPrivate();
            this.publicKey = keyPair.getPublic();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("missing key pair generator algorithm EC");
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException();
        }
    }

    protected byte[] computeSignature(byte[] content, PrivateKey certificatePrivateKey, TlsConstants.SignatureScheme signatureScheme, boolean client) throws ErrorAlert {
        ByteArrayOutputStream signatureInput = new ByteArrayOutputStream();
        try {
            signatureInput.write(new String(new byte[]{32}).repeat(64).getBytes(StandardCharsets.US_ASCII));
            String contextString = "TLS 1.3, " + (client ? "client" : "server") + " CertificateVerify";
            signatureInput.write(contextString.getBytes(StandardCharsets.US_ASCII));
            signatureInput.write(0);
            signatureInput.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        try {
            Signature signatureAlgorithm = this.getSignatureAlgorithm(signatureScheme);
            signatureAlgorithm.initSign(certificatePrivateKey);
            signatureAlgorithm.update(signatureInput.toByteArray());
            byte[] digitalSignature = signatureAlgorithm.sign();
            return digitalSignature;
        }
        catch (SignatureException e) {
            throw new RuntimeException();
        }
        catch (InvalidKeyException e) {
            throw new InternalErrorAlert("invalid private key");
        }
    }

    protected byte[] computeFinishedVerifyData(byte[] transcriptHash, byte[] baseKey) {
        short hashLength = this.state.getHashLength();
        byte[] finishedKey = this.state.hkdfExpandLabel(baseKey, "finished", "", hashLength);
        String macAlgorithmName = "HmacSHA" + hashLength * 8;
        SecretKeySpec hmacKey = new SecretKeySpec(finishedKey, macAlgorithmName);
        try {
            Mac hmacAlgorithm = Mac.getInstance(macAlgorithmName);
            hmacAlgorithm.init(hmacKey);
            hmacAlgorithm.update(transcriptHash);
            byte[] hmac = hmacAlgorithm.doFinal();
            return hmac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing " + macAlgorithmName + " support");
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException();
        }
    }

    protected Signature getSignatureAlgorithm(TlsConstants.SignatureScheme signatureScheme) throws HandshakeFailureAlert {
        Signature signatureAlgorithm = null;
        if (signatureScheme.equals((Object)TlsConstants.SignatureScheme.rsa_pss_rsae_sha256)) {
            try {
                signatureAlgorithm = Signature.getInstance(this.algorithmMapping.get("RSASSA-PSS"));
                signatureAlgorithm.setParameter(new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Missing RSASSA-PSS support");
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException(e);
            }
        } else if (signatureScheme.equals((Object)TlsConstants.SignatureScheme.rsa_pss_rsae_sha384)) {
            try {
                signatureAlgorithm = Signature.getInstance(this.algorithmMapping.get("RSASSA-PSS"));
                signatureAlgorithm.setParameter(new PSSParameterSpec("SHA-384", "MGF1", new MGF1ParameterSpec("SHA-384"), 48, 1));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Missing RSASSA-PSS support");
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException(e);
            }
        } else if (signatureScheme.equals((Object)TlsConstants.SignatureScheme.rsa_pss_rsae_sha512)) {
            try {
                signatureAlgorithm = Signature.getInstance(this.algorithmMapping.get("RSASSA-PSS"));
                signatureAlgorithm.setParameter(new PSSParameterSpec("SHA-512", "MGF1", new MGF1ParameterSpec("SHA-512"), 64, 1));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Missing RSASSA-PSS support");
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new RuntimeException(e);
            }
        } else if (signatureScheme.equals((Object)TlsConstants.SignatureScheme.ecdsa_secp256r1_sha256)) {
            try {
                signatureAlgorithm = Signature.getInstance("SHA256withECDSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Missing SHA256withECDSA support");
            }
        } else if (signatureScheme.equals((Object)TlsConstants.SignatureScheme.ecdsa_secp384r1_sha384)) {
            try {
                signatureAlgorithm = Signature.getInstance("SHA384withECDSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Missing SHA384withECDSA support");
            }
        } else if (signatureScheme.equals((Object)TlsConstants.SignatureScheme.ecdsa_secp521r1_sha512)) {
            try {
                signatureAlgorithm = Signature.getInstance("SHA512withECDSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Missing SHA512withECDSA support");
            }
        } else {
            throw new HandshakeFailureAlert("Signature algorithm not supported " + signatureScheme);
        }
        return signatureAlgorithm;
    }

    @Override
    public byte[] getClientEarlyTrafficSecret() {
        if (this.state != null) {
            return this.state.getClientEarlyTrafficSecret();
        }
        throw new IllegalStateException("Traffic secret not yet available");
    }

    @Override
    public byte[] getClientHandshakeTrafficSecret() {
        if (this.state != null) {
            return this.state.getClientHandshakeTrafficSecret();
        }
        throw new IllegalStateException("Traffic secret not yet available");
    }

    @Override
    public byte[] getServerHandshakeTrafficSecret() {
        if (this.state != null) {
            return this.state.getServerHandshakeTrafficSecret();
        }
        throw new IllegalStateException("Traffic secret not yet available");
    }

    @Override
    public byte[] getClientApplicationTrafficSecret() {
        if (this.state != null) {
            return this.state.getClientApplicationTrafficSecret();
        }
        throw new IllegalStateException("Traffic secret not yet available");
    }

    @Override
    public byte[] getServerApplicationTrafficSecret() {
        if (this.state != null) {
            return this.state.getServerApplicationTrafficSecret();
        }
        throw new IllegalStateException("Traffic secret not yet available");
    }

    protected boolean recognizedExtension(Extension extension) {
        return !(extension instanceof UnknownExtension);
    }
}

