/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.ext.interchan.auth;

import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mhuang.core.util.ObjectUtil;
import tech.mhuang.core.util.StringUtil;
import tech.mhuang.ext.interchan.core.exception.BusinessException;
import tech.mhuang.ext.interchan.core.local.GlobalHeaderThreadLocal;
import tech.mhuang.ext.interchan.protocol.GlobalHeader;
import tech.mhuang.ext.interchan.protocol.Result;
import tech.mhuang.ext.jwt.admin.JwtFramework;
import tech.mhuang.ext.jwt.admin.bean.Jwt;
import tech.mhuang.ext.spring.start.SpringContextHolder;
import tech.mhuang.ext.spring.util.DataUtil;
import tech.mhuang.ext.spring.util.IpUtil;
import tech.mhuang.ext.spring.webmvc.WebRequestHeader;

public class AuthFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> excludeUrl = new ArrayList<String>();
    private final String AUTH_TYPE = "authType";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            try {
                Jwt.JwtBean jwtBean;
                HttpServletRequest request = (HttpServletRequest)req;
                WebRequestHeader httpRequest = new WebRequestHeader(request);
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                this.logger.info("\u8bf7\u6c42\u7684URL:{},\u8bf7\u6c42\u7c7b\u578b:{}", (Object)request.getRequestURL().toString(), (Object)request.getMethod());
                GlobalHeader globalHeader = new GlobalHeader();
                globalHeader.setIp(IpUtil.getIp((HttpServletRequest)request));
                globalHeader.setSource(request.getHeader("source"));
                JwtFramework jwtFramework = (JwtFramework)SpringContextHolder.getBean(JwtFramework.class);
                String authType = request.getHeader("authType");
                String auth = null;
                String headerName = null;
                if (StringUtil.isNotEmpty((CharSequence)authType) && ObjectUtil.isNotEmpty((Object)(jwtBean = (Jwt.JwtBean)jwtFramework.getJwt().getBeanMap().get(authType)))) {
                    auth = request.getHeader(jwtBean.getType());
                    headerName = jwtBean.getHeaderName();
                }
                if (StringUtil.isBlank(auth)) {
                    GlobalHeaderThreadLocal.set((GlobalHeader)globalHeader);
                    httpRequest.putHeader("global_header", JSON.toJSONString((Object)globalHeader));
                } else if (StringUtil.indexOf(auth, (CharSequence)"Basic") == 0) {
                    GlobalHeaderThreadLocal.set((GlobalHeader)globalHeader);
                    httpRequest.putHeader("global_header", JSON.toJSONString((Object)globalHeader));
                } else if (StringUtil.length(auth) > headerName.length()) {
                    this.logger.debug("\u5f53\u524d\u8c03\u7528\u7684token:{}", (Object)auth);
                    String token = StringUtil.substringAfter((String)auth, (String)headerName);
                    try {
                        Map claimMap = jwtFramework.getProducer(authType).parse(token);
                        if (claimMap == null) {
                            throw new BusinessException(406, "Token\u65e0\u6548");
                        }
                        globalHeader.setToken(token.trim());
                        globalHeader.setType((String)claimMap.get("type"));
                        globalHeader.setCompanyId((String)claimMap.get("companyId"));
                        globalHeader.setUserId((String)claimMap.get("userId"));
                        GlobalHeaderThreadLocal.set((GlobalHeader)globalHeader);
                        httpRequest.putHeader("global_header", JSON.toJSONString((Object)globalHeader));
                    }
                    catch (ExpiredJwtException e) {
                        this.logger.error("token\u5df2\u8fc7\u671f:{}", (Throwable)e);
                        throw new BusinessException(401, "Token\u5df2\u7ecf\u8fc7\u671f");
                    }
                    catch (Exception e) {
                        this.logger.error("token\u5f02\u5e38:{}", (Throwable)e);
                        throw new BusinessException(406, "Token\u65e0\u6548");
                    }
                } else {
                    this.logger.error("token:{}\u65e0\u6548\uff0c\u957f\u5ea6\u4e0d\u4e00\u81f4", (Object)auth);
                    throw new BusinessException(406, "Token\u65e0\u6548");
                }
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            catch (BusinessException e) {
                response.setContentType("text/json; charset=utf-8");
                Result result = (Result)DataUtil.copyTo((Object)((Object)e), Result.class);
                response.getWriter().write(JSON.toJSONString((Object)result));
            }
        }
    }

    public void destroy() {
        GlobalHeaderThreadLocal.remove();
    }

    public void setExcludeUrl(List<String> excludeUrl) {
        this.excludeUrl = excludeUrl;
    }

    public List<String> getExcludeUrl() {
        return this.excludeUrl;
    }
}

