/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.ext.interchan.auth.interceptor;

import java.util.List;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import tech.mhuang.core.util.CollectionUtil;
import tech.mhuang.ext.interchan.auth.interceptor.InterceptorBean;
import tech.mhuang.ext.interchan.auth.interceptor.OpAuthInterceptor;

public class InterInterceptor
implements WebMvcConfigurer {
    private InterceptorBean bean;

    public void addInterceptors(InterceptorRegistry registry) {
        List<String> includeUrls = this.bean.getIncludeUrls();
        List<String> excludeUrls = this.bean.getExcludeUrls();
        OpAuthInterceptor opAuthInterceptor = new OpAuthInterceptor();
        opAuthInterceptor.setRedisDataBase(this.bean.getRedisDatabase());
        opAuthInterceptor.setCheckUrl(this.bean.isCheckUrl());
        InterceptorRegistration interceptorRegistration = registry.addInterceptor((HandlerInterceptor)opAuthInterceptor);
        if (CollectionUtil.isNotEmpty(excludeUrls)) {
            interceptorRegistration.excludePathPatterns(excludeUrls.toArray(new String[excludeUrls.size()]));
        }
        if (CollectionUtil.isNotEmpty(includeUrls)) {
            interceptorRegistration.addPathPatterns(includeUrls.toArray(new String[includeUrls.size()]));
        }
    }

    public void setBean(InterceptorBean bean) {
        this.bean = bean;
    }

    public InterceptorBean getBean() {
        return this.bean;
    }
}

