/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.ext.interchan.auth.interceptor;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import tech.mhuang.core.util.CollectionUtil;
import tech.mhuang.core.util.StringUtil;
import tech.mhuang.ext.interchan.core.exception.BusinessException;
import tech.mhuang.ext.interchan.protocol.GlobalHeader;
import tech.mhuang.ext.interchan.protocol.Result;
import tech.mhuang.ext.interchan.protocol.auth.AuthExcludeUrl;
import tech.mhuang.ext.interchan.protocol.auth.AuthUrl;
import tech.mhuang.ext.interchan.redis.commands.IRedisExtCommands;
import tech.mhuang.ext.spring.start.SpringContextHolder;

public class OpAuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OpAuthInterceptor.class);
    private int redisDataBase;
    private boolean checkUrl;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        block6: {
            if (!(handler instanceof ResourceHttpRequestHandler)) {
                log.debug("\u8bf7\u6c42\u7684URL:{},\u8bf7\u6c42\u7c7b\u578b:{}", (Object)request.getRequestURL().toString(), (Object)request.getMethod());
                try {
                    boolean flag;
                    if (!this.checkUrl || (flag = this.checkUrlIsNotLogin(OpAuthInterceptor.getUri(request), request))) break block6;
                    String headJson = request.getHeader("global_header");
                    if (StringUtil.isNotBlank((CharSequence)headJson)) {
                        GlobalHeader globalHeader = (GlobalHeader)JSON.parseObject((String)headJson, GlobalHeader.class);
                        if (StringUtil.isNotBlank((CharSequence)globalHeader.getToken()) ? !(flag = this.checkUrlPower(globalHeader.getUserId(), request)) : !(flag = this.checkUrlIsNotLogin(OpAuthInterceptor.getUri(request), request))) {
                            throw new BusinessException(500, "\u60a8\u6ca1\u6709\u6743\u9650\u8bbf\u95ee!");
                        }
                        break block6;
                    }
                    throw new BusinessException(500, "\u60a8\u6ca1\u6709\u6743\u9650\u8bbf\u95ee!");
                }
                catch (BusinessException e) {
                    log.error("\u68c0\u67e5\u6743\u9650\u5f02\u5e38{}", (Throwable)e);
                    this.writeJson(e.getCode(), e.getMessage(), response);
                    return false;
                }
                catch (Exception e) {
                    this.writeJson(500, "\u6388\u6743\u5931\u8d25\uff01", response);
                    log.error("\u68c0\u67e5\u6743\u9650\u5f02\u5e38{}", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkUrlIsNotLogin(String uri, HttpServletRequest httpRequest) {
        IRedisExtCommands repository = (IRedisExtCommands)SpringContextHolder.getBean(IRedisExtCommands.class);
        boolean filterFlag = false;
        log.debug("\u5f00\u59cb\u68c0\u67e5\u8bf7\u6c42\u7684URI:{}\u662f\u5426\u4e0d\u9700\u8981\u767b\u5f55", (Object)uri);
        if (repository != null) {
            String cacheExcludeKey = "not_login_vist_url";
            filterFlag = this.isFilterFlag(uri, repository, filterFlag, cacheExcludeKey);
        }
        return filterFlag;
    }

    private boolean isFilterFlag(String uri, IRedisExtCommands repository, boolean filterFlag, String cacheExcludeKey) {
        List vos = repository.hgetList(this.redisDataBase, "auth_exclude", cacheExcludeKey, AuthExcludeUrl.class);
        if (CollectionUtil.isNotEmpty((Collection)vos)) {
            filterFlag = vos.parallelStream().filter(vo -> StringUtil.isNotBlank((CharSequence)vo.getUrl()) && (uri.startsWith(vo.getUrl()) || "*".equals(vo.getUrl()))).findFirst().isPresent();
        }
        return filterFlag;
    }

    private void writeJson(int code, String message, HttpServletResponse response) {
        try {
            Result result = new Result();
            result.setCode(code);
            result.setMessage(message);
            response.setContentType("text/html;charset=utf-8");
            response.setStatus(403);
            response.getWriter().write(JSON.toJSONString((Object)result));
            response.getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkUrlPower(String userId, HttpServletRequest httpRequest) {
        String cacheKey;
        AuthUrl authUrl;
        String cacheExcludeKey;
        String url = OpAuthInterceptor.getUri(httpRequest);
        log.debug("\u5f00\u59cb\u68c0\u67e5\u8bf7\u6c42\u7684URI:{}\u662f\u5426\u5177\u6709\u8bbf\u95ee\u6743\u9650", (Object)url);
        IRedisExtCommands repository = (IRedisExtCommands)SpringContextHolder.getBean(IRedisExtCommands.class);
        boolean filterFlag = false;
        if (repository != null && !(filterFlag = this.isFilterFlag(url, repository, filterFlag, cacheExcludeKey = "exclude_vist_url")) && (authUrl = (AuthUrl)repository.hget(this.redisDataBase, cacheKey = "user_vist_url", userId.concat("-").concat(url), AuthUrl.class)) != null) {
            filterFlag = true;
        }
        return filterFlag;
    }

    public static String getServletPath(HttpServletRequest request) {
        int endIndex;
        int pos;
        String servletPath = request.getServletPath();
        String requestUri = request.getRequestURI();
        if (requestUri != null && servletPath != null && !requestUri.endsWith(servletPath) && (pos = requestUri.indexOf(servletPath)) > -1) {
            servletPath = requestUri.substring(requestUri.indexOf(servletPath));
        }
        if (null != servletPath && !"".equals(servletPath)) {
            return servletPath;
        }
        int startIndex = request.getContextPath().equals("") ? 0 : request.getContextPath().length();
        int n = endIndex = request.getPathInfo() == null ? requestUri.length() : requestUri.lastIndexOf(request.getPathInfo());
        if (startIndex > endIndex) {
            endIndex = startIndex;
        }
        return requestUri.substring(startIndex, endIndex);
    }

    public static String getUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            return uri;
        }
        uri = OpAuthInterceptor.getServletPath(request);
        if (uri != null && !"".equals(uri)) {
            return uri;
        }
        uri = request.getRequestURI();
        return uri.substring(request.getContextPath().length());
    }

    public void setRedisDataBase(int redisDataBase) {
        this.redisDataBase = redisDataBase;
    }

    public void setCheckUrl(boolean checkUrl) {
        this.checkUrl = checkUrl;
    }
}

