/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Arrays;
import tagbio.umap.Matrix;

public class DefaultMatrix
extends Matrix {
    private final float[][] mData;

    DefaultMatrix(float[][] matrix) {
        super(matrix.length, matrix[0].length);
        this.mData = matrix;
    }

    DefaultMatrix(int rows, int cols) {
        this(new float[rows][cols]);
    }

    @Override
    float get(int row, int col) {
        return this.mData[row][col];
    }

    @Override
    void set(int row, int col, float val) {
        this.mData[row][col] = val;
    }

    @Override
    boolean isFinite() {
        float[][] fArray = this.mData;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] row;
            for (float v : row = fArray[i]) {
                if (Float.isFinite(v)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    Matrix copy() {
        float[][] copy = new float[this.mData.length][];
        for (int k = 0; k < copy.length; ++k) {
            copy[k] = Arrays.copyOf(this.mData[k], this.mData[k].length);
        }
        return new DefaultMatrix(copy);
    }

    @Override
    float[][] toArray() {
        return this.mData;
    }

    @Override
    float[] row(int row) {
        return this.mData[row];
    }

    @Override
    Matrix eliminateZeros() {
        return this;
    }
}

