/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Arrays;
import java.util.Random;

class Heap {
    private final int[][] mIndices;
    private final float[][] mWeights;
    private final boolean[][] mIsNew;

    private Heap(int[][] indices, float[][] weights) {
        this.mIndices = indices;
        this.mWeights = weights;
        this.mIsNew = new boolean[indices.length][indices[0].length];
    }

    Heap(int points, int size) {
        this.mIndices = new int[points][size];
        this.mWeights = new float[points][size];
        this.mIsNew = new boolean[points][size];
        for (Object[] a : this.mIndices) {
            Arrays.fill(a, -1);
        }
        float[][] fArray = this.mWeights;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] a;
            a = fArray[i];
            Arrays.fill((float[])a, Float.POSITIVE_INFINITY);
        }
    }

    int index(int row, int col) {
        return this.mIndices[row][col];
    }

    int[][] indices() {
        return this.mIndices;
    }

    float[][] weights() {
        return this.mWeights;
    }

    boolean isNew(int row, int col) {
        return this.mIsNew[row][col];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean push(int row, float weight, int index, boolean flag) {
        int[] nArray = this.mIndices[row];
        synchronized (nArray) {
            int[] indices = this.mIndices[row];
            float[] weights = this.mWeights[row];
            boolean[] isNew = this.mIsNew[row];
            if (weight >= weights[0]) {
                return false;
            }
            for (int value : indices) {
                if (index != value) continue;
                return false;
            }
            weights[0] = weight;
            indices[0] = index;
            isNew[0] = flag;
            int i = 0;
            while (true) {
                int iSwap;
                int ic1 = 2 * i + 1;
                int ic2 = ic1 + 1;
                if (ic1 >= this.mIndices[0].length) break;
                if (ic2 >= this.mIndices[0].length) {
                    if (!(weights[ic1] > weight)) break;
                    iSwap = ic1;
                } else if (weights[ic1] >= weights[ic2]) {
                    if (!(weight < weights[ic1])) break;
                    iSwap = ic1;
                } else {
                    if (!(weight < weights[ic2])) break;
                    iSwap = ic2;
                }
                weights[i] = weights[iSwap];
                indices[i] = indices[iSwap];
                isNew[i] = isNew[iSwap];
                i = iSwap;
            }
            weights[i] = weight;
            indices[i] = index;
            isNew[i] = flag;
            return true;
        }
    }

    boolean uncheckedHeapPush(int row, float weight, int index, boolean flag) {
        int[] indices = this.mIndices[row];
        float[] weights = this.mWeights[row];
        boolean[] isNew = this.mIsNew[row];
        if (weight >= weights[0]) {
            return false;
        }
        weights[0] = weight;
        indices[0] = index;
        isNew[0] = flag;
        int i = 0;
        while (true) {
            int iSwap;
            int ic1 = 2 * i + 1;
            int ic2 = ic1 + 1;
            if (ic1 >= this.mIndices[0].length) break;
            if (ic2 >= this.mIndices[0].length) {
                if (!(weights[ic1] > weight)) break;
                iSwap = ic1;
            } else if (weights[ic1] >= weights[ic2]) {
                if (!(weight < weights[ic1])) break;
                iSwap = ic1;
            } else {
                if (!(weight < weights[ic2])) break;
                iSwap = ic2;
            }
            weights[i] = weights[iSwap];
            indices[i] = indices[iSwap];
            isNew[i] = isNew[iSwap];
            i = iSwap;
        }
        weights[i] = weight;
        indices[i] = index;
        isNew[i] = flag;
        return true;
    }

    private static void siftdown(float[] heap1, int[] heap2, int length, int elt) {
        int mid = elt;
        while (mid * 2 + 1 < length) {
            int leftChild = mid * 2 + 1;
            int rightChild = leftChild + 1;
            int swap = mid;
            if (heap1[swap] < heap1[leftChild]) {
                swap = leftChild;
            }
            if (rightChild < length && heap1[swap] < heap1[rightChild]) {
                swap = rightChild;
            }
            if (swap == mid) break;
            float t = heap1[swap];
            heap1[swap] = heap1[mid];
            heap1[mid] = t;
            int s = heap2[swap];
            heap2[swap] = heap2[mid];
            heap2[mid] = s;
            mid = swap;
        }
    }

    Heap deheapSort() {
        for (int i = 0; i < this.mIndices.length; ++i) {
            int[] indHeap = this.mIndices[i];
            float[] distHeap = this.mWeights[i];
            for (int j = 0; j < indHeap.length - 1; ++j) {
                int s = indHeap[0];
                indHeap[0] = indHeap[indHeap.length - j - 1];
                indHeap[indHeap.length - j - 1] = s;
                float t = distHeap[0];
                distHeap[0] = distHeap[distHeap.length - j - 1];
                distHeap[distHeap.length - j - 1] = t;
                Heap.siftdown(distHeap, indHeap, distHeap.length - j - 1, 0);
            }
        }
        return new Heap(this.mIndices, this.mWeights);
    }

    int smallestFlagged(int row) {
        int[] ind = this.mIndices[row];
        float[] dist = this.mWeights[row];
        boolean[] flag = this.mIsNew[row];
        float minDist = Float.POSITIVE_INFINITY;
        int resultIndex = -1;
        for (int i = 0; i < ind.length; ++i) {
            if (!flag[i] || !(dist[i] < minDist)) continue;
            minDist = dist[i];
            resultIndex = i;
        }
        if (resultIndex >= 0) {
            flag[resultIndex] = false;
            return ind[resultIndex];
        }
        return -1;
    }

    Heap buildCandidates(int nVertices, int nNeighbors, int maxCandidates, Random random) {
        Heap candidateNeighbors = new Heap(nVertices, maxCandidates);
        for (int i = 0; i < nVertices; ++i) {
            for (int j = 0; j < nNeighbors; ++j) {
                if (this.mIndices[i][j] < 0) continue;
                int idx = this.mIndices[i][j];
                boolean isn = this.mIsNew[i][j];
                float d = random.nextFloat();
                candidateNeighbors.push(i, d, idx, isn);
                candidateNeighbors.push(idx, d, i, isn);
                this.mIsNew[i][j] = false;
            }
        }
        return candidateNeighbors;
    }
}

