/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

final class Sort {
    private Sort() {
    }

    public static void sort(float[] primary, int[] secondary) {
        if (primary.length != secondary.length) {
            throw new IllegalArgumentException();
        }
        Sort.sort(primary, 0, primary.length, new FloatIntSwapper(primary, secondary));
    }

    public static void sort(float[] x, int off, int len, Swapper swapper) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    swapper.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len != 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sort.med3(x, l, l + s, l + 2 * s);
                m = Sort.med3(x, m - s, m, m + s);
                n = Sort.med3(x, n - 2 * s, n - s, n);
            }
            m = Sort.med3(x, l, m, n);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && (double)x[b] <= v) {
                if ((double)x[b] >= v) {
                    swapper.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (double)x[c] >= v) {
                if ((double)x[c] <= v) {
                    swapper.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            swapper.swap(b++, c--);
        }
        int n2 = off + len;
        int s2 = Math.min(a - off, b - a);
        Sort.vecswap(swapper, off, b - s2, s2);
        s2 = Math.min(d - c, n2 - d - 1);
        Sort.vecswap(swapper, b, n2 - s2, s2);
        s2 = b - a;
        if (s2 > 1) {
            Sort.sort(x, off, s2, swapper);
        }
        if ((s2 = d - c) > 1) {
            Sort.sort(x, n2 - s2, s2, swapper);
        }
    }

    private static void vecswap(Swapper s, int aa, int bb, int n) {
        int i = 0;
        int a = aa;
        int b = bb;
        while (i < n) {
            s.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    static int med3(float[] x, int a, int b, int c) {
        float xa = x[a];
        float xb = x[b];
        float xc = x[c];
        return xa < xb ? (xb < xc ? b : (xa < xc ? c : a)) : (xb > xc ? b : (xa > xc ? c : a));
    }

    private static class FloatIntSwapper
    implements Swapper {
        private final float[] mPrimary;
        private final int[] mSecondary;

        FloatIntSwapper(float[] primary, int[] secondary) {
            this.mPrimary = primary;
            this.mSecondary = secondary;
        }

        @Override
        public void swap(int a, int b) {
            float t = this.mPrimary[a];
            this.mPrimary[a] = this.mPrimary[b];
            this.mPrimary[b] = t;
            int u = this.mSecondary[a];
            this.mSecondary[a] = this.mSecondary[b];
            this.mSecondary[b] = u;
        }
    }

    public static interface Swapper {
        public void swap(int var1, int var2);
    }
}

