/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap.metric;

import tagbio.umap.metric.Metric;

public final class HaversineMetric
extends Metric {
    public static final HaversineMetric SINGLETON = new HaversineMetric();

    private HaversineMetric() {
        super(false);
    }

    @Override
    public float distance(float[] x, float[] y) {
        if (x.length != 2) {
            throw new IllegalArgumentException("haversine is only defined for 2 dimensional data");
        }
        double sinLat = Math.sin(0.5 * (double)(x[0] - y[0]));
        double sinLong = Math.sin(0.5 * (double)(x[1] - y[1]));
        double result = Math.sqrt(sinLat * sinLat + Math.cos(x[0]) * Math.cos(y[0]) * sinLong * sinLong);
        return (float)(2.0 * Math.asin(result));
    }
}

