/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.statistics.median.ModelMedianDouble;
import com.actelion.research.calc.statistics.median.ModelMedianInteger;
import com.actelion.research.util.datamodel.PointDouble;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class ArrayUtilsCalc {
    public static final double getCorrPearson(List<PointDouble> li) {
        double[] a = new double[li.size()];
        double[] b = new double[li.size()];
        for (int i = 0; i < li.size(); ++i) {
            a[i] = li.get((int)i).x;
            b[i] = li.get((int)i).y;
        }
        return ArrayUtilsCalc.getCorrPearson(a, b);
    }

    public static final double getCorrPearson(Matrix A, Matrix B) {
        double[] a = A.toArray();
        double[] b = B.toArray();
        return ArrayUtilsCalc.getCorrPearson(a, b);
    }

    public static final double getCorrPearson(double[] a, double[] b) {
        double[] aCent = ArrayUtilsCalc.getCentered(a);
        double[] aCentNorm = ArrayUtilsCalc.getNormalized(aCent);
        double[] bCent = ArrayUtilsCalc.getCentered(b);
        double[] bCentNorm = ArrayUtilsCalc.getNormalized(bCent);
        double val = ArrayUtilsCalc.getCorrPearsonStandardized(aCentNorm, bCentNorm);
        return val;
    }

    public static final double getCorrPearsonStandardized(double[] a, double[] b) {
        double covXY = ArrayUtilsCalc.getCovarianceCentered(a, b);
        double varA = ArrayUtilsCalc.getVariance(a);
        double varB = ArrayUtilsCalc.getVariance(b);
        double val = covXY / (varA * varB);
        return val;
    }

    public static boolean equals(int[] a, int[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static double getCovarianceCentered(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * b[i];
        }
        double covXY = sum / (double)(a.length - 1);
        return covXY;
    }

    public static double[] getCentered(double[] arr) {
        double[] arrCent = new double[arr.length];
        double mean = ArrayUtilsCalc.getMean(arr);
        for (int i = 0; i < arr.length; ++i) {
            arrCent[i] = arr[i] - mean;
        }
        return arrCent;
    }

    public static final double[] getNormalized(double[] arr) {
        double[] arrNorm = new double[arr.length];
        double sdv = ArrayUtilsCalc.getStandardDeviation(arr);
        for (int i = 0; i < arr.length; ++i) {
            arrNorm[i] = arr[i] / sdv;
        }
        return arrNorm;
    }

    public static final double getVariance(double[] arr) {
        double sum = 0.0;
        double mean = ArrayUtilsCalc.getMean(arr);
        for (int i = 0; i < arr.length; ++i) {
            sum += (arr[i] - mean) * (arr[i] - mean);
        }
        double var = sum / (double)(arr.length - 1);
        return var;
    }

    public static final double getVariance(int[] arr) {
        double sum = 0.0;
        double mean = ArrayUtilsCalc.getMean(arr);
        for (int i = 0; i < arr.length; ++i) {
            sum += ((double)arr[i] - mean) * ((double)arr[i] - mean);
        }
        double var = sum / (double)(arr.length - 1);
        return var;
    }

    public static final double getStandardDeviation(double[] arr) {
        double sum = 0.0;
        double mean = ArrayUtilsCalc.getMean(arr);
        for (int i = 0; i < arr.length; ++i) {
            sum += (arr[i] - mean) * (arr[i] - mean);
        }
        double sdv = Math.sqrt(sum / (double)(arr.length - 1));
        return sdv;
    }

    public static final double getMean(double[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        return sum / (double)arr.length;
    }

    public static final double getMean(int[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += (double)arr[i];
        }
        return sum / (double)arr.length;
    }

    public static ModelMedianDouble getMedian(double[] arr) {
        Arrays.sort(arr);
        ModelMedianDouble m = new ModelMedianDouble();
        m.lowerQuartile = ArrayUtilsCalc.getPercentileFromSorted(arr, 0.25);
        m.median = ArrayUtilsCalc.getPercentileFromSorted(arr, 0.5);
        m.upperQuartile = ArrayUtilsCalc.getPercentileFromSorted(arr, 0.75);
        m.size = arr.length;
        return m;
    }

    public static ModelMedianInteger getMedian(int[] arr) {
        Arrays.sort(arr);
        ModelMedianInteger m = new ModelMedianInteger();
        m.lowerQuartile = ArrayUtilsCalc.getPercentileFromSorted(arr, 0.25);
        m.median = ArrayUtilsCalc.getPercentileFromSorted(arr, 0.5);
        m.upperQuartile = ArrayUtilsCalc.getPercentileFromSorted(arr, 0.75);
        m.size = arr.length;
        return m;
    }

    public static double getPercentileFromSorted(double[] arr, double fraction) {
        if (arr.length == 1) {
            return arr[0];
        }
        double percentile = 0.0;
        int len = arr.length;
        if ((double)((int)((double)len * fraction)) == (double)len * fraction) {
            int index1 = (int)((double)len * fraction) - 1;
            int index2 = index1 + 1;
            if (index1 < 0) {
                throw new RuntimeException("Fraction to small.");
            }
            percentile = (arr[index1] + arr[index2]) / 2.0;
        } else {
            int index1 = (int)((double)len * fraction);
            percentile = arr[index1];
        }
        return percentile;
    }

    public static int getPercentileFromSorted(int[] arr, double fraction) {
        if (arr.length == 1) {
            return arr[0];
        }
        int percentile = 0;
        int len = arr.length;
        if ((double)((int)((double)len * fraction)) == (double)len * fraction) {
            int index1 = (int)((double)len * fraction) - 1;
            int index2 = index1 + 1;
            if (index1 < 0) {
                throw new RuntimeException("Fraction to small.");
            }
            percentile = (int)((double)(arr[index1] + arr[index2]) / 2.0 + 0.5);
        } else {
            int index1 = (int)((double)len * fraction);
            percentile = arr[index1];
        }
        return percentile;
    }

    public static final boolean findIdentical(int[] a, int[] b) {
        boolean bFound = false;
        block0: for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (a[i] != b[j]) continue;
                bFound = true;
                continue block0;
            }
        }
        return bFound;
    }

    public static final double[] filter(int[] arrData, double[] arrFilter) {
        double[] arr = new double[arrData.length];
        for (int i = 0; i < arr.length; ++i) {
            double val = 0.0;
            for (int j = 0; j < arrFilter.length; ++j) {
                int indexFilter = -arrFilter.length / 2 + j;
                int indexData = indexFilter + i;
                if (indexData < 0 || indexData >= arr.length) continue;
                val += (double)arrData[indexData] * arrFilter[j];
            }
            arr[i] = val;
        }
        return arr;
    }

    public static final double[] filter(byte[] arrData, double[] arrFilter) {
        double[] arr = new double[arrData.length];
        for (int i = 0; i < arr.length; ++i) {
            double val = 0.0;
            for (int j = 0; j < arrFilter.length; ++j) {
                int indexFilter = -arrFilter.length / 2 + j;
                int indexData = indexFilter + i;
                if (indexData < 0 || indexData >= arr.length) continue;
                val += (double)arrData[indexData] * arrFilter[j];
            }
            arr[i] = val;
        }
        return arr;
    }

    public static final boolean contains(int[] a, int b) {
        boolean bFound = false;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != b) continue;
            bFound = true;
            break;
        }
        return bFound;
    }

    public static final int[] cat(int[] a, int[] b) {
        int i;
        int[] c = new int[a.length + b.length];
        for (i = 0; i < a.length; ++i) {
            c[i] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            c[a.length + i] = b[i];
        }
        return c;
    }

    public static final int[] copy(int[] a) {
        int[] b = new int[a.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public static final byte[] copy(byte[] a) {
        byte[] b = new byte[a.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public static final List<int[]> copyIntArray(List<int[]> li) {
        ArrayList<int[]> liC = new ArrayList<int[]>(li.size());
        for (int[] a : li) {
            int[] c = new int[a.length];
            System.arraycopy(a, 0, c, 0, a.length);
            liC.add(c);
        }
        return liC;
    }

    public static final Object[] copy(Object[] a) {
        Object[] b = new Object[a.length];
        for (int ii = 0; ii < a.length; ++ii) {
            b[ii] = a[ii];
        }
        return b;
    }

    public static final double[] extractCol(double[][] a, int col) {
        double[] b = new double[a.length];
        for (int ii = 0; ii < a.length; ++ii) {
            b[ii] = a[ii][col];
        }
        return b;
    }

    public static final int sum(int[] a) {
        int b = 0;
        for (int ii = 0; ii < a.length; ++ii) {
            b += a[ii];
        }
        return b;
    }

    public static final int sum(long[] a) {
        int b = 0;
        for (int ii = 0; ii < a.length; ++ii) {
            b = (int)((long)b + a[ii]);
        }
        return b;
    }

    public static final int sum(byte[] a) {
        int b = 0;
        for (int ii = 0; ii < a.length; ++ii) {
            b += a[ii];
        }
        return b;
    }

    public static final double sum(double[] a) {
        double b = 0.0;
        for (int ii = 0; ii < a.length; ++ii) {
            b += a[ii];
        }
        return b;
    }

    public static final String[] resize(String[] arr, int newSize) {
        String[] tmp = new String[newSize];
        int size = Math.min(arr.length, newSize);
        System.arraycopy(arr, 0, tmp, 0, size);
        return tmp;
    }

    public static final int[] resize(int[] arr, int newSize) {
        int[] tmp = new int[newSize];
        int size = Math.min(arr.length, newSize);
        System.arraycopy(arr, 0, tmp, 0, size);
        return tmp;
    }

    public static final byte[] resize(byte[] arr, int newSize) {
        byte[] tmp = new byte[newSize];
        int size = Math.min(arr.length, newSize);
        System.arraycopy(arr, 0, tmp, 0, size);
        return tmp;
    }

    public static final boolean[] resize(boolean[] arr, int newSize) {
        boolean[] tmp = new boolean[newSize];
        int size = Math.min(arr.length, newSize);
        System.arraycopy(arr, 0, tmp, 0, size);
        return tmp;
    }

    public static final double[] resize(double[] arr, int newSize) {
        double[] tmp = new double[newSize];
        int size = Math.min(arr.length, newSize);
        System.arraycopy(arr, 0, tmp, 0, size);
        return tmp;
    }

    public static final void removeDoubletsInt(List<int[]> li) {
        block0: for (int i = 0; i < li.size(); ++i) {
            for (int j = li.size() - 1; j > i; --j) {
                int[] a1 = li.get(i);
                int[] a2 = li.get(j);
                boolean bEq = true;
                if (a2.length != a1.length) {
                    bEq = false;
                    continue block0;
                }
                for (int k = 0; k < a2.length; ++k) {
                    if (a1[k] == a2[k]) continue;
                    bEq = false;
                    break;
                }
                if (!bEq) continue;
                li.remove(j);
            }
        }
    }

    public static final void removeDoubletsIntOrderIndepend(List<int[]> li) {
        for (int i = 0; i < li.size(); ++i) {
            for (int j = li.size() - 1; j > i; --j) {
                int[] a1 = li.get(i);
                int[] a2 = li.get(j);
                boolean bEq = true;
                for (int k = 0; k < a1.length; ++k) {
                    boolean bFound = false;
                    for (int l = 0; l < a2.length; ++l) {
                        if (a1[k] != a2[l]) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    bEq = false;
                    break;
                }
                if (!bEq) continue;
                li.remove(j);
            }
        }
    }

    public static final double[][] resize(double[][] mData, int iNumberRowsNew, int iNumberColsNew) {
        double[][] dTmp = new double[iNumberRowsNew][iNumberColsNew];
        int iRows = iNumberRowsNew;
        int iCols = iNumberColsNew;
        if (iNumberRowsNew > mData.length) {
            iRows = mData.length;
        }
        if (iNumberColsNew > mData[0].length) {
            iCols = mData[0].length;
        }
        for (int ii = 0; ii < iRows; ++ii) {
            for (int jj = 0; jj < iCols; ++jj) {
                dTmp[ii][jj] = mData[ii][jj];
            }
        }
        return dTmp;
    }

    public static final boolean[][] resize(boolean[][] mData, int rows) {
        return ArrayUtilsCalc.resize(mData, rows, mData[0].length);
    }

    public static final boolean[][] resize(boolean[][] mData, int iNumberRowsNew, int iNumberColsNew) {
        boolean[][] dTmp = new boolean[iNumberRowsNew][iNumberColsNew];
        int iRows = iNumberRowsNew;
        int iCols = iNumberColsNew;
        if (iNumberRowsNew > mData.length) {
            iRows = mData.length;
        }
        if (iNumberColsNew > mData[0].length) {
            iCols = mData[0].length;
        }
        for (int ii = 0; ii < iRows; ++ii) {
            for (int jj = 0; jj < iCols; ++jj) {
                dTmp[ii][jj] = mData[ii][jj];
            }
        }
        return dTmp;
    }

    public static final int[] reverse(int[] arr) {
        int[] res = new int[arr.length];
        for (int i = 0; i < res.length; ++i) {
            res[res.length - i - 1] = arr[i];
        }
        return res;
    }

    public static final void reverse(Object[] mArrResult) {
        for (int i = 0; i < mArrResult.length / 2; ++i) {
            Object res = mArrResult[mArrResult.length - i - 1];
            mArrResult[mArrResult.length - i - 1] = mArrResult[i];
            mArrResult[i] = res;
        }
    }

    public static List<Integer> getOverlap(int[] a1, int[] a2) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (int i = 0; i < a1.length; ++i) {
            ts.add(a1[i]);
        }
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < a2.length; ++i) {
            if (ts.add(a2[i])) continue;
            li.add(a2[i]);
        }
        return li;
    }

    public static List<Integer> getUnique(int[] a1, int[] a2) {
        int i;
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (i = 0; i < a1.length; ++i) {
            ts.add(a1[i]);
        }
        for (i = 0; i < a2.length; ++i) {
            ts.add(a2[i]);
        }
        ArrayList<Integer> li = new ArrayList<Integer>(ts);
        return li;
    }

    public static final int[] getUnique(int[] arr) {
        TreeSet<Integer> ts = new TreeSet<Integer>();
        for (int i = 0; i < arr.length; ++i) {
            ts.add(arr[i]);
        }
        int[] res = ArrayUtilsCalc.toIntArray(ts);
        return res;
    }

    public static final int[] toIntArray(Collection<Integer> list) {
        int[] res = new int[list.size()];
        int index = 0;
        for (Integer i : list) {
            res[index++] = i;
        }
        return res;
    }

    public static final String[] toArray(List<String> list) {
        String[] res = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i);
        }
        return res;
    }

    public static final String[][] toArrayStrStr(List<List<String>> list) {
        String[][] res = new String[list.size()][list.get(0).size()];
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.get(i).size(); ++j) {
                res[i][j] = list.get(i).get(j);
            }
        }
        return res;
    }

    public static final double[] toDoubleArray(List<Double> list) {
        double[] res = new double[list.size()];
        int index = 0;
        for (double d : list) {
            res[index++] = d;
        }
        return res;
    }

    public static final double[] toDoubleArray(int[] a) {
        double[] res = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            res[i] = a[i];
        }
        return res;
    }

    public static final int[] toIntArray(double[] a) {
        int[] res = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            res[i] = (int)a[i];
        }
        return res;
    }

    public static final List<Integer> toList(int[] a) {
        if (a == null) {
            return null;
        }
        ArrayList<Integer> li = new ArrayList<Integer>(a.length);
        for (int i = 0; i < a.length; ++i) {
            li.add(a[i]);
        }
        return li;
    }

    public static final List<String> toList(String[] a) {
        if (a == null) {
            return null;
        }
        ArrayList<String> li = new ArrayList<String>(a.length);
        for (int i = 0; i < a.length; ++i) {
            li.add(a[i]);
        }
        return li;
    }

    public static final int indexOf(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int[] array, int obj) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public static final int lastIndexOf(int[] array, int obj) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public static final int lastIndexOfNot(byte[] array, int obj) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == obj) continue;
            return i;
        }
        return -1;
    }

    public static final double min(double[] array) {
        if (array.length == 0) {
            return 0.0;
        }
        double res = array[0];
        for (int i = 1; i < array.length; ++i) {
            res = Math.min(res, array[i]);
        }
        return res;
    }

    public static final int min(int[] array) {
        if (array.length == 0) {
            return 0;
        }
        int res = array[0];
        for (int i = 1; i < array.length; ++i) {
            res = Math.min(res, array[i]);
        }
        return res;
    }

    public static final double min(double[][] array, int col) {
        if (array.length == 0) {
            return 0.0;
        }
        double res = array[0][col];
        for (int i = 1; i < array.length; ++i) {
            res = Math.min(res, array[i][col]);
        }
        return res;
    }

    public static final double min(float[][] array, int col) {
        if (array.length == 0) {
            return 0.0;
        }
        float res = array[0][col];
        for (int i = 1; i < array.length; ++i) {
            res = Math.min(res, array[i][col]);
        }
        return res;
    }

    public static final byte max(byte[] array) {
        if (array.length == 0) {
            return 0;
        }
        byte res = array[0];
        for (int i = 1; i < array.length; ++i) {
            res = (byte)Math.max(res, array[i]);
        }
        return res;
    }

    public static final double max(double[] array) {
        if (array.length == 0) {
            return 0.0;
        }
        double res = array[0];
        for (int i = 1; i < array.length; ++i) {
            res = Math.max(res, array[i]);
        }
        return res;
    }

    public static final double maxDouble(List<Double> array) {
        if (array.size() == 0) {
            return 0.0;
        }
        double res = array.get(0);
        for (int i = 1; i < array.size(); ++i) {
            res = Math.max(res, array.get(i));
        }
        return res;
    }

    public static final int maxInt(List<Integer> array) {
        if (array.size() == 0) {
            return 0;
        }
        int res = array.get(0);
        for (int i = 1; i < array.size(); ++i) {
            res = Math.max(res, array.get(i));
        }
        return res;
    }

    public static final double max(double[][] array, int col) {
        if (array.length == 0) {
            return 0.0;
        }
        double res = array[0][col];
        for (int i = 1; i < array.length; ++i) {
            res = Math.max(res, array[i][col]);
        }
        return res;
    }

    public static final double max(float[][] array, int col) {
        if (array.length == 0) {
            return 0.0;
        }
        float res = array[0][col];
        for (int i = 1; i < array.length; ++i) {
            res = Math.max(res, array[i][col]);
        }
        return res;
    }

    public static final int max(int[] array) {
        if (array.length == 0) {
            return 0;
        }
        int res = array[0];
        for (int i = 1; i < array.length; ++i) {
            res = Math.max(res, array[i]);
        }
        return res;
    }

    public static int[] readIntArray(String s) {
        return ArrayUtilsCalc.readIntArray(s, ",");
    }

    public static int[] readIntArray(String s, String seperator) {
        s = s.replace('[', ' ');
        s = s.replace(']', ' ');
        s = s.trim();
        StringTokenizer st = new StringTokenizer(s, seperator);
        ArrayList<Integer> li = new ArrayList<Integer>();
        while (st.hasMoreTokens()) {
            li.add(Integer.parseInt(st.nextToken().trim()));
        }
        return ArrayUtilsCalc.toIntArray(li);
    }

    public static double[] readDoubleArray(String s) {
        return ArrayUtilsCalc.readDoubleArray(s, ",");
    }

    public static double[] readDoubleArray(String s, String seperator) {
        s = s.replace('[', ' ');
        s = s.replace(']', ' ');
        s = s.trim();
        StringTokenizer st = new StringTokenizer(s, seperator);
        ArrayList<Double> li = new ArrayList<Double>();
        while (st.hasMoreTokens()) {
            li.add(Double.parseDouble(st.nextToken().trim()));
        }
        return ArrayUtilsCalc.toDoubleArray(li);
    }

    public static final void set(int[] array, int val) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = val;
        }
    }

    public static final void set(float[] array, float val) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = val;
        }
    }

    public static final void set(double[] array, double val) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = val;
        }
    }

    public static final void set(int[][] array, int val) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                array[i][j] = val;
            }
        }
    }

    public static final void set(short[][] array, short val) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                array[i][j] = val;
            }
        }
    }

    public static final void set(double[][] array, double val) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                array[i][j] = val;
            }
        }
    }

    public static final void set(float[][] array, float val) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                array[i][j] = val;
            }
        }
    }

    public static final String toStringBinary(int[] v) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < v.length; ++i) {
            sb.append(ArrayUtilsCalc.toStringBinary(v[i]));
            if (i >= v.length - 1) continue;
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toStringBinary(int v) {
        String str = "";
        int len = 32;
        for (int ii = 0; ii < len; ++ii) {
            str = (v & 1) == 1 ? "1 " + str : "0 " + str;
            v >>= 1;
        }
        return str.trim();
    }

    public static final String toString(int[] v) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < v.length; ++i) {
            sb.append((i > 0 ? "," : "") + v[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public static final String toString(Collection<Integer> li) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int cc = 0;
        for (int i : li) {
            sb.append((cc > 0 ? "," : "") + i);
            ++cc;
        }
        sb.append("]");
        return sb.toString();
    }

    public static final String toStringNoBrackets(Collection<Integer> li, String sep) {
        StringBuilder sb = new StringBuilder();
        int cc = 0;
        for (int i : li) {
            sb.append((cc > 0 ? sep : "") + i);
            ++cc;
        }
        return sb.toString();
    }

    public static final String toStringIntegerList(List<Integer> li, int step) {
        StringBuilder sb = new StringBuilder();
        sb = new StringBuilder();
        for (int i = 0; i < li.size(); i += step) {
            if (i + step > li.size()) {
                step = li.size() - i;
            }
            for (int j = i; j < i + step; ++j) {
                sb.append(li.get(j));
                if (j >= i + step - 1) continue;
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static final String toStringLongList(List<Long> li, int step) {
        StringBuilder sb = new StringBuilder();
        sb = new StringBuilder();
        for (int i = 0; i < li.size(); i += step) {
            if (i + step > li.size()) {
                step = li.size() - i;
            }
            for (int j = i; j < i + step; ++j) {
                sb.append(li.get(j));
                if (j >= i + step - 1) continue;
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static final String[] toStringArray(List<Integer> li) {
        String[] a = new String[li.size()];
        for (int i = 0; i < li.size(); ++i) {
            a[i] = Integer.toString(li.get(i));
        }
        return a;
    }

    public static final String toString(byte[] v) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < v.length; ++i) {
            int val = v[i] & 0xFF;
            sb.append((i > 0 ? ", " : "") + val);
        }
        sb.append("]");
        return sb.toString();
    }

    public static final String toStringPure(int[] v) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            sb.append((i > 0 ? " " : "") + v[i]);
        }
        return sb.toString();
    }

    public static final String toStringIntArrays(List<int[]> li) {
        StringBuilder buff = new StringBuilder();
        for (int[] element : li) {
            buff.append(ArrayUtilsCalc.toString(element) + "\n");
        }
        return buff.toString();
    }

    public static final String toString(int[][] v) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[0].length; ++j) {
                sb.append((j > 0 ? "," : "") + v[i][j]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static final String toStringFormatted(int[] arrTop, int[] arrBottom) {
        int[][] v = new int[][]{arrTop, arrBottom};
        return ArrayUtilsCalc.toStringFormatted(v);
    }

    public static final String toStringFormatted(int[][] v) {
        int maxAbs = 0;
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[0].length; ++j) {
                if (Math.abs(v[i][j]) <= maxAbs) continue;
                maxAbs = Math.abs(v[i][j]);
            }
        }
        int len = Integer.toString(maxAbs).length() + 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[0].length; ++j) {
                StringBuilder sbVal = new StringBuilder(Integer.toString(v[i][j]));
                while (sbVal.length() < len) {
                    sbVal.insert(0, " ");
                }
                sb.append((CharSequence)sbVal);
                if (j >= v[0].length - 1) continue;
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static final String toString(double[] v) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < v.length; ++i) {
            sb.append((i > 0 ? "," : "") + v[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public static final String toStringPure(double[] v) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            sb.append((i > 0 ? "\t" : "") + v[i]);
        }
        return sb.toString();
    }

    public static final String toString(double[] v, NumberFormat nf) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < v.length; ++i) {
            sb.append((i > 0 ? "," : "") + nf.format(v[i]));
        }
        sb.append("]");
        return sb.toString();
    }

    public static final String toString(double[][] v) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[0].length; ++j) {
                res.append((j > 0 ? "," : "") + v[i][j]);
            }
            res.append("\n");
        }
        return res.toString();
    }

    public static final String toString(double[] v, int iDigits) {
        String sFormat = "";
        sFormat = sFormat + "0";
        int iCounter = 0;
        if (iDigits > 0) {
            sFormat = sFormat + ".";
        }
        while (iCounter < iDigits) {
            sFormat = sFormat + "0";
            ++iCounter;
        }
        DecimalFormat nf = new DecimalFormat(sFormat);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            sb.append((i > 0 ? "," : "") + nf.format(v[i]));
        }
        return sb.toString();
    }

    public static final String toString(float[] v, int iDigits) {
        String sFormat = "";
        sFormat = sFormat + "0";
        int iCounter = 0;
        if (iDigits > 0) {
            sFormat = sFormat + ".";
        }
        while (iCounter < iDigits) {
            sFormat = sFormat + "0";
            ++iCounter;
        }
        DecimalFormat nf = new DecimalFormat(sFormat);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            sb.append((i > 0 ? "," : "") + nf.format(v[i]));
        }
        return sb.toString();
    }

    public static final String toString(double[][] v, int iDigits) {
        String sFormat = "";
        sFormat = sFormat + "0";
        int iCounter = 0;
        if (iDigits > 0) {
            sFormat = sFormat + ".";
        }
        while (iCounter < iDigits) {
            sFormat = sFormat + "0";
            ++iCounter;
        }
        DecimalFormat nf = new DecimalFormat(sFormat);
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[i].length; ++j) {
                res.append((j > 0 ? " " : "") + nf.format(v[i][j]));
            }
            res.append(i < v.length - 1 ? "\n" : "");
        }
        return res.toString();
    }

    public static final String toStringNoDigits(double[] v) {
        DecimalFormat nf = new DecimalFormat("0");
        String res = "";
        for (int i = 0; i < v.length; ++i) {
            res = res + (i > 0 ? "," : "") + nf.format(v[i]);
        }
        return res + "";
    }

    public static final String toString(Object[] v) {
        String res = "[";
        for (int i = 0; i < v.length; ++i) {
            res = res + (i > 0 ? "," : "") + v[i];
        }
        return res + "]";
    }

    public static final void shift(int[] v, int n) {
        int[] copy = new int[v.length];
        for (int i = 0; i < v.length; ++i) {
            copy[i] = v[(i + n + v.length) % v.length];
        }
        System.arraycopy(copy, 0, v, 0, v.length);
    }

    public static final List<Integer> parseInteger(String s, String sep) {
        StringTokenizer st = new StringTokenizer(s, sep);
        ArrayList<Integer> li = new ArrayList<Integer>();
        while (st.hasMoreTokens()) {
            int v = Integer.parseInt(st.nextToken());
            li.add(v);
        }
        return li;
    }
}

