/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.LUDecomposition;
import com.actelion.research.util.DoubleVec;
import com.actelion.research.util.convert.String2DoubleArray;
import com.actelion.research.util.datamodel.IntegerDouble;
import com.actelion.research.util.datamodel.ScorePoint;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class Matrix {
    public static final double TINY04 = 1.0E-4;
    public static final double TINY08 = 1.0E-8;
    public static final double TINY16 = Math.pow(10.0, -16.0);
    public static String OUT_SEPARATOR_COL = "\t";
    public static String OUT_SEPARATOR_ROW = "\n";
    private static final String FORMAT = "0.############";
    public static final double TINY = 1.0E-11;
    private double[][] data;
    private int identifier;

    public Matrix() {
        this.data = new double[1][1];
    }

    public Matrix(int rows, int cols) {
        this.data = new double[rows][cols];
    }

    public Matrix(Matrix ma) {
        this(ma.getArray());
    }

    public Matrix(boolean row, double[] arr) {
        if (row) {
            this.data = new double[1][];
            this.data[0] = arr;
        } else {
            this.data = new double[arr.length][1];
            for (int i = 0; i < this.getRowDim(); ++i) {
                this.data[i][0] = arr[i];
            }
        }
    }

    public Matrix(boolean row, byte[] arr) {
        if (row) {
            this.data = new double[1][arr.length];
            for (int i = 0; i < arr.length; ++i) {
                this.data[0][i] = arr[i];
            }
        } else {
            this.data = new double[arr.length][1];
            for (int i = 0; i < this.getRowDim(); ++i) {
                this.data[i][0] = arr[i];
            }
        }
    }

    public Matrix(boolean row, int[] dArray) {
        if (row) {
            this.data = new double[1][dArray.length];
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                this.data[0][jj] = dArray[jj];
            }
        } else {
            this.data = new double[dArray.length][1];
            for (int ii = 0; ii < this.getRowDim(); ++ii) {
                this.data[ii][0] = dArray[ii];
            }
        }
    }

    public Matrix(double[][] arrArr) {
        this.data = new double[arrArr.length][];
        int rows = arrArr.length;
        int cols = arrArr[0].length;
        for (int i = 0; i < rows; ++i) {
            double[] arr = new double[cols];
            System.arraycopy(arrArr[i], 0, arr, 0, cols);
            this.data[i] = arr;
        }
    }

    public Matrix(double[][] arrArr, boolean flat) {
        if (!flat) {
            throw new RuntimeException("Only flat constructor!");
        }
        this.data = arrArr;
    }

    public Matrix(float[][] arrArr) {
        this.data = new double[arrArr.length][arrArr[0].length];
        int rows = arrArr.length;
        int cols = arrArr[0].length;
        for (int i = 0; i < rows; ++i) {
            double[] arr = new double[cols];
            for (int j = 0; j < arr.length; ++j) {
                this.data[i][j] = arrArr[i][j];
            }
        }
    }

    public Matrix(int[][] arrArr) {
        this.data = new double[arrArr.length][];
        int rows = arrArr.length;
        int cols = arrArr[0].length;
        for (int i = 0; i < rows; ++i) {
            double[] arr = new double[cols];
            for (int j = 0; j < cols; ++j) {
                arr[j] = arrArr[i][j];
            }
            this.data[i] = arr;
        }
    }

    public Matrix(byte[][] arrArr) {
        this.data = new double[arrArr.length][];
        int rows = arrArr.length;
        int cols = arrArr[0].length;
        for (int i = 0; i < rows; ++i) {
            double[] arr = new double[cols];
            System.arraycopy(arrArr[i], 0, arr, 0, cols);
            this.data[i] = arr;
        }
    }

    public Matrix(List<DoubleVec> vecDoubleVec) {
        DoubleVec dv = vecDoubleVec.get(0);
        this.data = new double[vecDoubleVec.size()][dv.size()];
        for (int ii = 0; ii < this.getRowDim(); ++ii) {
            dv = vecDoubleVec.get(ii);
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                this.data[ii][jj] = dv.get(jj);
            }
        }
    }

    public Matrix(boolean bRow, List<Double> liDoubles) {
        if (bRow) {
            this.data = new double[1][liDoubles.size()];
            for (int i = 0; i < this.getColDim(); ++i) {
                this.data[0][i] = liDoubles.get(i);
            }
        } else {
            this.data = new double[liDoubles.size()][1];
            for (int i = 0; i < this.getRowDim(); ++i) {
                this.data[i][0] = liDoubles.get(i);
            }
        }
    }

    public Matrix add(double v) {
        int r = this.rows();
        int c = this.cols();
        Matrix A = new Matrix(r, c);
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                double s = this.get(i, j) + v;
                A.set(i, j, s);
            }
        }
        return A;
    }

    public void addRow(double[] arr) {
        if (this.getColDim() != arr.length) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        this.resize(this.getRowDim() + 1, this.getColDim());
        for (int ii = 0; ii < arr.length; ++ii) {
            this.data[this.getRowDim() - 1][ii] = arr[ii];
        }
    }

    public void addRow(int[] arr) {
        if (this.getColDim() != arr.length) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        this.resize(this.getRowDim() + 1, this.getColDim());
        for (int ii = 0; ii < arr.length; ++ii) {
            this.data[this.getRowDim() - 1][ii] = arr[ii];
        }
    }

    public void add2Row(int row, Matrix ma2, int row2) {
        for (int ii = 0; ii < this.getColDim(); ++ii) {
            double[] dArray = this.data[row];
            int n = ii;
            dArray[n] = dArray[n] + ma2.data[row2][ii];
        }
    }

    public void addToElement(int i, int j, double value) {
        double[] dArray = this.data[i];
        int n = j;
        dArray[n] = dArray[n] + value;
    }

    public Matrix add2CompleteCol(Matrix maRow) {
        Matrix m = new Matrix(this);
        for (int ii = 0; ii < this.getRowDim(); ++ii) {
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                double[] dArray = m.data[ii];
                int n = jj;
                dArray[n] = dArray[n] + maRow.data[0][jj];
            }
        }
        return m;
    }

    public void assignCol(int iCol, Matrix ma) {
        if (this.getRowDim() != ma.getRowDim()) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        for (int ii = 0; ii < this.data.length; ++ii) {
            this.data[ii][iCol] = ma.data[ii][0];
        }
    }

    public void assignCol(int iCol, Matrix ma, int iColMa) {
        if (this.getRowDim() != ma.getRowDim()) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        for (int ii = 0; ii < this.data.length; ++ii) {
            this.data[ii][iCol] = ma.data[ii][iColMa];
        }
    }

    public void assignRow(int iRow, Vector<Double> vecRow) {
        if (this.getColDim() != vecRow.size()) {
            throw new RuntimeException("Matrix and Vector have wrong dimensions.");
        }
        for (int jj = 0; jj < this.data[0].length; ++jj) {
            this.data[iRow][jj] = vecRow.get(jj);
        }
    }

    public void assignRow(int iRow, double[] arr) {
        if (this.getColDim() != arr.length) {
            throw new RuntimeException("Matrix and Vector have wrong dimensions.");
        }
        for (int jj = 0; jj < arr.length; ++jj) {
            this.data[iRow][jj] = arr[jj];
        }
    }

    public void assignRow(int iRow, int[] arr) {
        if (this.getColDim() != arr.length) {
            throw new RuntimeException("Matrix and Vector have wrong dimensions.");
        }
        for (int jj = 0; jj < arr.length; ++jj) {
            this.data[iRow][jj] = arr[jj];
        }
    }

    public void assignRow(int iRow, DoubleVec dv) {
        if (this.getColDim() != dv.size()) {
            throw new RuntimeException("Matrix and Vector have wrong dimensions.");
        }
        for (int jj = 0; jj < dv.size(); ++jj) {
            this.data[iRow][jj] = dv.get(jj);
        }
    }

    public boolean containsRow(DoubleVec dv) {
        boolean bOK = false;
        int iRows = this.getRowDim();
        int iCols = this.getColDim();
        for (int ii = 0; ii < iRows; ++ii) {
            bOK = true;
            for (int jj = 0; jj < iCols; ++jj) {
                if (this.data[ii][jj] == dv.get(jj)) continue;
                bOK = false;
                break;
            }
            if (bOK) break;
        }
        return bOK;
    }

    public void copy(Matrix maSource) {
        int rows = maSource.rows();
        int cols = maSource.cols();
        if (this.rows() == rows && this.cols() == cols) {
            for (int i = 0; i < rows; ++i) {
                System.arraycopy(maSource.data[i], 0, this.data[i], 0, cols);
            }
        } else {
            this.data = new double[rows][];
            for (int i = 0; i < rows; ++i) {
                double[] a = new double[cols];
                System.arraycopy(maSource.data[i], 0, a, 0, cols);
                this.data[i] = a;
            }
        }
    }

    public void copy(int offsetRows, Matrix maSource) {
        if (this.cols() != maSource.cols()) {
            throw new RuntimeException("Matrix col dimension error. Number of cols differ!");
        }
        int cols = this.cols();
        int r = maSource.rows();
        for (int i = 0; i < r; ++i) {
            System.arraycopy(maSource.data[i], 0, this.data[offsetRows + i], 0, cols);
        }
    }

    public void copyColumn(Matrix maSource, int colSource, int colDestination) {
        int rows = maSource.rows();
        for (int i = 0; i < rows; ++i) {
            this.data[i][colDestination] = maSource.get(i, colSource);
        }
    }

    public final double get(int row, int col) {
        return this.data[row][col];
    }

    public Matrix getAbs() {
        Matrix ma = new Matrix(this.getRowDim(), this.getColDim());
        for (int ii = 0; ii < this.getRowDim(); ++ii) {
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                ma.data[ii][jj] = Math.abs(this.data[ii][jj]);
            }
        }
        return ma;
    }

    public final double[][] getArray() {
        return this.data;
    }

    public int[][] getArrayAsInt() throws NumberFormatException {
        int[][] arr = new int[this.data.length][this.data[0].length];
        for (int ii = 0; ii < this.getRowDim(); ++ii) {
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                if (this.data[ii][jj] > 2.147483647E9 || this.data[ii][jj] < -2.147483648E9) {
                    String err = "Double value instead of int " + this.data[ii][jj] + ".";
                    throw new NumberFormatException(err);
                }
                arr[ii][jj] = (int)this.data[ii][jj];
            }
        }
        return arr;
    }

    public double[][] getArrayCopy() {
        double[][] arr = new double[this.data.length][this.data[0].length];
        for (int ii = 0; ii < this.getRowDim(); ++ii) {
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                arr[ii][jj] = this.data[ii][jj];
            }
        }
        return arr;
    }

    public Matrix getCenteredMatrix() {
        int cols = this.cols();
        int rows = this.rows();
        double[][] arr = new double[rows][];
        Matrix maMean = this.getMeanCols();
        double[] arrMean = maMean.getRow(0);
        for (int i = 0; i < rows; ++i) {
            double[] arrRowSrc = this.getRow(i);
            double[] arrRow = new double[cols];
            System.arraycopy(arrRowSrc, 0, arrRow, 0, arrRowSrc.length);
            for (int j = 0; j < cols; ++j) {
                arrRow[j] = arrRow[j] - arrMean[j];
            }
            arr[i] = arrRow;
        }
        Matrix ma = new Matrix();
        ma.setFlat(arr);
        return ma;
    }

    public Matrix getCenteredMatrix(Matrix maMean) {
        Matrix ma = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                ma.data[i][j] = this.data[i][j] - maMean.data[0][j];
            }
        }
        return ma;
    }

    public Matrix getCol(int col) {
        Matrix ma = new Matrix(this.rows(), 1);
        int iRows = this.getRowDim();
        for (int i = 0; i < iRows; ++i) {
            ma.data[i][0] = this.data[i][col];
        }
        return ma;
    }

    public Matrix removeCol(int col2Remove) {
        int r = this.rows();
        int c = this.cols();
        Matrix ma = new Matrix(r, c - 1);
        for (int i = 0; i < r; ++i) {
            int ccColNew = 0;
            for (int j = 0; j < c; ++j) {
                if (j == col2Remove) continue;
                ma.data[i][ccColNew++] = this.data[i][j];
            }
        }
        return ma;
    }

    public double[] getColAsDouble(int col) {
        double[] arr = new double[this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            arr[i] = this.data[i][col];
        }
        return arr;
    }

    public List<Double> getColAsList(int col) {
        ArrayList<Double> li = new ArrayList<Double>(this.rows());
        for (int i = 0; i < this.rows(); ++i) {
            li.add(this.data[i][col]);
        }
        return li;
    }

    public float[] getColAsFloat(int iCol) {
        float[] arr = new float[this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            arr[i] = (float)this.data[i][iCol];
        }
        return arr;
    }

    public int[] getColAsInt(int iCol) {
        int[] arr = new int[this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            arr[i] = (int)(this.data[i][iCol] + 0.5);
        }
        return arr;
    }

    public Matrix getColumns(Vector<Integer> vecIndices) {
        Matrix maReduced = new Matrix(this.getRowDim(), vecIndices.size());
        for (int i = 0; i < vecIndices.size(); ++i) {
            int col = vecIndices.get(i);
            maReduced.assignCol(i, this, col);
        }
        return maReduced;
    }

    public Matrix getColumns(List<Integer> liIndex) {
        Matrix maReduced = new Matrix(this.getRowDim(), liIndex.size());
        for (int i = 0; i < liIndex.size(); ++i) {
            int col = liIndex.get(i);
            maReduced.assignCol(i, this, col);
        }
        return maReduced;
    }

    public Matrix getColumns(int[] arrIndex) {
        Matrix maReduced = new Matrix(this.getRowDim(), arrIndex.length);
        for (int i = 0; i < arrIndex.length; ++i) {
            int col = arrIndex[i];
            maReduced.assignCol(i, this, col);
        }
        return maReduced;
    }

    public int getColDim() {
        return this.data[0].length;
    }

    public int cols() {
        return this.data[0].length;
    }

    public Matrix getDeleteColsZeroVar(List<Integer> vecIndices) {
        vecIndices.clear();
        Matrix maReduced = new Matrix(0, 0);
        Matrix maVar = this.getVarianceCols();
        vecIndices.clear();
        for (int ii = 0; ii < maVar.getColDim(); ++ii) {
            if (!(maVar.get(0, ii) > 0.0)) continue;
            vecIndices.add(new Integer(ii));
        }
        maReduced = this.getColumns(vecIndices);
        return maReduced;
    }

    public Matrix covariance() {
        int n = this.getColDim();
        int m = this.getRowDim();
        Matrix X = new Matrix(n, n);
        int degrees = m - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += this.get(k, i);
                    s2 += this.get(k, j);
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (this.get(k, i) - s1) * (this.get(k, j) - s2);
                }
                X.set(i, j, c / (double)degrees);
            }
        }
        return X;
    }

    public Matrix correlation() {
        int j;
        int i;
        int n = this.getColDim();
        int m = this.getRowDim();
        Matrix X = new Matrix(n, n);
        int degrees = m - 1;
        Matrix V = new Matrix(n, n);
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += this.get(k, i);
                    s2 += this.get(k, j);
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (this.get(k, i) - s1) * (this.get(k, j) - s2);
                }
                V.set(i, j, c / (double)degrees);
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                X.set(i, j, V.get(i, j) / Math.sqrt(V.get(i, i) * V.get(j, j)));
            }
        }
        return X;
    }

    public Matrix getDiagonal() {
        int n = Math.min(this.getRowDim(), this.getColDim());
        Matrix ma = new Matrix(n, 1);
        for (int i = 0; i < n; ++i) {
            ma.set(i, 0, this.data[i][i]);
        }
        return ma;
    }

    public Matrix getLinedCol() {
        Matrix ma = new Matrix(this.getNumElements(), 1);
        int ind = 0;
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                ma.data[ind][0] = this.data[i][j];
                ++ind;
            }
        }
        return ma;
    }

    public List<Double> getList() {
        ArrayList<Double> li = new ArrayList<Double>(this.getRowDim() * this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                li.add(this.data[i][j]);
            }
        }
        return li;
    }

    public Matrix getMatrix(int i0, int i1, int j0, int j1) {
        Matrix X = new Matrix(i1 - i0 + 1, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    B[i - i0][j - j0] = this.data[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int[] r, int[] c) {
        Matrix X = new Matrix(r.length, c.length);
        double[][] B = X.getArray();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    B[i][j] = this.data[r[i]][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int i0, int i1, int[] c) {
        Matrix X = new Matrix(i1 - i0 + 1, c.length);
        double[][] B = X.getArray();
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    B[i - i0][j] = this.data[i][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int[] r, int j0, int j1) {
        Matrix X = new Matrix(r.length, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    B[i][j - j0] = this.data[r[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public int getNumElements() {
        return this.cols() * this.rows();
    }

    public int getNumElementsLarger(double val2Compare) {
        int ind = 0;
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                if (!(this.data[i][j] > val2Compare)) continue;
                ++ind;
            }
        }
        return ind;
    }

    public int getNumElementsEqual(double val2Compare) {
        int ind = 0;
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                if (this.data[i][j] != val2Compare) continue;
                ++ind;
            }
        }
        return ind;
    }

    public Matrix log() {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                maResult.data[i][j] = this.data[i][j] > 0.0 ? Math.log(this.data[i][j]) : 0.0;
            }
        }
        return maResult;
    }

    public Matrix diagonalize() {
        Matrix maResult;
        block3: {
            block2: {
                maResult = new Matrix();
                if (this.getRowDim() <= 1 || this.cols() != 1) break block2;
                maResult.resize(this.rows(), this.rows());
                for (int i = 0; i < maResult.rows(); ++i) {
                    maResult.data[i][i] = this.data[i][0];
                }
                break block3;
            }
            if (this.cols() <= 1 || this.rows() != 1) break block3;
            maResult.resize(this.cols(), this.cols());
            for (int i = 0; i < maResult.cols(); ++i) {
                maResult.data[i][i] = this.data[0][i];
            }
        }
        return maResult;
    }

    public Matrix devide(double dDivisor) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                maResult.data[i][j] = this.data[i][j] / dDivisor;
            }
        }
        return maResult;
    }

    public Matrix devide(Matrix maDivisor) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                maResult.data[i][j] = this.data[i][j] / maDivisor.data[i][j];
            }
        }
        return maResult;
    }

    public Matrix devideDivisorBigger(Matrix maDivisor) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                maResult.data[i][j] = this.data[i][j] < maDivisor.data[i][j] ? this.data[i][j] / maDivisor.data[i][j] : maDivisor.data[i][j] / this.data[i][j];
            }
        }
        return maResult;
    }

    public Matrix devideCols(Matrix maDivisor) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                maResult.data[i][j] = this.data[i][j] / maDivisor.get(0, j);
            }
        }
        return maResult;
    }

    public void devideRow(int row, double denominator) {
        int j = 0;
        while (j < this.getColDim()) {
            double[] dArray = this.data[row];
            int n = j++;
            dArray[n] = dArray[n] / denominator;
        }
    }

    public static final void getEigenvector(Matrix A, int n, Matrix D, Matrix E) {
        int j;
        double g;
        double f;
        int k;
        int l;
        int i;
        double[] a = A.toArray();
        double[] d = new double[n];
        double[] e = new double[n];
        int cols = n;
        for (i = n - 1; i >= 1; --i) {
            l = i;
            double scale = 0.0;
            double h = 0.0;
            if (l > 0) {
                for (k = 0; k < l; ++k) {
                    scale += Math.abs(a[i * cols + k]);
                }
                if (scale == 0.0) {
                    e[i] = a[i * cols + l - 1];
                } else {
                    for (k = 0; k < l; ++k) {
                        int n2 = i * cols + k;
                        a[n2] = a[n2] / scale;
                        h += a[i * cols + k] * a[i * cols + k];
                    }
                    f = a[i * cols + l - 1];
                    g = f >= 0.0 ? -Math.sqrt(h) : Math.sqrt(h);
                    e[i] = scale * g;
                    h -= f * g;
                    a[i * cols + l - 1] = f - g;
                    f = 0.0;
                    for (j = 0; j < l; ++j) {
                        a[j * cols + i] = a[i * cols + j] / h;
                        g = 0.0;
                        for (k = 0; k < j + 1; ++k) {
                            g += a[j * cols + k] * a[i * cols + k];
                        }
                        for (k = j + 1; k < l; ++k) {
                            g += a[k * cols + j] * a[i * cols + k];
                        }
                        e[j] = g / h;
                        f += e[j] * a[i * cols + j];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j < l; ++j) {
                        f = a[i * cols + j];
                        e[j] = g = e[j] - hh * f;
                        for (k = 0; k < j + 1; ++k) {
                            int n3 = j * cols + k;
                            a[n3] = a[n3] - (f * e[k] + g * a[i * cols + k]);
                        }
                    }
                }
            } else {
                e[i] = a[i * cols + l - 1];
            }
            d[i] = h;
        }
        d[0] = 0.0;
        e[0] = 0.0;
        for (i = 0; i < n; ++i) {
            l = i;
            if (d[i] != 0.0) {
                for (j = 0; j < l; ++j) {
                    g = 0.0;
                    for (k = 0; k < l; ++k) {
                        g += a[i * cols + k] * a[k * cols + j];
                    }
                    for (k = 0; k < l; ++k) {
                        int n4 = k * cols + j;
                        a[n4] = a[n4] - g * a[k * cols + i];
                    }
                }
            }
            d[i] = a[i * cols + i];
            a[i * cols + i] = 1.0;
            for (j = 0; j < l; ++j) {
                a[i * cols + j] = 0.0;
                a[j * cols + i] = 0.0;
            }
        }
        for (i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[n - 1] = 0.0;
        for (l = 0; l < n; ++l) {
            int m;
            int iter = 0;
            do {
                for (m = l; m <= n - 2; ++m) {
                    double dd = Math.abs(d[m]) + Math.abs(d[m + 1]);
                    if (Math.abs(e[m]) + dd == dd) break;
                }
                if (m == l) continue;
                if (iter++ == 30) {
                    System.err.println("Too many iterations in tqli");
                }
                g = (d[l + 1] - d[l]) / (2.0 * e[l]);
                double r = Matrix.getPythag(g, 1.0);
                g = d[m] - d[l] + e[l] / (g + Matrix.Sign(r, g));
                double c = 1.0;
                double s = 1.0;
                double p = 0.0;
                for (i = m - 1; i >= l; --i) {
                    f = s * e[i];
                    double b = c * e[i];
                    e[i + 1] = r = Matrix.getPythag(f, g);
                    if (r == 0.0) {
                        int n5 = i + 1;
                        d[n5] = d[n5] - p;
                        e[m] = 0.0;
                        break;
                    }
                    s = f / r;
                    c = g / r;
                    g = d[i + 1] - p;
                    r = (d[i] - g) * s + 2.0 * c * b;
                    p = s * r;
                    d[i + 1] = g + p;
                    g = c * r - b;
                    for (k = 0; k < n; ++k) {
                        f = a[k * cols + i + 1];
                        a[k * cols + i + 1] = s * a[k * cols + i] + c * f;
                        a[k * cols + i] = c * a[k * cols + i] - s * f;
                    }
                }
                if (r == 0.0 && i >= l) continue;
                int n6 = l;
                d[n6] = d[n6] - p;
                e[l] = g;
                e[m] = 0.0;
            } while (m != l);
        }
        for (int o = 0; o < A.rows(); ++o) {
            for (int q = 0; q < A.cols(); ++q) {
                A.set(o, q, a[o * n + q]);
            }
        }
        D.resize(n, 1);
        D.setCol(0, d);
        E.resize(n, 1);
        E.setCol(0, e);
    }

    public double getMinRow(int row) {
        double val = Double.MAX_VALUE;
        for (int i = 0; i < this.getColDim(); ++i) {
            if (!(this.data[row][i] < val)) continue;
            val = this.data[row][i];
        }
        return val;
    }

    public int getMinRowIndex(int row) {
        int index = 0;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.getColDim(); ++i) {
            if (!(this.data[row][i] < min)) continue;
            min = this.data[row][i];
            index = i;
        }
        return index;
    }

    public int getMinRowIndexRND(int row) {
        int indexMin = 0;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.getColDim(); ++i) {
            list.add(new Integer(i));
        }
        Collections.shuffle(list);
        int[] arrIndex = new int[this.getColDim()];
        for (int i = 0; i < arrIndex.length; ++i) {
            arrIndex[i] = (Integer)list.get(i);
        }
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.getColDim(); ++i) {
            int ind = arrIndex[i];
            if (!(this.data[row][ind] < min)) continue;
            min = this.data[row][ind];
            indexMin = ind;
        }
        return indexMin;
    }

    public int getID() {
        return this.identifier;
    }

    public double getEuclideanDistanceFastRows(int iRow, Matrix A, int iRowA) {
        double distance = 0.0;
        int cols = this.cols();
        for (int i = 0; i < cols; ++i) {
            distance += (this.data[iRow][i] - A.data[iRowA][i]) * (this.data[iRow][i] - A.data[iRowA][i]);
        }
        return distance;
    }

    public double getEuclideanDistanceFastRows(int row1, int row2) {
        double distance = 0.0;
        int cols = this.cols();
        for (int i = 0; i < cols; ++i) {
            distance += (this.data[row1][i] - this.data[row2][i]) * (this.data[row1][i] - this.data[row2][i]);
        }
        return distance;
    }

    public double getMaximumValue() {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                if (!(max < this.data[i][j])) continue;
                max = this.data[i][j];
            }
        }
        return max;
    }

    public double getMean() {
        int cols = this.getColDim();
        int rows = this.getRowDim();
        double mean = this.getSum() / (double)(cols * rows);
        return mean;
    }

    public Matrix getMeanCols() {
        int i;
        int cols = this.cols();
        int rows = this.rows();
        double[] a = new double[cols];
        for (i = 0; i < rows; ++i) {
            double[] arrRow = this.data[i];
            for (int j = 0; j < arrRow.length; ++j) {
                int n = j;
                a[n] = a[n] + arrRow[j];
            }
        }
        i = 0;
        while (i < cols) {
            int n = i++;
            a[n] = a[n] / (double)rows;
        }
        return new Matrix(true, a);
    }

    public Matrix getMeanCols(int[] rowIndex) {
        Matrix ma = new Matrix(1, this.getColDim());
        int cols = this.getColDim();
        for (int j = 0; j < cols; ++j) {
            ma.data[0][j] = this.getMeanCol(j, rowIndex);
        }
        return ma;
    }

    public double getMeanCol(int col) {
        int rows = this.rows();
        double sum = 0.0;
        for (int i = 0; i < rows; ++i) {
            sum += this.data[i][col];
        }
        return sum / (double)rows;
    }

    public double getMeanRow(int row) {
        int iCols = this.getColDim();
        double dMean = 0.0;
        for (int i = 0; i < iCols; ++i) {
            dMean += this.data[row][i];
        }
        return dMean / (double)iCols;
    }

    public Matrix getMeanRows() {
        Matrix ma = new Matrix(1, this.getRowDim());
        int iRows = this.getRowDim();
        for (int i = 0; i < iRows; ++i) {
            ma.set(0, i, this.getMeanRow(i));
        }
        return ma;
    }

    public double getMeanCol(int iColIndex, int[] rowIndex) {
        int iRows = this.getRowDim();
        double dMean = 0.0;
        for (int ii = 0; ii < rowIndex.length; ++ii) {
            dMean += this.data[rowIndex[ii]][iColIndex];
        }
        return dMean / (double)iRows;
    }

    public double getMedian(int row) {
        double[] arr = this.getRowCopy(row);
        Arrays.sort(arr);
        double median = 0.0;
        int len = arr.length;
        if (len % 2 != 0) {
            median = arr[len / 2];
        } else {
            int ind = (int)((double)len / 2.0 + 0.5);
            median = (arr[ind] + arr[ind - 1]) / 2.0;
        }
        return median;
    }

    public double getMedian() {
        int nRows = this.rows();
        int nCols = this.cols();
        double[] arr = new double[nRows * nCols];
        int k = 0;
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                arr[k++] = this.get(i, j);
            }
        }
        Arrays.sort(arr);
        double median = 0.0;
        int len = arr.length;
        if (len % 2 != 0) {
            median = arr[len / 2];
        } else {
            int ind = (int)((double)len / 2.0 + 0.5);
            median = (arr[ind] + arr[ind - 1]) / 2.0;
        }
        return median;
    }

    public Matrix getMedianCols() {
        Matrix maMedian = new Matrix(1, this.cols());
        int rows = this.rows();
        int cols = this.cols();
        double[] arr = new double[rows];
        for (int i = 0; i < cols; ++i) {
            for (int j = 0; j < rows; ++j) {
                arr[j] = this.get(j, i);
            }
            Arrays.sort(arr);
            double median = 0.0;
            int len = arr.length;
            if (len % 2 != 0) {
                median = arr[len / 2];
            } else {
                int ind = (int)((double)len / 2.0 + 0.5);
                median = (arr[ind] + arr[ind - 1]) / 2.0;
            }
            maMedian.set(0, i, median);
        }
        return maMedian;
    }

    public Matrix getMergeRows(Matrix ma) {
        Matrix maMerge = new Matrix(this.getRowDim() + ma.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                maMerge.data[i][j] = this.data[i][j];
            }
        }
        int iRow = this.getRowDim();
        for (int ii = 0; ii < ma.getRowDim(); ++ii) {
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                maMerge.data[iRow + ii][jj] = ma.data[ii][jj];
            }
        }
        return maMerge;
    }

    public Matrix getMaxMin() {
        Matrix maMaxMin = new Matrix(2, this.getColDim());
        int cols = this.getColDim();
        for (int i = 0; i < cols; ++i) {
            maMaxMin.set(1, i, this.getMin(i));
            maMaxMin.set(0, i, this.getMax(i));
        }
        return maMaxMin;
    }

    public double getMax() {
        int rows = this.getRowDim();
        int cols = this.getColDim();
        double dMax = -1.7976931348623157E308;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (!(this.data[i][j] > dMax)) continue;
                dMax = this.data[i][j];
            }
        }
        return dMax;
    }

    public double getMax(int col) {
        int iRows = this.getRowDim();
        double max = -1.7976931348623157E308;
        for (int i = 0; i < iRows; ++i) {
            if (!(this.data[i][col] > max)) continue;
            max = this.data[i][col];
        }
        return max;
    }

    public Point getMaxIndex() {
        Point p = new Point(0, 0);
        int rows = this.rows();
        int cols = this.cols();
        double max = this.data[0][0];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (!(this.data[i][j] > max)) continue;
                max = this.data[i][j];
                p.y = i;
                p.x = j;
            }
        }
        return p;
    }

    public double getMaxRow(int row) {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.getColDim(); ++i) {
            if (!(this.data[row][i] > max)) continue;
            max = this.data[row][i];
        }
        return max;
    }

    public int getMaxRowIndexRND(int row) {
        int indexMax = 0;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.cols(); ++i) {
            list.add(i);
        }
        Collections.shuffle(list);
        int[] arrIndex = new int[this.getColDim()];
        for (int i = 0; i < arrIndex.length; ++i) {
            arrIndex[i] = (Integer)list.get(i);
        }
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.getColDim(); ++i) {
            int ind = arrIndex[i];
            if (!(this.data[row][ind] > max)) continue;
            max = this.data[row][ind];
            indexMax = ind;
        }
        return indexMax;
    }

    public int getMaxRowIndex(int col) {
        int row = -1;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.rows(); ++i) {
            if (!(this.data[i][col] > max)) continue;
            max = this.data[i][col];
            row = i;
        }
        return row;
    }

    public double getMin() {
        int rows = this.getRowDim();
        int cols = this.getColDim();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (!(this.data[i][j] < min)) continue;
                min = this.data[i][j];
            }
        }
        return min;
    }

    public ScorePoint getMinPos() {
        int rows = this.getRowDim();
        int cols = this.getColDim();
        ScorePoint td = new ScorePoint();
        td.setScore(Double.MAX_VALUE);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (!(this.data[i][j] < td.getScore())) continue;
                td.y = i;
                td.x = j;
                td.setScore(this.data[i][j]);
            }
        }
        return td;
    }

    public Matrix getMinRows() {
        int rows = this.getRowDim();
        int cols = this.getColDim();
        Matrix ma = new Matrix(rows, 1);
        for (int i = 0; i < rows; ++i) {
            double dMin = Double.MAX_VALUE;
            for (int j = 0; j < cols; ++j) {
                if (!(this.data[i][j] < dMin)) continue;
                dMin = this.data[i][j];
            }
            ma.set(i, 0, dMin);
        }
        return ma;
    }

    public Matrix getMinRowsPosCol() {
        int rows = this.getRowDim();
        int cols = this.getColDim();
        Matrix ma = new Matrix(rows, 2);
        for (int i = 0; i < rows; ++i) {
            double dMin = Double.MAX_VALUE;
            for (int j = 0; j < cols; ++j) {
                if (!(this.data[i][j] < dMin)) continue;
                ma.set(i, 0, j);
                ma.set(i, 1, this.data[i][j]);
            }
        }
        return ma;
    }

    public double getMin(int col) {
        int rows = this.getRowDim();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < rows; ++i) {
            if (!(this.data[i][col] < min)) continue;
            min = this.data[i][col];
        }
        return min;
    }

    public int getMinColIndex(int row) {
        int cols = this.getColDim();
        double min = Double.MAX_VALUE;
        int ind = -1;
        for (int i = 0; i < cols; ++i) {
            if (!(this.data[row][i] < min)) continue;
            min = this.data[row][i];
            ind = i;
        }
        return ind;
    }

    public int getColIndexContainingMaxVal(int row) {
        int cols = this.getColDim();
        double max = -1.7976931348623157E308;
        int col = -1;
        for (int i = 0; i < cols; ++i) {
            if (!(this.data[row][i] > max)) continue;
            max = this.data[row][i];
            col = i;
        }
        return col;
    }

    public ScorePoint getColIndexContainingMaxVal(int rowEnd, int colEnd) {
        int cols = colEnd;
        int rows = rowEnd;
        double max = -1.7976931348623157E308;
        int rowMax = -1;
        int colMax = -1;
        for (int i = 0; i < cols; ++i) {
            double maxInCol = -1.7976931348623157E308;
            int rowMaxInCol = -1;
            for (int j = 0; j < rows; ++j) {
                if (!(this.data[j][i] > maxInCol)) continue;
                maxInCol = this.data[j][i];
                rowMaxInCol = j;
            }
            if (!(maxInCol > max)) continue;
            max = maxInCol;
            rowMax = rowMaxInCol;
            colMax = i;
        }
        ScorePoint sc = new ScorePoint(rowMax, colMax);
        sc.setScore(max);
        return sc;
    }

    public Matrix getNormalizedMatrix() {
        int iRows = this.getRowDim();
        int iCols = this.getColDim();
        Matrix maNorm = new Matrix(iRows, iCols);
        Matrix maStandardDeviation = this.getStandardDeviationCols();
        for (int ii = 0; ii < iRows; ++ii) {
            for (int jj = 0; jj < iCols; ++jj) {
                double dStandardDeviation = maStandardDeviation.get(0, jj);
                if (dStandardDeviation == 0.0) {
                    dStandardDeviation = 1.4E-45f;
                }
                double dVal = this.get(ii, jj) / dStandardDeviation;
                maNorm.set(ii, jj, dVal);
            }
        }
        return maNorm;
    }

    public Matrix getNormalizedMatrix(Matrix maStandardDeviation) {
        int iRows = this.getRowDim();
        int iCols = this.getColDim();
        Matrix maNorm = new Matrix(iRows, iCols);
        for (int ii = 0; ii < iRows; ++ii) {
            for (int jj = 0; jj < iCols; ++jj) {
                double dStandardDeviation = maStandardDeviation.get(0, jj);
                if (dStandardDeviation == 0.0) {
                    dStandardDeviation = 1.4E-45f;
                }
                double dVal = this.get(ii, jj) / dStandardDeviation;
                maNorm.set(ii, jj, dVal);
            }
        }
        return maNorm;
    }

    public double[] getUpperTriangle() {
        int c;
        int r = this.rows();
        if (r != (c = this.cols())) {
            throw new RuntimeException("Not a quadratic matrix.");
        }
        int n = (r * r - r) / 2;
        double[] a = new double[n];
        int cc = 0;
        for (int i = 0; i < r; ++i) {
            for (int j = i + 1; j < r; ++j) {
                a[cc++] = this.get(i, j);
            }
        }
        return a;
    }

    public static double getPythag(double a, double b) {
        double absb;
        double absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            double dScale = absb / absa * (absb / absa);
            return absa * Math.sqrt(1.0 + dScale);
        }
        if (absb == 0.0) {
            return 0.0;
        }
        double dScale = absa / absb * (absa / absb);
        return absb * Math.sqrt(1.0 + dScale);
    }

    public static double getPythag2(double a, double b) {
        return Math.sqrt(a * a + b * b);
    }

    public boolean areRowsEqual(int row1, int row2) {
        boolean equal = true;
        int cols = this.cols();
        for (int i = 0; i < cols; ++i) {
            double diff = Math.abs(this.data[row1][i] - this.data[row2][i]);
            if (!(diff > 1.0E-11)) continue;
            equal = false;
            break;
        }
        return equal;
    }

    public boolean equal(Matrix ma) {
        boolean bEQ = true;
        if (this.equalDimension(ma)) {
            block0: for (int i = 0; i < this.getRowDim(); ++i) {
                for (int j = 0; j < this.getColDim(); ++j) {
                    if (this.data[i][j] == ma.data[i][j]) continue;
                    bEQ = false;
                    continue block0;
                }
            }
        } else {
            bEQ = false;
        }
        return bEQ;
    }

    public boolean equal(Matrix ma, double dLimit) {
        boolean bEQ = true;
        if (this.equalDimension(ma)) {
            block0: for (int i = 0; i < this.getRowDim(); ++i) {
                for (int j = 0; j < this.getColDim(); ++j) {
                    double dDiff = Math.abs(this.data[i][j] - ma.data[i][j]);
                    if (!(dDiff > dLimit)) continue;
                    bEQ = false;
                    continue block0;
                }
            }
        } else {
            bEQ = false;
        }
        return bEQ;
    }

    public boolean equalDimension(Matrix ma) {
        boolean bEqual = false;
        if (this.getColDim() == ma.getColDim() && this.getRowDim() == ma.getRowDim()) {
            bEqual = true;
        }
        return bEqual;
    }

    public boolean hasOnlyFinite() {
        boolean finite = true;
        int r = this.rows();
        int c = this.cols();
        block0: for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                if (Double.isFinite(this.data[i][j])) continue;
                finite = false;
                break block0;
            }
        }
        return finite;
    }

    public Matrix multiplyValByVal(Matrix ma) {
        Matrix maProd = new Matrix(this.rows(), this.cols());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                maProd.set(i, j, this.get(i, j) * ma.get(i, j));
            }
        }
        return maProd;
    }

    public Matrix multCols(Matrix maMuiltiplicant) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                maResult.data[i][j] = this.data[i][j] * maMuiltiplicant.get(0, j);
            }
        }
        return maResult;
    }

    public Matrix multiply(double dScalar) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                maResult.data[i][j] = this.data[i][j] * dScalar;
            }
        }
        return maResult;
    }

    public Matrix multiply(Matrix ma) {
        return this.multiply(false, false, ma);
    }

    public double multiply(int row1, Matrix ma2, int row2) {
        double sum = 0.0;
        for (int ii = 0; ii < this.getColDim(); ++ii) {
            sum += this.data[row1][ii] * ma2.data[row2][ii];
        }
        return sum;
    }

    public final Matrix multiply(boolean transA, boolean transB, Matrix ma) {
        int maRows;
        Matrix Atrans;
        double[] Bcolj;
        double s4;
        double s3;
        double s2;
        double s1;
        int j;
        double[][] C;
        int maCols;
        int m;
        int n;
        Matrix maResult = null;
        if (!transA && !transB) {
            n = this.cols();
            m = this.rows();
            maCols = ma.cols();
            if (n != ma.rows()) {
                throw new RuntimeException("Error in Routine Matrix.multiply(...). Attempt to calculate the product of two incompatible matrices. Do nothing and return.");
            }
            maResult = new Matrix(this.rows(), ma.cols());
            C = maResult.getArray();
            Matrix Btrans = ma.getTranspose();
            double[][] bTrans = Btrans.getArray();
            double[] Bcolj2 = null;
            double[] Arowi = null;
            int c4 = n / 4 * 4;
            for (j = 0; j < maCols; ++j) {
                Bcolj2 = bTrans[j];
                for (int i = 0; i < m; ++i) {
                    int k;
                    Arowi = this.data[i];
                    double s = 0.0;
                    for (k = 0; k < c4; k += 4) {
                        s1 = Arowi[k] * Bcolj2[k];
                        s2 = Arowi[k + 1] * Bcolj2[k + 1];
                        s3 = Arowi[k + 2] * Bcolj2[k + 2];
                        s4 = Arowi[k + 3] * Bcolj2[k + 3];
                        s += s1 + s2 + s3 + s4;
                    }
                    for (k = c4; k < n; ++k) {
                        s += Arowi[k] * Bcolj2[k];
                    }
                    C[i][j] = s;
                }
            }
        }
        if (transA && !transB) {
            n = this.rows();
            m = this.cols();
            maCols = ma.cols();
            if (n != ma.rows()) {
                throw new RuntimeException("Error in Routine SMatrix::Mult(). Attempt to calculate the product of two incompatible matrices. Do nothing and return.");
            }
            maResult = new Matrix(this.cols(), ma.cols());
            C = maResult.getArray();
            Bcolj = null;
            int c4 = n / 4 * 4;
            Atrans = this.getTranspose();
            double[][] aTrans = Atrans.getArray();
            Matrix Btrans = ma.getTranspose();
            double[][] bTrans = Btrans.getArray();
            double[] Arowi = null;
            for (int j2 = 0; j2 < maCols; ++j2) {
                Bcolj = bTrans[j2];
                for (int i = 0; i < m; ++i) {
                    int k;
                    Arowi = aTrans[i];
                    double s = 0.0;
                    for (k = 0; k < c4; k += 4) {
                        double s12 = Arowi[k] * Bcolj[k];
                        double s22 = Arowi[k + 1] * Bcolj[k + 1];
                        double s32 = Arowi[k + 2] * Bcolj[k + 2];
                        double s42 = Arowi[k + 3] * Bcolj[k + 3];
                        s += s12 + s22 + s32 + s42;
                    }
                    for (k = c4; k < n; ++k) {
                        s += Arowi[k] * Bcolj[k];
                    }
                    C[i][j2] = s;
                }
            }
        }
        if (!transA && transB) {
            n = this.cols();
            m = this.rows();
            maRows = ma.rows();
            if (n != ma.cols()) {
                throw new RuntimeException("Error in Routine SMatrix::Mult(). Attempt to calculate the product of two incompatible matrices. Do nothing and return.");
            }
            maResult = new Matrix(this.rows(), maRows);
            C = maResult.getArray();
            Bcolj = null;
            int c4 = n / 4 * 4;
            double[] Arowi = null;
            for (int j3 = 0; j3 < maRows; ++j3) {
                Bcolj = ma.data[j3];
                for (int i = 0; i < m; ++i) {
                    int k;
                    Arowi = this.data[i];
                    double s = 0.0;
                    for (k = 0; k < c4; k += 4) {
                        double s13 = Arowi[k] * Bcolj[k];
                        double s23 = Arowi[k + 1] * Bcolj[k + 1];
                        double s33 = Arowi[k + 2] * Bcolj[k + 2];
                        double s43 = Arowi[k + 3] * Bcolj[k + 3];
                        s += s13 + s23 + s33 + s43;
                    }
                    for (k = c4; k < n; ++k) {
                        s += Arowi[k] * Bcolj[k];
                    }
                    C[i][j3] = s;
                }
            }
        }
        if (transA && transB) {
            n = this.rows();
            m = this.cols();
            maRows = ma.rows();
            if (n != ma.cols()) {
                throw new RuntimeException("Error in Routine SMatrix::Mult(). Attempt to calculate the product of two incompatible matrices. Do nothing and return.");
            }
            maResult = new Matrix(this.cols(), maRows);
            C = maResult.getArray();
            Bcolj = null;
            int c4 = n / 4 * 4;
            Atrans = this.getTranspose();
            double[][] aTrans = Atrans.getArray();
            double[] Arowi = null;
            for (j = 0; j < maRows; ++j) {
                Bcolj = ma.data[j];
                for (int i = 0; i < m; ++i) {
                    int k;
                    Arowi = aTrans[i];
                    double s = 0.0;
                    for (k = 0; k < c4; k += 4) {
                        s1 = Arowi[k] * Bcolj[k];
                        s2 = Arowi[k + 1] * Bcolj[k + 1];
                        s3 = Arowi[k + 2] * Bcolj[k + 2];
                        s4 = Arowi[k + 3] * Bcolj[k + 3];
                        s += s1 + s2 + s3 + s4;
                    }
                    for (k = c4; k < n; ++k) {
                        s += Arowi[k] * Bcolj[k];
                    }
                    C[i][j] = s;
                }
            }
        }
        return maResult;
    }

    public static Matrix getParsed(Vector<String> vecStringMatrix) throws Exception {
        int ii;
        Matrix ma = new Matrix();
        String sRow = vecStringMatrix.get(0);
        int iLen = 0;
        double[] dArr = String2DoubleArray.convert(sRow);
        iLen = dArr.length;
        ma.resize(vecStringMatrix.size(), dArr.length);
        for (ii = 0; ii < dArr.length; ++ii) {
            ma.set(0, ii, dArr[ii]);
        }
        for (ii = 1; ii < vecStringMatrix.size(); ++ii) {
            sRow = vecStringMatrix.get(ii);
            dArr = String2DoubleArray.convert(sRow);
            if (iLen != dArr.length) {
                System.err.println("Vectors for matrix generation differ in length");
                new RuntimeException().printStackTrace();
                break;
            }
            for (int jj = 0; jj < dArr.length; ++jj) {
                ma.set(ii, jj, dArr[jj]);
            }
        }
        return ma;
    }

    public Matrix plus(Matrix ma) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        if (!this.equalDimension(ma)) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        for (int ii = 0; ii < this.getRowDim(); ++ii) {
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                maResult.data[ii][jj] = this.data[ii][jj] + ma.data[ii][jj];
            }
        }
        return maResult;
    }

    public Matrix pow(double exp) {
        Matrix ma = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                ma.data[i][j] = Math.pow(this.data[i][j], exp);
            }
        }
        return ma;
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public void resize(int rowsNew, int colsNew) {
        double[] a;
        int i;
        double[][] arrTmp = new double[rowsNew][];
        int rowsMin = Math.min(this.rows(), rowsNew);
        int colsMin = Math.min(this.cols(), colsNew);
        for (i = 0; i < rowsMin; ++i) {
            a = new double[colsNew];
            System.arraycopy(this.data[i], 0, a, 0, colsMin);
            arrTmp[i] = a;
        }
        for (i = rowsMin; i < rowsNew; ++i) {
            a = new double[colsNew];
            arrTmp[i] = a;
        }
        this.data = arrTmp;
    }

    public double[] getRow(int row) {
        return this.data[row];
    }

    public double[] getRowCopy(int row) {
        double[] arr = new double[this.data[0].length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.data[row][i];
        }
        return arr;
    }

    public List<Double> getRowAsList(int row) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (int ii = 0; ii < this.data[0].length; ++ii) {
            list.add(new Double(this.data[row][ii]));
        }
        return list;
    }

    public float[] getRowAsFloat(int row) {
        float[] arr = new float[this.data[0].length];
        for (int i = 0; i < this.data[0].length; ++i) {
            arr[i] = (float)this.data[row][i];
        }
        return arr;
    }

    public int getRowDim() {
        return this.data.length;
    }

    public int rows() {
        return this.data.length;
    }

    public Matrix getSorted() {
        int i;
        Matrix ma = new Matrix(this.getRowDim(), this.getColDim());
        ArrayList<DoubleVec> list = new ArrayList<DoubleVec>();
        for (i = 0; i < this.data.length; ++i) {
            list.add(new DoubleVec(this.data[i]));
        }
        Collections.sort(list);
        for (i = 0; i < this.data.length; ++i) {
            ma.assignRow(i, (DoubleVec)list.get(i));
        }
        return ma;
    }

    public Matrix getSQRT() {
        Matrix ma = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                ma.data[i][j] = Math.sqrt(this.data[i][j]);
            }
        }
        return ma;
    }

    public double getSquaredSum() {
        double s = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                s += this.data[i][j] * this.data[i][j];
            }
        }
        return s;
    }

    public Matrix getStandardDeviationCols() {
        int i;
        Matrix maMean = this.getMeanCols();
        double[] arrMeanCols = maMean.getRow(0);
        int cols = this.cols();
        int rows = this.rows();
        double[] arrStdvCols = new double[cols];
        for (i = 0; i < rows; ++i) {
            double[] arrRow = this.data[i];
            for (int j = 0; j < cols; ++j) {
                int n = j;
                arrStdvCols[n] = arrStdvCols[n] + (arrRow[j] - arrMeanCols[j]) * (arrRow[j] - arrMeanCols[j]);
            }
        }
        for (i = 0; i < cols; ++i) {
            double sdv;
            arrStdvCols[i] = sdv = Math.sqrt(arrStdvCols[i] / (double)(rows - 1));
        }
        return new Matrix(true, arrStdvCols);
    }

    public double getStandardDeviation() {
        double sdv = 0.0;
        double n = this.rows() * this.cols();
        double mean = this.getMean();
        double sum = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                sum += (this.data[i][j] - mean) * (this.data[i][j] - mean);
            }
        }
        sdv = Math.sqrt(sum / (n - 1.0));
        return sdv;
    }

    public double getVariance() {
        double var = 0.0;
        double mean = this.getMean();
        double sum = 0.0;
        for (int j = 0; j < this.data[0].length; ++j) {
            for (int i = 0; i < this.data.length; ++i) {
                sum += (this.data[i][j] - mean) * (this.data[i][j] - mean);
            }
        }
        var = sum / (double)(this.getNumElements() - 1);
        return var;
    }

    public double getCoefficientVariation() {
        double mean = this.getMean();
        double sum = 0.0;
        for (int j = 0; j < this.data[0].length; ++j) {
            for (int i = 0; i < this.data.length; ++i) {
                sum += (this.data[i][j] - mean) * (this.data[i][j] - mean);
            }
        }
        double var = sum / (double)(this.getNumElements() - 1);
        double sdv = Math.sqrt(var);
        double varCoeff = sdv / mean;
        return varCoeff;
    }

    public double getVarianceCol(int col) {
        double var = 0.0;
        double mean = this.getMeanCol(col);
        double dSum = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            dSum += (this.data[i][col] - mean) * (this.data[i][col] - mean);
        }
        var = dSum / ((double)this.data.length - 1.0);
        return var;
    }

    public double getVarianceCentered() {
        double var = 0.0;
        double sum = 0.0;
        for (int j = 0; j < this.data[0].length; ++j) {
            for (int i = 0; i < this.data.length; ++i) {
                sum += this.data[i][j] * this.data[i][j];
            }
        }
        var = sum / (double)(this.getNumElements() - 1);
        return var;
    }

    public Matrix getVarianceCols() {
        Matrix ma = new Matrix(1, this.getColDim());
        Matrix maMean = this.getMeanCols();
        for (int j = 0; j < this.data[0].length; ++j) {
            double dVariance;
            double sum = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                sum += (this.data[i][j] - maMean.data[0][j]) * (this.data[i][j] - maMean.data[0][j]);
            }
            ma.data[0][j] = dVariance = sum / (double)(this.getRowDim() - 1);
        }
        return ma;
    }

    public void increase(int row, int col, double v) {
        double[] dArray = this.data[row];
        int n = col;
        dArray[n] = dArray[n] + v;
    }

    public final void set(int row, int col, double v) {
        this.data[row][col] = v;
    }

    public void set(Matrix ma) {
        this.resize(ma.getRowDim(), ma.getColDim());
        for (int ii = 0; ii < this.data.length; ++ii) {
            for (int jj = 0; jj < this.data[0].length; ++jj) {
                this.data[ii][jj] = ma.data[ii][jj];
            }
        }
    }

    public void set(double[][] arr) {
        this.resize(arr.length, arr[0].length);
        for (int ii = 0; ii < this.data.length; ++ii) {
            for (int jj = 0; jj < this.data[0].length; ++jj) {
                this.data[ii][jj] = arr[ii][jj];
            }
        }
    }

    public void setFlat(double[][] arr) {
        this.data = arr;
    }

    public void set(double v) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                this.data[i][j] = v;
            }
        }
    }

    public void setID(int id) {
        this.identifier = id;
    }

    public void setCol(int col, double v) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][col] = v;
        }
    }

    public void setCol(int col, double[] arr) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][col] = arr[i];
        }
    }

    public void setRow(int iRow, double v) {
        for (int i = 0; i < this.data[0].length; ++i) {
            this.data[iRow][i] = v;
        }
    }

    public void setRow(int iRow, double[] arr) {
        for (int i = 0; i < this.data[0].length; ++i) {
            this.data[iRow][i] = arr[i];
        }
    }

    public void setRow(int iRow, int[] arr) {
        for (int i = 0; i < this.data[0].length; ++i) {
            this.data[iRow][i] = arr[i];
        }
    }

    public static void setSeparatorCol(String s) {
        OUT_SEPARATOR_COL = s;
    }

    public static void setSeparatorRow(String s) {
        OUT_SEPARATOR_ROW = s;
    }

    public void shuffleRows() {
        int r;
        Random rnd = new Random();
        for (int i = r = this.rows(); i > 1; --i) {
            this.swapRows(i, rnd.nextInt(i));
        }
    }

    public void swapRows(int a, int b) {
        double[] t = this.data[a];
        this.data[a] = this.data[b];
        this.data[b] = t;
    }

    public void sortRows(int col) {
        int r = this.rows();
        ArrayList<IntegerDouble> li = new ArrayList<IntegerDouble>(r);
        for (int i = 0; i < r; ++i) {
            li.add(new IntegerDouble(i, this.get(i, col)));
        }
        Collections.sort(li, IntegerDouble.getComparatorDouble());
        double[][] dataSorted = new double[r][];
        for (int i = 0; i < r; ++i) {
            dataSorted[i] = this.data[((IntegerDouble)li.get(i)).getInt()];
        }
        this.data = dataSorted;
    }

    public Matrix getStandardized() {
        Matrix ma = new Matrix(this.getRowDim(), this.getColDim());
        Matrix maStandardDeviation = this.getStandardDeviationCols();
        Matrix Xc = this.getCenteredMatrix();
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                ma.data[i][j] = Xc.data[i][j] / maStandardDeviation.data[0][j];
            }
        }
        return ma;
    }

    public Matrix getSubMatrix(int indexRowStart, int indexRowEnd, int indexColStart, int indexColEnd) {
        int rows = indexRowEnd - indexRowStart + 1;
        int cols = indexColEnd - indexColStart + 1;
        Matrix ma = new Matrix();
        double[][] arr = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(this.data[indexRowStart + i], indexColStart, arr[i], 0, cols);
        }
        ma.data = arr;
        return ma;
    }

    public Matrix getSubMatrix(List<Integer> liIndexRow) {
        int cols = this.cols();
        Matrix ma = new Matrix();
        double[][] arr = new double[liIndexRow.size()][cols];
        int row = 0;
        for (int i = 0; i < liIndexRow.size(); ++i) {
            System.arraycopy(this.data[liIndexRow.get(i)], 0, arr[row], 0, cols);
            ++row;
        }
        ma.data = arr;
        return ma;
    }

    public double getSum() {
        double sum = 0.0;
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                sum += this.data[i][j];
            }
        }
        return sum;
    }

    public double getSumUpperTriangle() {
        if (this.rows() != this.cols()) {
            throw new RuntimeException("Not a quadratic matrix.");
        }
        int rows = this.cols();
        double sum = 0.0;
        for (int i = 0; i < rows; ++i) {
            for (int j = i + 1; j < rows; ++j) {
                if (Double.isNaN(this.get(i, j))) continue;
                sum += this.get(i, j);
            }
        }
        return sum;
    }

    public Matrix getSumCols() {
        Matrix ma = new Matrix(1, this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                double[] dArray = ma.data[0];
                int n = j;
                dArray[n] = dArray[n] + this.data[i][j];
            }
        }
        return ma;
    }

    public Matrix getSumRows() {
        Matrix ma = new Matrix(1, this.getRowDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            ma.set(0, i, this.getSumRow(i));
        }
        return ma;
    }

    public double getSumCol(int col) {
        double sum = 0.0;
        for (int i = 0; i < this.getRowDim(); ++i) {
            sum += this.data[i][col];
        }
        return sum;
    }

    public double getSumRow(int row) {
        double sum = 0.0;
        for (int i = 0; i < this.getColDim(); ++i) {
            sum += this.data[row][i];
        }
        return sum;
    }

    public double getSumSquared() {
        double sum = 0.0;
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                sum += this.data[i][j] * this.data[i][j];
            }
        }
        return sum;
    }

    public double[] getNext4NeighboursTorus(int row, int col) {
        double[] arr = new double[]{this.getTorus(row - 1, col), this.getTorus(row, col - 1), this.getTorus(row, col + 1), this.getTorus(row + 1, col)};
        return arr;
    }

    public double[] getNext8NeighboursTorus(int row, int col) {
        double[] arr = new double[8];
        int cc = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                arr[cc] = this.getTorus(row + i, col + j);
                ++cc;
            }
        }
        return arr;
    }

    public Matrix row2Matrix(int row, int len) {
        Matrix m = new Matrix(this.getColDim() / len, len);
        int r = 0;
        int c = 0;
        for (int i = 0; i < this.getColDim(); ++i) {
            if (i % len == 0 && i > 0) {
                ++r;
                c = 0;
            }
            m.set(r, c, this.get(0, i));
            ++c;
        }
        return m;
    }

    public double getTorus(int row, int col) {
        int torRow;
        int torCol = col;
        for (torRow = row; torRow < 0; torRow += this.getRowDim()) {
        }
        while (torRow >= this.getRowDim()) {
            torRow -= this.getRowDim();
        }
        while (torCol < 0) {
            torCol += this.getColDim();
        }
        while (torCol >= this.getColDim()) {
            torCol -= this.getColDim();
        }
        return this.get(torRow, torCol);
    }

    public double getTrace() {
        double t = 0.0;
        int m = this.getRowDim();
        int n = this.getColDim();
        for (int ii = 0; ii < Math.min(m, n); ++ii) {
            t += this.get(ii, ii);
        }
        return t;
    }

    public Matrix getTranspose() {
        int rows = this.getRowDim();
        int cols = this.getColDim();
        Matrix ma = new Matrix(cols, rows);
        for (int ii = 0; ii < rows; ++ii) {
            for (int jj = 0; jj < cols; ++jj) {
                ma.data[jj][ii] = this.data[ii][jj];
            }
        }
        return ma;
    }

    public Matrix getFlipped() {
        int rows = this.getRowDim();
        int cols = this.getColDim();
        Matrix ma = new Matrix(cols, rows);
        for (int ii = 0; ii < rows; ++ii) {
            for (int jj = 0; jj < cols; ++jj) {
                ma.data[cols - jj - 1][ii] = this.data[ii][jj];
            }
        }
        return ma;
    }

    public Matrix toRow() {
        Matrix m = new Matrix(1, this.getRowDim() * this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                m.set(0, i * this.getColDim() + j, this.get(i, j));
            }
        }
        return m;
    }

    public double[] toArray() {
        int rows = this.rows();
        int cols = this.cols();
        double[] a = new double[rows * cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                a[i * cols + j] = this.get(i, j);
            }
        }
        return a;
    }

    public String toString() {
        int iRequireDigits = 20;
        int len = this.getRowDim() * this.getColDim() * iRequireDigits;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length - 1; ++j) {
                sb.append(this.data[i][j] + OUT_SEPARATOR_COL);
            }
            sb.append(this.data[i][this.data[0].length - 1]);
            if (i >= this.data.length - 1) continue;
            sb.append(OUT_SEPARATOR_ROW);
        }
        return sb.toString();
    }

    public String toStringBinary() {
        int len = this.getRowDim() * this.getColDim();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                if (this.data[i][j] == 0.0) {
                    sb.append(0);
                    continue;
                }
                sb.append(1);
            }
            if (i >= this.data.length - 1) continue;
            sb.append(OUT_SEPARATOR_ROW);
        }
        return sb.toString();
    }

    public String toString(int digits) {
        return this.toString(this.rows(), this.cols(), digits);
    }

    public String toString(int rowEnd, int colEnd, int digits) {
        int iRequireDigits = 20;
        String sFormat = "";
        sFormat = sFormat + "0";
        int iCounter = 0;
        if (digits > 0) {
            sFormat = sFormat + ".";
        }
        while (iCounter < digits) {
            sFormat = sFormat + "0";
            ++iCounter;
        }
        DecimalFormat nf = new DecimalFormat(sFormat);
        int len = this.getRowDim() * this.getColDim() * iRequireDigits;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < rowEnd; ++i) {
            for (int j = 0; j < colEnd; ++j) {
                String sVal = nf.format(this.data[i][j]);
                if (this.data[i][j] == Double.MAX_VALUE) {
                    sVal = "Max";
                }
                sb.append(sVal);
                if (j >= this.data[0].length - 1) continue;
                sb.append(OUT_SEPARATOR_COL);
            }
            if (i >= this.data.length - 1) continue;
            sb.append(OUT_SEPARATOR_ROW);
        }
        return sb.toString();
    }

    public String toStringRow(int row, int iDigits) {
        int iRequireDigits = 20;
        String sFormat = "";
        sFormat = sFormat + "0";
        int iCounter = 0;
        if (iDigits > 0) {
            sFormat = sFormat + ".";
        }
        while (iCounter < iDigits) {
            sFormat = sFormat + "0";
            ++iCounter;
        }
        DecimalFormat nf = new DecimalFormat(sFormat);
        int len = this.getRowDim() * this.getColDim() * iRequireDigits;
        StringBuilder sb = new StringBuilder(len);
        for (int j = 0; j < this.data[0].length; ++j) {
            String sVal = nf.format(this.data[row][j]);
            if (this.data[row][j] == Double.MAX_VALUE) {
                sVal = "Max";
            }
            sb.append(sVal);
            if (j >= this.data[0].length - 1) continue;
            sb.append(OUT_SEPARATOR_COL);
        }
        return sb.toString();
    }

    public String toStringRowNumber(int iDigits, String sSeparatorCol) {
        int iCounter;
        int iRequireDigits = 20;
        String sFormat = "##,";
        for (iCounter = 0; iCounter < iDigits; ++iCounter) {
            sFormat = sFormat + "#";
        }
        sFormat = sFormat + "0.";
        for (iCounter = 0; iCounter < iDigits; ++iCounter) {
            sFormat = sFormat + "0";
        }
        DecimalFormat nf = new DecimalFormat(sFormat);
        int len = this.getRowDim() * this.getColDim() * iRequireDigits;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < this.data.length; ++i) {
            sb.append(i + sSeparatorCol);
            for (int j = 0; j < this.data[0].length - 1; ++j) {
                sb.append(nf.format(this.data[i][j]) + sSeparatorCol);
            }
            sb.append(nf.format(this.data[i][this.data[0].length - 1]));
            if (i >= this.data.length - 1) continue;
            sb.append(OUT_SEPARATOR_ROW);
        }
        return sb.toString();
    }

    public Matrix subtract(Matrix ma) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        if (!this.equalDimension(ma)) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        for (int ii = 0; ii < this.getRowDim(); ++ii) {
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                maResult.data[ii][jj] = this.data[ii][jj] - ma.data[ii][jj];
            }
        }
        return maResult;
    }

    public Matrix subtract(double val) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        for (int ii = 0; ii < this.getRowDim(); ++ii) {
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                maResult.data[ii][jj] = this.data[ii][jj] - val;
            }
        }
        return maResult;
    }

    public Matrix subtractFromCols(Matrix maDivisor) {
        Matrix maResult = new Matrix(this.getRowDim(), this.getColDim());
        for (int ii = 0; ii < this.getRowDim(); ++ii) {
            for (int jj = 0; jj < this.getColDim(); ++jj) {
                maResult.data[ii][jj] = this.data[ii][jj] - maDivisor.get(0, jj);
            }
        }
        return maResult;
    }

    public static double Sign(double a, double b) {
        if (b >= 0.0) {
            return Math.abs(a);
        }
        return -Math.abs(a);
    }

    public static Matrix getRND(int rows, int cols) {
        Matrix ma = new Matrix(rows, cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                ma.set(i, j, Math.random());
            }
        }
        return ma;
    }

    public void write(String sFile, boolean apppend) {
        DecimalFormat df = new DecimalFormat(FORMAT);
        this.write(new File(sFile), df, apppend);
    }

    public void write(String sFile) {
        DecimalFormat df = new DecimalFormat(FORMAT);
        this.write(new File(sFile), df, false);
    }

    public void write(File fiMa) {
        DecimalFormat df = new DecimalFormat(FORMAT);
        this.write(fiMa, df, false);
    }

    public void write(File fiMa, boolean apppend, int digits) throws IOException {
        int iCounter;
        String sFormat = "##,";
        for (iCounter = 0; iCounter < digits; ++iCounter) {
            sFormat = sFormat + "#";
        }
        sFormat = sFormat + "0.";
        for (iCounter = 0; iCounter < digits; ++iCounter) {
            sFormat = sFormat + "0";
        }
        DecimalFormat nf = new DecimalFormat(sFormat);
        this.write(fiMa, nf, apppend);
    }

    public void write(String sFiMa, boolean apppend, int digits) throws IOException {
        this.write(new File(sFiMa), apppend, digits);
    }

    public void write(File fiMa, DecimalFormat nf, boolean apppend) {
        try {
            FileOutputStream os = new FileOutputStream(fiMa, apppend);
            this.write(os, nf);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(OutputStream os) {
        DecimalFormat nf = new DecimalFormat("#.###############");
        this.write(os, nf);
    }

    public String writeAsLineBase64Encoded() {
        DecimalFormat nf = new DecimalFormat("#.###############");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos, nf);
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] arr64 = encoder.encode(baos.toByteArray());
        return new String(arr64);
    }

    public void write(OutputStream os, NumberFormat nf) {
        try {
            for (int i = 0; i < this.data.length; ++i) {
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < this.data[0].length; ++j) {
                    sb.append(nf.format(this.data[i][j]));
                    if (j >= this.data[0].length - 1) continue;
                    sb.append(OUT_SEPARATOR_COL);
                }
                os.write(sb.toString().getBytes());
                if (i >= this.data.length - 1) continue;
                os.write(OUT_SEPARATOR_ROW.getBytes());
            }
            os.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toStringWithColTags(List<String> liColTags, DecimalFormat nf, String separator) {
        int i;
        int i2;
        if (this.cols() != liColTags.size()) {
            throw new RuntimeException("Number of cols and col tags differ.");
        }
        int[] arrWidth = new int[this.cols()];
        for (i2 = 0; i2 < arrWidth.length; ++i2) {
            arrWidth[i2] = liColTags.get(i2).length();
        }
        for (i2 = 0; i2 < arrWidth.length; ++i2) {
            for (int j = 0; j < this.rows(); ++j) {
                arrWidth[i2] = Math.max(arrWidth[i2], nf.format(this.get(j, i2)).length());
            }
        }
        StringBuilder sbAll = new StringBuilder();
        for (i = 0; i < arrWidth.length; ++i) {
            int w = arrWidth[i];
            StringBuilder sb = new StringBuilder(liColTags.get(i));
            int l = w - sb.length();
            for (int j = 0; j < l; ++j) {
                sb.append(" ");
            }
            sbAll.append(sb.toString());
            sbAll.append(" ");
        }
        sbAll.append("\n");
        for (i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < arrWidth.length; ++j) {
                int w = arrWidth[j];
                StringBuilder sb = new StringBuilder(nf.format(this.get(i, j)));
                int l = w - sb.length();
                for (int k = 0; k < l; ++k) {
                    sb.append(" ");
                }
                sbAll.append(sb.toString());
                sbAll.append(" ");
            }
            sbAll.append("\n");
        }
        return sbAll.toString();
    }

    public String toStringWithRowTags(List<String> liRowTags, DecimalFormat nf, String separator) {
        int i;
        int i2;
        if (this.rows() != liRowTags.size()) {
            throw new RuntimeException("Number of rows and row tags differ.");
        }
        int[] arrWidth = new int[this.cols() + 1];
        for (i2 = 0; i2 < liRowTags.size(); ++i2) {
            arrWidth[0] = Math.max(arrWidth[0], liRowTags.get(i2).length());
        }
        for (i2 = 0; i2 < this.cols(); ++i2) {
            for (int j = 0; j < this.rows(); ++j) {
                arrWidth[i2 + 1] = Math.max(arrWidth[i2 + 1], nf.format(this.get(j, i2)).length());
            }
        }
        StringBuilder sbAll = new StringBuilder();
        for (i = 0; i < arrWidth.length; ++i) {
            int w = arrWidth[i];
            StringBuilder sb = new StringBuilder(liRowTags.get(i));
            int l = w - sb.length();
            for (int j = 0; j < l; ++j) {
                sb.append(" ");
            }
            sbAll.append(sb.toString());
            sbAll.append(" ");
        }
        sbAll.append("\n");
        for (i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < arrWidth.length; ++j) {
                int w = arrWidth[j];
                StringBuilder sb = new StringBuilder(nf.format(this.get(i, j)));
                int l = w - sb.length();
                for (int k = 0; k < l; ++k) {
                    sb.append(" ");
                }
                sbAll.append(sb.toString());
                sbAll.append(" ");
            }
            sbAll.append("\n");
        }
        return sbAll.toString();
    }

    public void writeSerialized(File fiOut) throws IOException {
        FileOutputStream fos = new FileOutputStream(fiOut);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(this.data);
        oos.close();
    }

    public static Matrix readSerialized(File fiIn) throws FileNotFoundException, IOException, ClassNotFoundException {
        Matrix ma = null;
        FileInputStream fos = new FileInputStream(fiIn);
        ObjectInputStream ois = new ObjectInputStream(fos);
        double[][] data = (double[][])ois.readObject();
        ma = new Matrix(data);
        ois.close();
        return ma;
    }

    public static DecimalFormat format(int digits) {
        String sFormat = "##,###";
        if (digits > 0) {
            sFormat = sFormat + ".";
            for (int iCounter = 0; iCounter < digits; ++iCounter) {
                sFormat = sFormat + "0";
            }
        }
        return new DecimalFormat(sFormat);
    }

    public void write(String sFile, boolean bApppend, int digits, int totalWidth) {
        try {
            DecimalFormat nf = Matrix.format(digits);
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(sFile), bApppend));
            StringBuffer sVal = new StringBuffer();
            for (int ii = 0; ii < this.data.length; ++ii) {
                sVal = new StringBuffer();
                for (int jj = 0; jj < this.data[0].length; ++jj) {
                    sVal.append(Matrix.format(this.data[ii][jj], nf, totalWidth) + OUT_SEPARATOR_COL);
                }
                writer.write(sVal.toString());
                if (ii >= this.data.length - 1) continue;
                writer.write(OUT_SEPARATOR_ROW);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String format(double val, DecimalFormat nf, int totalWidth) {
        String str = "";
        str = nf.format(val);
        while (str.length() < totalWidth) {
            str = " " + str;
        }
        return str;
    }
}

