/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.combinatorics;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CombinationGenerator {
    public static List<int[]> getAllOutOf(int nObjects, int sampleSize) {
        ArrayList<int[]> li = new ArrayList<int[]>();
        int[] arrCounters = new int[sampleSize];
        if (nObjects == sampleSize) {
            int[] arr = new int[sampleSize];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = i;
            }
            li.add(arr);
            return li;
        }
        if (sampleSize == 1) {
            int i = 0;
            while (i < nObjects) {
                int[] arr = new int[]{i++};
                li.add(arr);
            }
            return li;
        }
        if (sampleSize > nObjects) {
            return null;
        }
        for (int i = 0; i < arrCounters.length; ++i) {
            arrCounters[i] = i;
        }
        boolean proceed = true;
        while (proceed) {
            int depth;
            int[] arr = new int[sampleSize];
            for (int i = 0; i < sampleSize; ++i) {
                arr[i] = arrCounters[i];
            }
            li.add(arr);
            int n = depth = sampleSize - 1;
            arrCounters[n] = arrCounters[n] + 1;
            boolean counterFieldReset = false;
            if (arrCounters[depth] >= nObjects) {
                counterFieldReset = true;
            }
            while (counterFieldReset) {
                counterFieldReset = false;
                int n2 = --depth;
                arrCounters[n2] = arrCounters[n2] + 1;
                for (int i = depth + 1; i < sampleSize; ++i) {
                    arrCounters[i] = arrCounters[i - 1] + 1;
                    if (arrCounters[i] < nObjects) continue;
                    counterFieldReset = true;
                }
                if (depth != 0) continue;
            }
            if (!counterFieldReset) continue;
            proceed = false;
        }
        return li;
    }

    public static List<int[]> getCombinations(List<int[]> li) {
        int nCombinations = 1;
        for (int[] arr : li) {
            nCombinations *= arr.length;
        }
        ArrayList<int[]> liComb = new ArrayList<int[]>(nCombinations);
        for (int i = 0; i < nCombinations; ++i) {
            int[] arrComb = new int[li.size()];
            liComb.add(arrComb);
        }
        int nCombCol = 1;
        for (int col = 0; col < li.size(); ++col) {
            int nRepetitions = nCombinations / (nCombCol *= li.get(col).length);
            int[] arr = li.get(col);
            int indexArr = 0;
            int row = 0;
            while (row < nCombinations) {
                for (int i = 0; i < nRepetitions; ++i) {
                    int[] arrComb = (int[])liComb.get(row);
                    arrComb[col] = arr[indexArr];
                    ++row;
                }
                if (++indexArr != arr.length) continue;
                indexArr = 0;
            }
        }
        return liComb;
    }

    private static void swap(int[] input, int a, int b) {
        int tmp = input[a];
        input[a] = input[b];
        input[b] = tmp;
    }

    public static List<int[]> getPermutations(int[] elements, int n) {
        ArrayList<int[]> permutations = new ArrayList<int[]>();
        int[] indexes = new int[n];
        int i = 0;
        permutations.add(Arrays.copyOf(elements, elements.length));
        while (i < n) {
            if (indexes[i] < i) {
                CombinationGenerator.swap(elements, i % 2 == 0 ? 0 : indexes[i], i);
                permutations.add(Arrays.copyOf(elements, elements.length));
                int n2 = i;
                indexes[n2] = indexes[n2] + 1;
                i = 0;
                continue;
            }
            indexes[i] = 0;
            ++i;
        }
        return permutations;
    }

    public static <T> List<List<T>> cartesianProduct(List<List<T>> lists) {
        ArrayList<List<T>> resultLists = new ArrayList<List<T>>();
        if (lists.size() == 0) {
            resultLists.add(new ArrayList());
            return resultLists;
        }
        List<T> firstList = lists.get(0);
        List<List<T>> remainingLists = CombinationGenerator.cartesianProduct(lists.subList(1, lists.size()));
        for (T condition : firstList) {
            for (List<T> remainingList : remainingLists) {
                ArrayList<T> resultList = new ArrayList<T>();
                resultList.add(condition);
                resultList.addAll(remainingList);
                resultLists.add(resultList);
            }
        }
        return resultLists;
    }

    public static BigInteger getFactorial(int n) {
        BigInteger fact = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            fact = fact.multiply(new BigInteger(Integer.toString(i)));
        }
        return fact;
    }

    public static BigInteger getBinomialCoefficient(int n, int k) {
        BigInteger nFac = CombinationGenerator.getFactorial(n);
        BigInteger kFac = CombinationGenerator.getFactorial(k);
        BigInteger nMinus_k_Fac = CombinationGenerator.getFactorial(n - k);
        BigInteger dev = nMinus_k_Fac.multiply(kFac);
        BigInteger bc = nFac.divide(dev);
        return bc;
    }

    public static void main(String[] args) {
        int l = 3;
        int[] r = new int[l];
        for (int i = 0; i < l; ++i) {
            r[i] = i;
        }
        List<int[]> permutations = CombinationGenerator.getPermutations(r, r.length);
        for (int[] per : permutations) {
            System.out.println(Arrays.toString(per));
        }
        System.out.println(permutations.size());
    }
}

